/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.openecard.common.util.ByteUtils;

public class EAC1OutputType {
    public static final String RETRY_COUNTER = "RetryCounter";
    public static final String CHAT = "CertificateHolderAuthorizationTemplate";
    public static final String CAR = "CertificationAuthorityReference";
    public static final String EF_CARDACCESS = "EFCardAccess";
    public static final String ID_PICC = "IDPICC";
    public static final String CHALLENGE = "Challenge";
    private final AuthDataMap authMap;
    private Integer retryCounter;
    private byte[] chat;
    private byte[] currentCar;
    private byte[] previousCar;
    private byte[] efCardAccess;
    private byte[] idpicc;
    private byte[] challenge;

    protected EAC1OutputType(AuthDataMap authMap) {
        this.authMap = authMap;
    }

    public void setRetryCounter(Integer retryCounter) {
        this.retryCounter = retryCounter;
    }

    public void setCHAT(byte[] chat) {
        this.chat = chat;
    }

    public void setCurrentCAR(byte[] car) {
        this.currentCar = car;
    }

    public void setPreviousCAR(byte[] car) {
        this.previousCar = car;
    }

    public void setEFCardAccess(byte[] efCardAccess) {
        this.efCardAccess = efCardAccess;
    }

    public void setIDPICC(byte[] idpicc) {
        this.idpicc = idpicc;
    }

    public void setChallenge(byte[] challenge) {
        this.challenge = challenge;
    }

    public DIDAuthenticationDataType getAuthDataType() {
        AuthDataResponse<iso.std.iso_iec._24727.tech.schema.EAC1OutputType> authResponse = this.authMap.createResponse(new iso.std.iso_iec._24727.tech.schema.EAC1OutputType());
        boolean carAsString = Boolean.valueOf(OpenecardProperties.getProperty("legacy.car"));
        if (this.retryCounter != null) {
            authResponse.addElement(RETRY_COUNTER, String.valueOf(this.retryCounter));
        }
        authResponse.addElement(CHAT, ByteUtils.toHexString(this.chat));
        authResponse.addElement(CAR, carAsString ? new String(this.currentCar) : ByteUtils.toHexString(this.currentCar));
        if (this.previousCar != null) {
            authResponse.addElement(CAR, carAsString ? new String(this.previousCar) : ByteUtils.toHexString(this.previousCar));
        }
        authResponse.addElement(EF_CARDACCESS, ByteUtils.toHexString(this.efCardAccess));
        authResponse.addElement(ID_PICC, ByteUtils.toHexString(this.idpicc));
        authResponse.addElement(CHALLENGE, ByteUtils.toHexString(this.challenge));
        return authResponse.getResponse();
    }
}

