/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac.anytype;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.common.I18nKey;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.StringUtils;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificateChain;
import org.openecard.sal.protocol.eac.anytype.EAC1OutputType;
import org.openecard.sal.protocol.eac.anytype.ElementParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EAC1InputType {
    private static final Logger logger = LoggerFactory.getLogger(EAC1InputType.class);
    public static final String CERTIFICATE = "Certificate";
    public static final String CERTIFICATE_DESCRIPTION = "CertificateDescription";
    public static final String PROVIDER_INFO = "ProviderInfo";
    public static final String REQUIRED_CHAT = "RequiredCHAT";
    public static final String OPTIONAL_CHAT = "OptionalCHAT";
    public static final String AUTHENTICATED_AUXILIARY_DATA = "AuthenticatedAuxiliaryData";
    public static final String TRANSACTION_INFO = "TransactionInfo";
    private final AuthDataMap authMap;
    private final ArrayList<CardVerifiableCertificate> certificates;
    private final byte[] certificateDescription;
    private final byte[] providerInfo;
    private final byte[] requiredCHAT;
    private final byte[] optionalCHAT;
    private final byte[] authenticatedAuxiliaryData;
    private final String transactionInfo;

    public EAC1InputType(DIDAuthenticationDataType baseType) throws Exception {
        this.parseCertificateDescriptionElement(baseType);
        this.authMap = new AuthDataMap(baseType);
        this.certificates = new ArrayList();
        for (Element element : baseType.getAny()) {
            if (!element.getLocalName().equals(CERTIFICATE)) continue;
            byte[] value = StringUtils.toByteArray(element.getTextContent());
            CardVerifiableCertificate cvc = new CardVerifiableCertificate(value);
            this.certificates.add(cvc);
        }
        this.certificateDescription = this.authMap.getContentAsBytes(CERTIFICATE_DESCRIPTION);
        this.providerInfo = this.authMap.getContentAsBytes(PROVIDER_INFO);
        byte[] requiredCHATtmp = this.authMap.getContentAsBytes(REQUIRED_CHAT);
        byte[] optionalCHATtmp = this.authMap.getContentAsBytes(OPTIONAL_CHAT);
        requiredCHATtmp = requiredCHATtmp == null ? new CHAT().toByteArray() : EAC1InputType.fixChatValue(requiredCHATtmp);
        if (optionalCHATtmp == null) {
            CardVerifiableCertificateChain certChain = new CardVerifiableCertificateChain(this.certificates);
            CardVerifiableCertificate terminalCert = certChain.getTerminalCertificate();
            optionalCHATtmp = terminalCert.getCHAT().toByteArray();
        } else {
            optionalCHATtmp = EAC1InputType.fixChatValue(optionalCHATtmp);
        }
        this.requiredCHAT = requiredCHATtmp;
        this.optionalCHAT = optionalCHATtmp;
        this.authenticatedAuxiliaryData = this.authMap.getContentAsBytes(AUTHENTICATED_AUXILIARY_DATA);
        this.transactionInfo = this.authMap.getContentAsString(TRANSACTION_INFO);
    }

    public ArrayList<CardVerifiableCertificate> getCertificates() {
        return this.certificates;
    }

    @Deprecated
    public byte[] getCertificateDescription() {
        return this.certificateDescription;
    }

    public byte[] getProviderInfo() {
        return this.providerInfo;
    }

    public byte[] getRequiredCHAT() {
        return this.requiredCHAT;
    }

    public byte[] getOptionalCHAT() {
        return this.optionalCHAT;
    }

    public byte[] getAuthenticatedAuxiliaryData() {
        return this.authenticatedAuxiliaryData;
    }

    @Nullable
    public String getTransactionInfo() {
        return this.transactionInfo;
    }

    public EAC1OutputType getOutputType() {
        return new EAC1OutputType(this.authMap);
    }

    private static byte[] fixChatValue(byte[] chat) {
        if (chat.length == 5) {
            logger.warn("Correcting invalid CHAT value '{}'.", (Object)ByteUtils.toHexString(chat));
            String asn1Prefix = "7F4C12060904007F0007030102025305";
            byte[] prefixBytes = StringUtils.toByteArray(asn1Prefix);
            byte[] result = ByteUtils.concatenate(prefixBytes, chat);
            return result;
        }
        return chat;
    }

    private void parseCertificateDescriptionElement(DIDAuthenticationDataType baseType) throws ElementParsingException {
        int counter = 0;
        for (Element element : baseType.getAny()) {
            if (!element.getLocalName().equals(CERTIFICATE_DESCRIPTION) || ++counter <= 1) continue;
            throw new ElementParsingException((I18nKey)ErrorTranslations.INVALID_CERT, new Object[0]);
        }
        if (counter == 0) {
            throw new ElementParsingException((I18nKey)ErrorTranslations.INVALID_CERT, new Object[0]);
        }
    }
}

