/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import java.util.concurrent.Callable;
import org.openecard.addon.ActionInitializationException;
import org.openecard.addon.Context;
import org.openecard.addon.sal.SALProtocolBaseImpl;
import org.openecard.common.DynamicContext;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.interfaces.ObjectSchemaValidator;
import org.openecard.common.interfaces.ObjectValidatorException;
import org.openecard.common.util.FuturePromise;
import org.openecard.common.util.JAXBSchemaValidator;
import org.openecard.common.util.Promise;
import org.openecard.sal.protocol.eac.ChipAuthenticationStep;
import org.openecard.sal.protocol.eac.PACEStep;
import org.openecard.sal.protocol.eac.TerminalAuthenticationStep;

public class EACProtocol
extends SALProtocolBaseImpl {
    private static final String PREFIX = "org.openecard.tr03112.eac.";
    public static final String EAC_DATA = "org.openecard.tr03112.eac.eac_data";
    public static final String PIN_STATUS_BYTES = "org.openecard.tr03112.eac.pin_status_bytes";
    public static final String IS_NATIVE_PACE = "org.openecard.tr03112.eac.is_native_pace";
    public static final String PACE_MARKER = "org.openecard.tr03112.eac.pace_marker";
    public static final String PACE_EXCEPTION = "org.openecard.tr03112.eac.pace_successful";
    public static final String GUI_RESULT = "org.openecard.tr03112.eac.gui_result";
    public static final String SLOT_HANDLE = "org.openecard.tr03112.eac.slot_handle";
    public static final String DISPATCHER = "org.openecard.tr03112.eac.dispatcher";
    public static final String SCHEMA_VALIDATOR = "org.openecard.tr03112.eac.schema_validator";
    public static final String AUTHENTICATION_DONE = "org.openecard.tr03112.eac.authentication_done";
    public static final String AUTHENTICATION_FAILED = "org.openecard.tr03112.eac.authentication_failed";

    @Override
    public void init(Context ctx) throws ActionInitializationException {
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        dynCtx.putPromise(SCHEMA_VALIDATOR, new FuturePromise<ObjectSchemaValidator>(new Callable<ObjectSchemaValidator>(){

            @Override
            public ObjectSchemaValidator call() throws Exception {
                boolean noValid = Boolean.valueOf(OpenecardProperties.getProperty("legacy.ignore_ns"));
                ObjectSchemaValidator v = !noValid ? JAXBSchemaValidator.load(DIDAuthenticate.class, "ISO24727-Protocols.xsd") : new ObjectSchemaValidator(){

                    @Override
                    public boolean validateObject(Object obj) throws ObjectValidatorException {
                        return true;
                    }
                };
                return v;
            }
        }));
        this.addOrderStep(new PACEStep(ctx.getDispatcher(), ctx.getUserConsent(), ctx.getEventDispatcher()));
        this.addOrderStep(new TerminalAuthenticationStep(ctx.getDispatcher()));
        this.addOrderStep(new ChipAuthenticationStep(ctx.getDispatcher()));
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean isFinished() {
        boolean finished = super.isFinished();
        if (!finished) {
            Promise<Object> p2;
            DynamicContext ctx = DynamicContext.getInstance("tr03112");
            Promise<Object> p = ctx.getPromise(AUTHENTICATION_DONE);
            if (p.isDelivered()) {
                try {
                    finished = (Boolean)p.deref();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if ((p2 = ctx.getPromise(AUTHENTICATION_FAILED)).isDelivered()) {
                try {
                    finished = (Boolean)p2.deref();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return finished;
    }
}

