/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import iso.std.iso_iec._24727.tech.schema.DestroyChannel;
import org.openecard.common.apdu.GeneralAuthenticate;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.apdu.utils.CardUtils;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.sal.protocol.exception.ProtocolException;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.FCP;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.ShortUtils;
import org.openecard.sal.protocol.eac.apdu.MSESetATCA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChipAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(ChipAuthentication.class);
    private final Dispatcher dispatcher;
    private final byte[] slotHandle;

    public ChipAuthentication(Dispatcher dispatcher, byte[] slotHandle) {
        this.dispatcher = dispatcher;
        this.slotHandle = slotHandle;
    }

    public void mseSetAT(byte[] oID, byte[] keyID) throws ProtocolException {
        try {
            MSESetATCA mseSetAT = new MSESetATCA(oID, keyID);
            mseSetAT.transmit(this.dispatcher, this.slotHandle);
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }

    public byte[] generalAuthenticate(byte[] key) throws ProtocolException {
        try {
            if (key[0] != 4) {
                key = ByteUtils.concatenate((byte)4, key);
            }
            GeneralAuthenticate generalAuthenticate = new GeneralAuthenticate(-128, key);
            CardResponseAPDU response = generalAuthenticate.transmit(this.dispatcher, this.slotHandle);
            return response.getData();
        }
        catch (APDUException e) {
            throw new ProtocolException(e.getResult());
        }
    }

    public byte[] readEFCardSecurity() throws ProtocolException {
        try {
            byte[] file = ShortUtils.toByteArray((short)285);
            CardResponseAPDU resp = CardUtils.selectFileWithOptions(this.dispatcher, this.slotHandle, file, null, 1);
            FCP efCardSecurityFCP = new FCP(TLV.fromBER(resp.getData()));
            byte[] efCardSecurity = CardUtils.readFile(efCardSecurityFCP, this.dispatcher, this.slotHandle);
            return efCardSecurity;
        }
        catch (APDUException ex) {
            throw new ProtocolException(ex.getResult());
        }
        catch (TLVException ex) {
            throw new ProtocolException("Failed to parse FCP.", ex);
        }
    }

    public void destroySecureChannel() {
        DestroyChannel destroyChannel = new DestroyChannel();
        destroyChannel.setSlotHandle(this.slotHandle);
        this.dispatcher.safeDeliver(destroyChannel);
    }
}

