/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal.protocol.eac;

import java.util.Map;
import org.openecard.common.sal.protocol.exception.ProtocolException;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.IntegerUtils;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.eac.AuthenticatedAuxiliaryData;
import org.openecard.crypto.common.asn1.eac.CADomainParameter;
import org.openecard.crypto.common.asn1.eac.CASecurityInfos;
import org.openecard.crypto.common.asn1.eac.SecurityInfos;
import org.openecard.crypto.common.asn1.eac.ef.EFCardAccess;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.openecard.sal.protocol.eac.ChipAuthentication;
import org.openecard.sal.protocol.eac.TerminalAuthentication;
import org.openecard.sal.protocol.eac.anytype.EAC2OutputType;
import org.openecard.sal.protocol.eac.crypto.CAKey;

public class AuthenticationHelper {
    private final TerminalAuthentication ta;
    private final ChipAuthentication ca;

    public AuthenticationHelper(TerminalAuthentication ta, ChipAuthentication ca) {
        this.ta = ta;
        this.ca = ca;
    }

    public EAC2OutputType performAuth(EAC2OutputType eac2Output, Map<String, Object> internalData) throws ProtocolException, TLVException {
        CardVerifiableCertificate terminalCertificate = (CardVerifiableCertificate)internalData.get("TerminalCertificate");
        byte[] key = (byte[])internalData.get("PKPCD");
        byte[] signature = (byte[])internalData.get("Signature");
        SecurityInfos securityInfos = (SecurityInfos)internalData.get("SecurityInfos");
        AuthenticatedAuxiliaryData aadObj = (AuthenticatedAuxiliaryData)internalData.get("AuthenticatedAuxiliaryData");
        byte[] oid = ObjectIdentifierUtils.getValue(terminalCertificate.getPublicKey().getObjectIdentifier());
        byte[] chr = terminalCertificate.getCHR().toByteArray();
        byte[] aad = aadObj.getData();
        EFCardAccess efca = new EFCardAccess(securityInfos);
        CASecurityInfos cas = efca.getCASecurityInfos();
        CADomainParameter cdp = new CADomainParameter(cas);
        CAKey caKey = new CAKey(cdp);
        caKey.decodePublicKey(key);
        byte[] compKey = caKey.getEncodedCompressedPublicKey();
        this.ta.mseSetAT(oid, chr, compKey, aad);
        this.ta.externalAuthentication(signature);
        byte[] efCardSecurity = this.ca.readEFCardSecurity();
        byte[] oID = ObjectIdentifierUtils.getValue(cas.getCAInfo().getProtocol());
        byte[] keyID = IntegerUtils.toByteArray(cas.getCAInfo().getKeyID());
        this.ca.mseSetAT(oID, keyID);
        byte[] responseData = this.ca.generalAuthenticate(key);
        TLV tlv = TLV.fromBER(responseData);
        byte[] nonce = tlv.findChildTags(129L).get(0).getValue();
        byte[] token = tlv.findChildTags(130L).get(0).getValue();
        this.ca.destroySecureChannel();
        eac2Output.setEFCardSecurity(efCardSecurity);
        eac2Output.setNonce(nonce);
        eac2Output.setToken(token);
        return eac2Output;
    }
}

