/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.ACLModify;
import iso.std.iso_iec._24727.tech.schema.ACLModifyResponse;
import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.AuthorizationServiceActionName;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationCreate;
import iso.std.iso_iec._24727.tech.schema.CardApplicationCreateResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDelete;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSessionResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationSelect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationSelectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceActionName;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceCreate;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceCreateResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDelete;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDescribe;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDescribeResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceLoad;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceLoadResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSessionResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationType;
import iso.std.iso_iec._24727.tech.schema.Connect;
import iso.std.iso_iec._24727.tech.schema.ConnectResponse;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionServiceActionName;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.DIDCreate;
import iso.std.iso_iec._24727.tech.schema.DIDCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDDelete;
import iso.std.iso_iec._24727.tech.schema.DIDDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDInfoType;
import iso.std.iso_iec._24727.tech.schema.DIDList;
import iso.std.iso_iec._24727.tech.schema.DIDListResponse;
import iso.std.iso_iec._24727.tech.schema.DIDNameListType;
import iso.std.iso_iec._24727.tech.schema.DIDQualifierType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DIDUpdate;
import iso.std.iso_iec._24727.tech.schema.DIDUpdateDataType;
import iso.std.iso_iec._24727.tech.schema.DIDUpdateResponse;
import iso.std.iso_iec._24727.tech.schema.DSICreate;
import iso.std.iso_iec._24727.tech.schema.DSICreateResponse;
import iso.std.iso_iec._24727.tech.schema.DSIDelete;
import iso.std.iso_iec._24727.tech.schema.DSIDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DSIList;
import iso.std.iso_iec._24727.tech.schema.DSIListResponse;
import iso.std.iso_iec._24727.tech.schema.DSINameListType;
import iso.std.iso_iec._24727.tech.schema.DSIRead;
import iso.std.iso_iec._24727.tech.schema.DSIReadResponse;
import iso.std.iso_iec._24727.tech.schema.DSIType;
import iso.std.iso_iec._24727.tech.schema.DSIWrite;
import iso.std.iso_iec._24727.tech.schema.DSIWriteResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetCreate;
import iso.std.iso_iec._24727.tech.schema.DataSetCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetDelete;
import iso.std.iso_iec._24727.tech.schema.DataSetDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetInfoType;
import iso.std.iso_iec._24727.tech.schema.DataSetList;
import iso.std.iso_iec._24727.tech.schema.DataSetListResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetNameListType;
import iso.std.iso_iec._24727.tech.schema.DataSetSelect;
import iso.std.iso_iec._24727.tech.schema.DataSetSelectResponse;
import iso.std.iso_iec._24727.tech.schema.Decipher;
import iso.std.iso_iec._24727.tech.schema.DecipherResponse;
import iso.std.iso_iec._24727.tech.schema.DifferentialIdentityServiceActionName;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import iso.std.iso_iec._24727.tech.schema.DisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.Encipher;
import iso.std.iso_iec._24727.tech.schema.EncipherResponse;
import iso.std.iso_iec._24727.tech.schema.ExecuteAction;
import iso.std.iso_iec._24727.tech.schema.ExecuteActionResponse;
import iso.std.iso_iec._24727.tech.schema.GetRandom;
import iso.std.iso_iec._24727.tech.schema.GetRandomResponse;
import iso.std.iso_iec._24727.tech.schema.Hash;
import iso.std.iso_iec._24727.tech.schema.HashResponse;
import iso.std.iso_iec._24727.tech.schema.Initialize;
import iso.std.iso_iec._24727.tech.schema.InitializeResponse;
import iso.std.iso_iec._24727.tech.schema.NamedDataServiceActionName;
import iso.std.iso_iec._24727.tech.schema.PathType;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import iso.std.iso_iec._24727.tech.schema.Terminate;
import iso.std.iso_iec._24727.tech.schema.TerminateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificate;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifySignature;
import iso.std.iso_iec._24727.tech.schema.VerifySignatureResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.addon.AddonManager;
import org.openecard.addon.AddonNotFoundException;
import org.openecard.addon.AddonSelector;
import org.openecard.addon.HighestVersionSelector;
import org.openecard.addon.sal.FunctionType;
import org.openecard.addon.sal.SALProtocol;
import org.openecard.common.ECardException;
import org.openecard.common.ThreadTerminateException;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.DeleteFile;
import org.openecard.common.apdu.EraseBinary;
import org.openecard.common.apdu.EraseRecord;
import org.openecard.common.apdu.GetData;
import org.openecard.common.apdu.GetResponse;
import org.openecard.common.apdu.ReadBinary;
import org.openecard.common.apdu.ReadRecord;
import org.openecard.common.apdu.Select;
import org.openecard.common.apdu.UpdateBinary;
import org.openecard.common.apdu.UpdateRecord;
import org.openecard.common.apdu.WriteBinary;
import org.openecard.common.apdu.WriteRecord;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.common.TrailerConstants;
import org.openecard.common.apdu.utils.CardUtils;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.InvocationTargetExceptionUnchecked;
import org.openecard.common.interfaces.Publish;
import org.openecard.common.sal.Assert;
import org.openecard.common.sal.exception.InappropriateProtocolForActionException;
import org.openecard.common.sal.exception.IncorrectParameterException;
import org.openecard.common.sal.exception.NameExistsException;
import org.openecard.common.sal.exception.NamedEntityNotFoundException;
import org.openecard.common.sal.exception.PrerequisitesNotSatisfiedException;
import org.openecard.common.sal.exception.SecurityConditionNotSatisfiedException;
import org.openecard.common.sal.exception.UnknownConnectionHandleException;
import org.openecard.common.sal.exception.UnknownProtocolException;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.cif.CardApplicationWrapper;
import org.openecard.common.sal.state.cif.CardInfoWrapper;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.DataElements;
import org.openecard.common.tlv.iso7816.FCP;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.sal.did.CryptoMarkerType;
import org.openecard.gui.UserConsent;
import org.openecard.ws.SAL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinySAL
implements SAL {
    private static final Logger LOG = LoggerFactory.getLogger(TinySAL.class);
    private static final byte[] MF = new byte[]{63, 0};
    private final Environment env;
    private final CardStateMap states;
    private AddonSelector protocolSelector;
    private UserConsent userConsent;

    public TinySAL(Environment env, CardStateMap states) {
        this.env = env;
        this.states = states;
    }

    public void setAddonManager(AddonManager manager) {
        this.protocolSelector = new AddonSelector(manager);
        this.protocolSelector.setStrategy(new HighestVersionSelector());
    }

    @Override
    public InitializeResponse initialize(Initialize request) {
        InitializeResponse res = (InitializeResponse)WSHelper.makeResponse(InitializeResponse.class, WSHelper.makeResultOK());
        return res;
    }

    @Override
    public TerminateResponse terminate(Terminate request) {
        TerminateResponse res = (TerminateResponse)WSHelper.makeResponse(TerminateResponse.class, WSHelper.makeResultOK());
        return res;
    }

    @Override
    public CardApplicationPathResponse cardApplicationPath(CardApplicationPath request) {
        CardApplicationPathResponse response = (CardApplicationPathResponse)WSHelper.makeResponse(CardApplicationPathResponse.class, WSHelper.makeResultOK());
        try {
            CardApplicationPathType cardAppPath = request.getCardAppPathRequest();
            Assert.assertIncorrectParameter(cardAppPath, "The parameter CardAppPathRequest is empty.");
            Set<CardStateEntry> entries = this.states.getMatchingEntries(cardAppPath);
            CardApplicationPathResponse.CardAppPathResultSet resultSet = new CardApplicationPathResponse.CardAppPathResultSet();
            List<CardApplicationPathType> resultPaths = resultSet.getCardApplicationPathResult();
            for (CardStateEntry entry : entries) {
                CardApplicationPathType pathCopy = entry.pathCopy();
                if (cardAppPath.getCardApplication() != null) {
                    pathCopy.setCardApplication(cardAppPath.getCardApplication());
                } else if (entry.getImplicitlySelectedApplicationIdentifier() != null) {
                    pathCopy.setCardApplication(entry.getImplicitlySelectedApplicationIdentifier());
                } else {
                    LOG.warn("No CardApplication and ImplicitlySelectedApplication available using MF now.");
                    pathCopy.setCardApplication(MF);
                }
                resultPaths.add(pathCopy);
            }
            response.setCardAppPathResultSet(resultSet);
        }
        catch (IncorrectParameterException e) {
            response.setResult(e.getResult());
        }
        return response;
    }

    @Override
    public CardApplicationConnectResponse cardApplicationConnect(CardApplicationConnect request) {
        CardApplicationConnectResponse response = (CardApplicationConnectResponse)WSHelper.makeResponse(CardApplicationConnectResponse.class, WSHelper.makeResultOK());
        try {
            CardApplicationPathType cardAppPath = request.getCardApplicationPath();
            Assert.assertIncorrectParameter(cardAppPath, "The parameter CardAppPathRequest is empty.");
            Set<CardStateEntry> cardStateEntrySet = this.states.getMatchingEntries(cardAppPath, false);
            Assert.assertIncorrectParameter(cardStateEntrySet, "The given ConnectionHandle is invalid.");
            CardStateEntry cardStateEntry = cardStateEntrySet.iterator().next();
            byte[] applicationID = cardAppPath.getCardApplication();
            if (applicationID == null) {
                applicationID = cardStateEntry.getImplicitlySelectedApplicationIdentifier() != null ? cardStateEntry.getImplicitlySelectedApplicationIdentifier() : MF;
            }
            Assert.securityConditionApplication(cardStateEntry, applicationID, ConnectionServiceActionName.CARD_APPLICATION_CONNECT);
            ConnectionHandleType handle = cardStateEntry.handleCopy();
            cardStateEntry = cardStateEntry.derive(handle);
            Connect connect = new Connect();
            connect.setContextHandle(handle.getContextHandle());
            connect.setIFDName(handle.getIFDName());
            connect.setSlot(handle.getSlotIndex());
            ConnectResponse connectResponse = (ConnectResponse)this.env.getDispatcher().safeDeliver(connect);
            WSHelper.checkResult(connectResponse);
            if (applicationID.length == 2) {
                Select select = new Select.File(applicationID);
                ArrayList<byte[]> responses = new ArrayList<byte[]>();
                responses.add(TrailerConstants.Success.OK());
                responses.add(TrailerConstants.Error.WRONG_P1_P2());
                CardResponseAPDU resp = select.transmit(this.env.getDispatcher(), connectResponse.getSlotHandle(), responses);
                if (Arrays.equals(resp.getTrailer(), TrailerConstants.Error.WRONG_P1_P2())) {
                    select = new Select.AbsolutePath(applicationID);
                    select.transmit(this.env.getDispatcher(), connectResponse.getSlotHandle());
                }
            } else {
                Select.Application select = new Select.Application(applicationID);
                select.transmit(this.env.getDispatcher(), connectResponse.getSlotHandle());
            }
            cardStateEntry.setCurrentCardApplication(applicationID);
            cardStateEntry.setSlotHandle(connectResponse.getSlotHandle());
            cardStateEntry.unsetFCPOfSelectedEF();
            this.states.addEntry(cardStateEntry);
            response.setConnectionHandle(cardStateEntry.handleCopy());
            response.getConnectionHandle().setCardApplication(applicationID);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        return response;
    }

    @Override
    public CardApplicationSelectResponse cardApplicationSelect(CardApplicationSelect request) {
        CardApplicationSelectResponse response = (CardApplicationSelectResponse)WSHelper.makeResponse(CardApplicationSelectResponse.class, WSHelper.makeResultOK());
        try {
            byte[] slotHandle = request.getSlotHandle();
            ConnectionHandleType connectionHandle = SALUtils.createConnectionHandle(slotHandle);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] reqApplicationID = request.getCardApplication();
            Assert.assertIncorrectParameter(reqApplicationID, "The parameter CardApplication is empty.");
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            CardApplicationWrapper appInfo = cardInfoWrapper.getCardApplication(reqApplicationID);
            Assert.assertNamedEntityNotFound(appInfo, "The given Application cannot be found.");
            Assert.securityConditionApplication(cardStateEntry, reqApplicationID, ConnectionServiceActionName.CARD_APPLICATION_CONNECT);
            byte[] curApplicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            if (!ByteUtils.compare(reqApplicationID, curApplicationID)) {
                if (reqApplicationID.length == 2) {
                    Select select = new Select.File(reqApplicationID);
                    ArrayList<byte[]> responses = new ArrayList<byte[]>();
                    responses.add(TrailerConstants.Success.OK());
                    responses.add(TrailerConstants.Error.WRONG_P1_P2());
                    CardResponseAPDU resp = select.transmit(this.env.getDispatcher(), slotHandle, responses);
                    if (Arrays.equals(resp.getTrailer(), TrailerConstants.Error.WRONG_P1_P2())) {
                        select = new Select.AbsolutePath(reqApplicationID);
                        select.transmit(this.env.getDispatcher(), slotHandle);
                    }
                } else {
                    Select.Application select = new Select.Application(reqApplicationID);
                    select.transmit(this.env.getDispatcher(), slotHandle);
                }
                cardStateEntry.setCurrentCardApplication(reqApplicationID);
                cardStateEntry.unsetFCPOfSelectedEF();
            }
            response.setConnectionHandle(cardStateEntry.handleCopy());
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        return response;
    }

    @Override
    public CardApplicationDisconnectResponse cardApplicationDisconnect(CardApplicationDisconnect request) {
        CardApplicationDisconnectResponse response = (CardApplicationDisconnectResponse)WSHelper.makeResponse(CardApplicationDisconnectResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            byte[] slotHandle = connectionHandle.getSlotHandle();
            if (slotHandle == null) {
                return (CardApplicationDisconnectResponse)WSHelper.makeResponse(CardApplicationDisconnectResponse.class, WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#incorrectParameter", "ConnectionHandle is null"));
            }
            Disconnect disconnect = new Disconnect();
            disconnect.setSlotHandle(slotHandle);
            if (request.getAction() != null) {
                disconnect.setAction(request.getAction());
            }
            DisconnectResponse disconnectResponse = (DisconnectResponse)this.env.getDispatcher().safeDeliver(disconnect);
            this.states.removeSlotHandleEntry(slotHandle);
            response.setResult(disconnectResponse.getResult());
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public CardApplicationStartSessionResponse cardApplicationStartSession(CardApplicationStartSession request) {
        CardApplicationStartSessionResponse response = (CardApplicationStartSessionResponse)WSHelper.makeResponse(CardApplicationStartSessionResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            String didName = SALUtils.getDIDName(request);
            Assert.assertIncorrectParameter(didName, "The parameter didName is empty.");
            DIDAuthenticationDataType didAuthenticationProtocolData = request.getAuthenticationProtocolData();
            Assert.assertIncorrectParameter(didAuthenticationProtocolData, "The parameter didAuthenticationProtocolData is empty.");
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, cardApplicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            Assert.securityConditionApplication(cardStateEntry, cardApplicationID, ConnectionServiceActionName.CARD_APPLICATION_START_SESSION);
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.CardApplicationStartSession)) {
                throw new InappropriateProtocolForActionException("CardApplicationStartSession", protocol.toString());
            }
            response = protocol.cardApplicationStartSession(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public CardApplicationEndSessionResponse cardApplicationEndSession(CardApplicationEndSession request) {
        CardApplicationEndSessionResponse response = (CardApplicationEndSessionResponse)WSHelper.makeResponse(CardApplicationEndSessionResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            String didName = SALUtils.getDIDName(request);
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, cardApplicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            Assert.securityConditionApplication(cardStateEntry, cardApplicationID, ConnectionServiceActionName.CARD_APPLICATION_END_SESSION);
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, null, protocolURI);
            if (!protocol.hasNextStep(FunctionType.CardApplicationEndSession)) {
                throw new InappropriateProtocolForActionException("CardApplicationEndSession", protocol.toString());
            }
            response = protocol.cardApplicationEndSession(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public CardApplicationListResponse cardApplicationList(CardApplicationList request) {
        CardApplicationListResponse response = (CardApplicationListResponse)WSHelper.makeResponse(CardApplicationListResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            CardApplicationListResponse.CardApplicationNameList cardApplicationNameList = new CardApplicationListResponse.CardApplicationNameList();
            cardApplicationNameList.getCardApplicationName().addAll(cardInfoWrapper.getCardApplicationNameList());
            response.setCardApplicationNameList(cardApplicationNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public CardApplicationCreateResponse cardApplicationCreate(CardApplicationCreate request) {
        return (CardApplicationCreateResponse)WSHelper.makeResponse(CardApplicationCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationDeleteResponse cardApplicationDelete(CardApplicationDelete request) {
        CardApplicationDeleteResponse response = (CardApplicationDeleteResponse)WSHelper.makeResponse(CardApplicationDeleteResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] cardApplicationName = request.getCardApplicationName();
            Assert.assertIncorrectParameter(cardApplicationName, "The parameter CardApplicationName is empty.");
            Assert.securityConditionApplication(cardStateEntry, connectionHandle.getCardApplication(), CardApplicationServiceActionName.CARD_APPLICATION_DELETE);
            DeleteFile.Application delFile = new DeleteFile.Application(cardApplicationName);
            delFile.transmit(this.env.getDispatcher(), connectionHandle.getSlotHandle());
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public CardApplicationServiceListResponse cardApplicationServiceList(CardApplicationServiceList request) {
        CardApplicationServiceListResponse response = (CardApplicationServiceListResponse)WSHelper.makeResponse(CardApplicationServiceListResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            CardApplicationServiceListResponse.CardApplicationServiceNameList cardApplicationServiceNameList = new CardApplicationServiceListResponse.CardApplicationServiceNameList();
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            for (CardApplicationType next : cardInfoWrapper.getApplicationCapabilities().getCardApplication()) {
                byte[] appName = next.getApplicationIdentifier();
                if (!Arrays.equals(appName, cardApplicationID)) continue;
                for (CardApplicationServiceType nextt : next.getCardApplicationServiceInfo()) {
                    cardApplicationServiceNameList.getCardApplicationServiceName().add(nextt.getCardApplicationServiceName());
                }
            }
            response.setCardApplicationServiceNameList(cardApplicationServiceNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public CardApplicationServiceCreateResponse cardApplicationServiceCreate(CardApplicationServiceCreate request) {
        return (CardApplicationServiceCreateResponse)WSHelper.makeResponse(CardApplicationServiceCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationServiceLoadResponse cardApplicationServiceLoad(CardApplicationServiceLoad request) {
        return (CardApplicationServiceLoadResponse)WSHelper.makeResponse(CardApplicationServiceLoadResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    public CardApplicationServiceDeleteResponse cardApplicationServiceDelete(CardApplicationServiceDelete request) {
        return (CardApplicationServiceDeleteResponse)WSHelper.makeResponse(CardApplicationServiceDeleteResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    @Publish
    public CardApplicationServiceDescribeResponse cardApplicationServiceDescribe(CardApplicationServiceDescribe request) {
        CardApplicationServiceDescribeResponse response = (CardApplicationServiceDescribeResponse)WSHelper.makeResponse(CardApplicationServiceDescribeResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            String cardApplicationServiceName = request.getCardApplicationServiceName();
            Assert.assertIncorrectParameter(cardApplicationServiceName, "The parameter CardApplicationServiceName is empty.");
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            for (CardApplicationType next : cardInfoWrapper.getApplicationCapabilities().getCardApplication()) {
                byte[] appName = next.getApplicationIdentifier();
                if (!Arrays.equals(appName, cardApplicationID)) continue;
                for (CardApplicationServiceType nextt : next.getCardApplicationServiceInfo()) {
                    if (!nextt.getCardApplicationServiceName().equals(cardApplicationServiceName)) continue;
                    response.setServiceDescription(nextt.getCardApplicationServiceDescription());
                    return response;
                }
            }
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public ExecuteActionResponse executeAction(ExecuteAction request) {
        return (ExecuteActionResponse)WSHelper.makeResponse(ExecuteActionResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    @Publish
    public DataSetListResponse dataSetList(DataSetList request) {
        DataSetListResponse response = (DataSetListResponse)WSHelper.makeResponse(DataSetListResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            Assert.securityConditionApplication(cardStateEntry, cardApplicationID, NamedDataServiceActionName.DATA_SET_LIST);
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            DataSetNameListType dataSetNameList = cardInfoWrapper.getDataSetNameList(cardApplicationID);
            response.setDataSetNameList(dataSetNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DataSetCreateResponse dataSetCreate(DataSetCreate request) {
        return (DataSetCreateResponse)WSHelper.makeResponse(DataSetCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    @Publish
    public DataSetSelectResponse dataSetSelect(DataSetSelect request) {
        DataSetSelectResponse response = (DataSetSelectResponse)WSHelper.makeResponse(DataSetSelectResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            String dataSetName = request.getDataSetName();
            Assert.assertIncorrectParameter(dataSetName, "The parameter DataSetName is empty.");
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            DataSetInfoType dataSetInfo = cardInfoWrapper.getDataSet(dataSetName, applicationID);
            Assert.assertNamedEntityNotFound(dataSetInfo, "The given DataSet cannot be found.");
            Assert.securityConditionDataSet(cardStateEntry, applicationID, dataSetName, NamedDataServiceActionName.DATA_SET_SELECT);
            byte[] fileID = dataSetInfo.getDataSetPath().getEfIdOrPath();
            byte[] slotHandle = connectionHandle.getSlotHandle();
            CardResponseAPDU result = CardUtils.selectFileWithOptions(this.env.getDispatcher(), slotHandle, fileID, null, 1);
            FCP fcp = null;
            if (result != null && result.getData().length > 0) {
                try {
                    fcp = new FCP(result.getData());
                }
                catch (TLVException ex) {
                    LOG.warn("Invalid FCP received.");
                }
            }
            if (fcp == null) {
                LOG.info("Using fake FCP.");
                fcp = new FCP(this.createFakeFCP(Arrays.copyOfRange(fileID, fileID.length - 2, fileID.length)));
            }
            cardStateEntry.setFCPOfSelectedEF(fcp);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DataSetDeleteResponse dataSetDelete(DataSetDelete request) {
        DataSetDeleteResponse response = (DataSetDeleteResponse)WSHelper.makeResponse(DataSetDeleteResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            String dataSetName = request.getDataSetName();
            Assert.assertIncorrectParameter(dataSetName, "The parameter DataSetName is empty.");
            Assert.securityConditionDataSet(cardStateEntry, cardApplicationID, dataSetName, NamedDataServiceActionName.DATA_SET_DELETE);
            DataSetInfoType dataSet = cardInfoWrapper.getDataSet(dataSetName, cardApplicationID);
            if (dataSet == null) {
                throw new NamedEntityNotFoundException("The data set " + dataSetName + " does not exist.");
            }
            byte[] path = dataSet.getDataSetPath().getEfIdOrPath();
            int len = path.length;
            byte[] fid = new byte[]{path[len - 2], path[len - 1]};
            DeleteFile.ChildFile delFile = new DeleteFile.ChildFile(fid);
            delFile.transmit(this.env.getDispatcher(), connectionHandle.getSlotHandle());
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public DSIListResponse dsiList(DSIList request) {
        DSIListResponse response = (DSIListResponse)WSHelper.makeResponse(DSIListResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            if (cardStateEntry.getFCPOfSelectedEF() == null) {
                throw new PrerequisitesNotSatisfiedException("No EF selected.");
            }
            DataSetInfoType dataSet = cardInfoWrapper.getDataSetByFid(cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().get(0));
            Assert.securityConditionDataSet(cardStateEntry, cardApplicationID, dataSet.getDataSetName(), NamedDataServiceActionName.DSI_LIST);
            DSINameListType dsiNameList = new DSINameListType();
            for (DSIType dsi : dataSet.getDSI()) {
                dsiNameList.getDSIName().add(dsi.getDSIName());
            }
            response.setDSINameList(dsiNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DSICreateResponse dsiCreate(DSICreate request) {
        DSICreateResponse response = (DSICreateResponse)WSHelper.makeResponse(DSICreateResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            byte[] dsiContent = request.getDSIContent();
            Assert.assertIncorrectParameter(dsiContent, "The parameter DSIContent is empty.");
            String dsiName = request.getDSIName();
            Assert.assertIncorrectParameter(dsiName, "The parameter DSIName is empty.");
            DSIType dsi = cardInfoWrapper.getDSIbyName(dsiName);
            if (dsi != null) {
                throw new NameExistsException("There is already an DSI with the name " + dsiName + " in the current EF.");
            }
            byte[] slotHandle = connectionHandle.getSlotHandle();
            if (cardStateEntry.getFCPOfSelectedEF() == null) {
                throw new PrerequisitesNotSatisfiedException("No data set for writing selected.");
            }
            DataSetInfoType dataSet = cardInfoWrapper.getDataSetByFid(cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().get(0));
            Assert.securityConditionDataSet(cardStateEntry, cardApplicationID, dataSet.getDataSetName(), NamedDataServiceActionName.DSI_CREATE);
            DataElements dElements = cardStateEntry.getFCPOfSelectedEF().getDataElements();
            if (dElements.isTransparent()) {
                WriteBinary writeBin = new WriteBinary(-48, 0, 0, dsiContent);
                writeBin.transmit(this.env.getDispatcher(), slotHandle);
            } else if (dElements.isCyclic()) {
                WriteRecord writeRec = new WriteRecord(0, 3, dsiContent);
                writeRec.transmit(this.env.getDispatcher(), slotHandle);
            } else {
                WriteRecord writeRec = new WriteRecord(0, 1, dsiContent);
                writeRec.transmit(this.env.getDispatcher(), slotHandle);
            }
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DSIDeleteResponse dsiDelete(DSIDelete request) {
        DSIDeleteResponse response = (DSIDeleteResponse)WSHelper.makeResponse(DSIDeleteResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            String dsiName = request.getDSIName();
            Assert.assertIncorrectParameter(dsiName, "The parameter DSIName is empty.");
            if (cardStateEntry.getFCPOfSelectedEF() == null) {
                String msg = "No DataSet selected for deleting the DSI " + request.getDSIName();
                throw new PrerequisitesNotSatisfiedException(msg);
            }
            DataSetInfoType dataSet = cardInfoWrapper.getDataSetByDsiName(request.getDSIName());
            byte[] fidOrPath = dataSet.getDataSetPath().getEfIdOrPath();
            byte[] dataSetFid = new byte[]{fidOrPath[fidOrPath.length - 2], fidOrPath[fidOrPath.length - 1]};
            if (!Arrays.equals(dataSetFid, cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().get(0))) {
                String msg = "The wrong DataSet for the deletion of DSI " + request.getDSIName() + " is selected.";
                throw new PrerequisitesNotSatisfiedException(msg);
            }
            DataSetInfoType dSet = cardInfoWrapper.getDataSetByFid(cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().get(0));
            Assert.securityConditionDataSet(cardStateEntry, connectionHandle.getCardApplication(), dSet.getDataSetName(), NamedDataServiceActionName.DSI_DELETE);
            DSIType dsi = cardInfoWrapper.getDSIbyName(dsiName);
            ArrayList<byte[]> responses = new ArrayList<byte[]>(){
                {
                    this.add(new byte[]{-112, 0});
                    this.add(new byte[]{99, -63});
                    this.add(new byte[]{99, -62});
                    this.add(new byte[]{99, -61});
                    this.add(new byte[]{99, -60});
                    this.add(new byte[]{99, -59});
                    this.add(new byte[]{99, -58});
                    this.add(new byte[]{99, -57});
                    this.add(new byte[]{99, -56});
                    this.add(new byte[]{99, -55});
                    this.add(new byte[]{99, -54});
                    this.add(new byte[]{99, -53});
                    this.add(new byte[]{99, -52});
                    this.add(new byte[]{99, -51});
                    this.add(new byte[]{99, -50});
                    this.add(new byte[]{99, -49});
                }
            };
            if (cardStateEntry.getFCPOfSelectedEF().getDataElements().isLinear()) {
                EraseRecord rmRecord = new EraseRecord(dsi.getDSIPath().getIndex()[0], 4);
                rmRecord.transmit(this.env.getDispatcher(), connectionHandle.getSlotHandle(), (List<byte[]>)responses);
            } else {
                EraseBinary rmBinary = new EraseBinary(0, 0, dsi.getDSIPath().getIndex());
                rmBinary.transmit(this.env.getDispatcher(), connectionHandle.getSlotHandle(), (List<byte[]>)responses);
            }
        }
        catch (ECardException e) {
            LOG.error(e.getMessage(), e);
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public DSIWriteResponse dsiWrite(DSIWrite request) {
        DSIWriteResponse response = (DSIWriteResponse)WSHelper.makeResponse(DSIWriteResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
            byte[] applicationID = connectionHandle.getCardApplication();
            String dsiName = request.getDSIName();
            byte[] updateData = request.getDSIContent();
            Assert.assertIncorrectParameter(dsiName, "The parameter DSIName is empty.");
            Assert.assertIncorrectParameter(updateData, "The parameter DSIContent is empty.");
            CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
            DataSetInfoType dataSetInfo = cardInfoWrapper.getDataSetByDsiName(dsiName);
            DSIType dsi = cardInfoWrapper.getDSIbyName(dsiName);
            Assert.assertNamedEntityNotFound(dataSetInfo, "The given DSIName cannot be found.");
            Assert.securityConditionDataSet(cardStateEntry, applicationID, dsiName, NamedDataServiceActionName.DSI_WRITE);
            if (cardStateEntry.getFCPOfSelectedEF() == null) {
                throw new PrerequisitesNotSatisfiedException("No EF with DSI selected.");
            }
            if (!Arrays.equals(dataSetInfo.getDataSetPath().getEfIdOrPath(), cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().get(0))) {
                String msg = "The currently selected data set does not contain the DSI to be updated.";
                throw new PrerequisitesNotSatisfiedException(msg);
            }
            byte[] slotHandle = connectionHandle.getSlotHandle();
            if (cardStateEntry.getFCPOfSelectedEF().getDataElements().isTransparent()) {
                byte[] index = dsi.getDSIPath().getIndex();
                UpdateBinary updateBin = new UpdateBinary(index[0], index[1], updateData);
                updateBin.transmit(this.env.getDispatcher(), slotHandle);
            } else {
                byte index = dsi.getDSIPath().getIndex()[0];
                UpdateRecord updateRec = new UpdateRecord(index, updateData);
                updateRec.transmit(this.env.getDispatcher(), slotHandle);
            }
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public DSIReadResponse dsiRead(DSIRead request) {
        DSIReadResponse response;
        block17: {
            response = (DSIReadResponse)WSHelper.makeResponse(DSIReadResponse.class, WSHelper.makeResultOK());
            try {
                ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
                CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle);
                byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
                String dsiName = request.getDSIName();
                byte[] slotHandle = connectionHandle.getSlotHandle();
                Assert.assertIncorrectParameter(dsiName, "The parameter DSIName is empty.");
                Assert.securityConditionDataSet(cardStateEntry, applicationID, dsiName, NamedDataServiceActionName.DSI_READ);
                if (cardStateEntry.getFCPOfSelectedEF() == null) {
                    throw new PrerequisitesNotSatisfiedException("No DataSet to read selected.");
                }
                CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
                DataSetInfoType dataSetInfo = cardInfoWrapper.getDataSetByDsiName(dsiName);
                if (dataSetInfo == null) {
                    dataSetInfo = cardInfoWrapper.getDataSetByName(dsiName);
                    if (dataSetInfo != null) {
                        byte[] path;
                        byte[] fid;
                        if (!cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().isEmpty() && !Arrays.equals(fid = Arrays.copyOfRange(path = dataSetInfo.getDataSetPath().getEfIdOrPath(), path.length - 2, path.length), cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().get(0))) {
                            String msg = "Wrong DataSet for reading the DSI " + dsiName + " is selected.";
                            throw new PrerequisitesNotSatisfiedException(msg);
                        }
                        byte[] fileContent = CardUtils.readFile(cardStateEntry.getFCPOfSelectedEF(), this.env.getDispatcher(), slotHandle);
                        response.setDSIContent(fileContent);
                        break block17;
                    }
                    String msg = "The given DSIName does not related to any know DSI or DataSet.";
                    throw new IncorrectParameterException(msg);
                }
                byte[] dataSetPath = dataSetInfo.getDataSetPath().getEfIdOrPath();
                byte[] dataSetFID = new byte[]{dataSetPath[dataSetPath.length - 2], dataSetPath[dataSetPath.length - 1]};
                if (!Arrays.equals(dataSetFID, cardStateEntry.getFCPOfSelectedEF().getFileIdentifiers().get(0))) break block17;
                DSIType dsi = cardInfoWrapper.getDSIbyName(dsiName);
                PathType dsiPath = dsi.getDSIPath();
                if (dsiPath.getTagRef() != null) {
                    PathType.TagRef tagReference = dsiPath.getTagRef();
                    byte[] tag = tagReference.getTag();
                    if (tag.length == 2) {
                        GetData getDataRequest = new GetData(GetData.INS_DATA, tag[0], tag[1]);
                        CardResponseAPDU cardResponse = getDataRequest.transmit(this.env.getDispatcher(), slotHandle, Collections.EMPTY_LIST);
                        byte[] responseData = cardResponse.getData();
                        while (cardResponse.getTrailer()[0] == 97) {
                            GetResponse allData = new GetResponse();
                            cardResponse = allData.transmit(this.env.getDispatcher(), slotHandle, Collections.EMPTY_LIST);
                            responseData = ByteUtils.concatenate(responseData, cardResponse.getData());
                        }
                        response.setDSIContent(responseData);
                    } else if (tag.length == 1) {
                        GetData getDataRequest = new GetData(GetData.INS_DATA, GetData.SIMPLE_TLV, tag[0]);
                        CardResponseAPDU cardResponse = getDataRequest.transmit(this.env.getDispatcher(), slotHandle, Collections.EMPTY_LIST);
                        byte[] responseData = cardResponse.getData();
                        if (Arrays.equals(cardResponse.getTrailer(), new byte[]{106, -120})) {
                            getDataRequest = new GetData(GetData.INS_DATA, GetData.BER_TLV_ONE_BYTE, tag[0]);
                            cardResponse = getDataRequest.transmit(this.env.getDispatcher(), slotHandle, Collections.EMPTY_LIST);
                            responseData = cardResponse.getData();
                        }
                        while (cardResponse.getTrailer()[0] == 97) {
                            GetResponse allData = new GetResponse();
                            cardResponse = allData.transmit(this.env.getDispatcher(), slotHandle, Collections.EMPTY_LIST);
                            responseData = ByteUtils.concatenate(responseData, cardResponse.getData());
                        }
                        response.setDSIContent(responseData);
                    }
                    break block17;
                }
                if (dsiPath.getIndex() != null) {
                    byte[] index = dsiPath.getIndex();
                    byte[] length = dsiPath.getLength();
                    ArrayList<byte[]> allowedResponse = new ArrayList<byte[]>();
                    allowedResponse.add(new byte[]{-112, 0});
                    allowedResponse.add(new byte[]{98, -126});
                    if (cardStateEntry.getFCPOfSelectedEF().getDataElements().isLinear()) {
                        ReadRecord readRecord = new ReadRecord(index[0]);
                        CardResponseAPDU cardResponse = readRecord.transmit(this.env.getDispatcher(), slotHandle, allowedResponse);
                        response.setDSIContent(cardResponse.getData());
                    } else {
                        ReadBinary readBinary = new ReadBinary(ByteUtils.toShort(index), ByteUtils.toShort(length));
                        CardResponseAPDU cardResponse = readBinary.transmit(this.env.getDispatcher(), slotHandle, allowedResponse);
                        response.setDSIContent(cardResponse.getData());
                    }
                    break block17;
                }
                String msg = "The currently selected data set does not contain the DSI with the name " + dsiName;
                throw new PrerequisitesNotSatisfiedException(msg);
            }
            catch (ECardException e) {
                response.setResult(e.getResult());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
                this.throwThreadKillException(e);
                response.setResult(WSHelper.makeResult(e));
            }
        }
        return response;
    }

    @Override
    @Publish
    public EncipherResponse encipher(Encipher request) {
        EncipherResponse response = (EncipherResponse)WSHelper.makeResponse(EncipherResponse.class, WSHelper.makeResultOK());
        try {
            byte[] necessaryCardApp;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            String didName = SALUtils.getDIDName(request);
            byte[] plainText = request.getPlainText();
            Assert.assertIncorrectParameter(plainText, "The parameter PlainText is empty.");
            DIDScopeType didScope = request.getDIDScope();
            if (didScope == null) {
                didScope = DIDScopeType.LOCAL;
            }
            if (didScope.equals((Object)DIDScopeType.LOCAL) && !Arrays.equals(necessaryCardApp = cardStateEntry.getInfo().getApplicationIdByDidName(didName, didScope), applicationID)) {
                throw new SecurityConditionNotSatisfiedException("Wrong application selected.");
            }
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, didScope);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.Encipher)) {
                throw new InappropriateProtocolForActionException("Encipher", protocol.toString());
            }
            response = protocol.encipher(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DecipherResponse decipher(Decipher request) {
        DecipherResponse response = (DecipherResponse)WSHelper.makeResponse(DecipherResponse.class, WSHelper.makeResultOK());
        try {
            byte[] necessaryCardApp;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            String didName = SALUtils.getDIDName(request);
            byte[] cipherText = request.getCipherText();
            Assert.assertIncorrectParameter(cipherText, "The parameter CipherText is empty.");
            DIDScopeType didScope = request.getDIDScope();
            if (didScope == null) {
                didScope = DIDScopeType.LOCAL;
            }
            if (didScope.equals((Object)DIDScopeType.LOCAL) && !Arrays.equals(necessaryCardApp = cardStateEntry.getInfo().getApplicationIdByDidName(didName, didScope), applicationID)) {
                throw new SecurityConditionNotSatisfiedException("Wrong application selected.");
            }
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, didScope);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.Decipher)) {
                throw new InappropriateProtocolForActionException("Decipher", protocol.toString());
            }
            response = protocol.decipher(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public GetRandomResponse getRandom(GetRandom request) {
        GetRandomResponse response = (GetRandomResponse)WSHelper.makeResponse(GetRandomResponse.class, WSHelper.makeResultOK());
        try {
            byte[] necessaryApp;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            String didName = SALUtils.getDIDName(request);
            DIDScopeType didScope = request.getDIDScope();
            if (didScope == null) {
                didScope = DIDScopeType.LOCAL;
            }
            if (didScope.equals((Object)DIDScopeType.LOCAL) && !Arrays.equals(necessaryApp = cardStateEntry.getInfo().getApplicationIdByDidName(didName, didScope), applicationID)) {
                throw new SecurityConditionNotSatisfiedException("The wrong application is selected for getRandom()");
            }
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, didScope);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.GetRandom)) {
                throw new InappropriateProtocolForActionException("GetRandom", protocol.toString());
            }
            response = protocol.getRandom(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public HashResponse hash(Hash request) {
        HashResponse response = (HashResponse)WSHelper.makeResponse(HashResponse.class, WSHelper.makeResultOK());
        try {
            byte[] necesssaryApp;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            String didName = SALUtils.getDIDName(request);
            byte[] message = request.getMessage();
            Assert.assertIncorrectParameter(message, "The parameter Message is empty.");
            DIDScopeType didScope = request.getDIDScope();
            if (didScope == null) {
                didScope = DIDScopeType.LOCAL;
            }
            if (didScope.equals((Object)DIDScopeType.LOCAL) && !Arrays.equals(necesssaryApp = cardStateEntry.getInfo().getApplicationIdByDidName(didName, didScope), applicationID)) {
                String msg = "Wrong application for executing Hash with the specified DID " + didName + ".";
                throw new SecurityConditionNotSatisfiedException(msg);
            }
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, didScope);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.Hash)) {
                throw new InappropriateProtocolForActionException("Hash", protocol.toString());
            }
            response = protocol.hash(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public SignResponse sign(Sign request) {
        SignResponse response = (SignResponse)WSHelper.makeResponse(SignResponse.class, WSHelper.makeResultOK());
        CardStateEntry cardStateEntry = null;
        try {
            byte[] necessarySelectedApp;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            String didName = SALUtils.getDIDName(request);
            byte[] message = request.getMessage();
            Assert.assertIncorrectParameter(message, "The parameter Message is empty.");
            DIDScopeType didScope = request.getDIDScope();
            if (didScope == null) {
                didScope = DIDScopeType.LOCAL;
            }
            if (didScope.equals((Object)DIDScopeType.LOCAL) && !Arrays.equals(necessarySelectedApp = cardStateEntry.getInfo().getApplicationIdByDidName(didName, didScope), applicationID)) {
                String msg = "Wrong application selected for the execution of Sign with the DID " + didName + ".";
                throw new SecurityConditionNotSatisfiedException(msg);
            }
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, didScope);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.Sign)) {
                throw new InappropriateProtocolForActionException("Sign", protocol.toString());
            }
            response = protocol.sign(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        this.setPinNotAuth(cardStateEntry);
        return response;
    }

    @Override
    public VerifySignatureResponse verifySignature(VerifySignature request) {
        VerifySignatureResponse response = (VerifySignatureResponse)WSHelper.makeResponse(VerifySignatureResponse.class, WSHelper.makeResultOK());
        try {
            byte[] necessarySelectedApp;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            String didName = SALUtils.getDIDName(request);
            byte[] signature = request.getSignature();
            Assert.assertIncorrectParameter(signature, "The parameter Signature is empty.");
            DIDScopeType didScope = request.getDIDScope();
            if (didScope == null) {
                didScope = DIDScopeType.LOCAL;
            }
            if (didScope.equals((Object)DIDScopeType.LOCAL) && !Arrays.equals(necessarySelectedApp = cardStateEntry.getInfo().getApplicationIdByDidName(didName, didScope), applicationID)) {
                String msg = "Wrong application selected for the execution of VerifySignature with the DID " + didName + ".";
                throw new SecurityConditionNotSatisfiedException(msg);
            }
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, didScope);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.VerifySignature)) {
                throw new InappropriateProtocolForActionException("VerifySignature", protocol.toString());
            }
            response = protocol.verifySignature(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public VerifyCertificateResponse verifyCertificate(VerifyCertificate request) {
        VerifyCertificateResponse response = (VerifyCertificateResponse)WSHelper.makeResponse(VerifyCertificateResponse.class, WSHelper.makeResultOK());
        try {
            byte[] necessarySelectedApp;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            byte[] applicationID = cardStateEntry.getCurrentCardApplication().getApplicationIdentifier();
            String didName = SALUtils.getDIDName(request);
            byte[] certificate = request.getCertificate();
            Assert.assertIncorrectParameter(certificate, "The parameter Certificate is empty.");
            String certificateType = request.getCertificateType();
            Assert.assertIncorrectParameter(certificateType, "The parameter CertificateType is empty.");
            String rootCert = request.getRootCert();
            Assert.assertIncorrectParameter(rootCert, "The parameter RootCert is empty.");
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, applicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            DIDScopeType didScope = request.getDIDScope();
            if (didScope == null) {
                didScope = DIDScopeType.LOCAL;
            }
            if (didScope.equals((Object)DIDScopeType.LOCAL) && !Arrays.equals(necessarySelectedApp = cardStateEntry.getInfo().getApplicationIdByDidName(didName, didScope), applicationID)) {
                String msg = "Wrong application selected for the execution of VerifyCertificate with the DID " + didName + ".";
                throw new SecurityConditionNotSatisfiedException(msg);
            }
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.VerifyCertificate)) {
                throw new InappropriateProtocolForActionException("VerifyCertificate", protocol.toString());
            }
            response = protocol.verifyCertificate(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public DIDListResponse didList(DIDList request) {
        DIDListResponse response = (DIDListResponse)WSHelper.makeResponse(DIDListResponse.class, WSHelper.makeResultOK());
        try {
            DIDInfoType next;
            Iterator it;
            CardApplicationWrapper cardApplication;
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            byte[] appId = connectionHandle.getCardApplication();
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            Assert.securityConditionApplication(cardStateEntry, appId, DifferentialIdentityServiceActionName.DID_LIST);
            byte[] applicationIDFilter = null;
            String objectIDFilter = null;
            String applicationFunctionFilter = null;
            DIDQualifierType didQualifier = request.getFilter();
            if (didQualifier != null) {
                applicationIDFilter = didQualifier.getApplicationIdentifier();
                objectIDFilter = didQualifier.getObjectIdentifier();
                applicationFunctionFilter = didQualifier.getApplicationFunction();
            }
            if (applicationIDFilter != null) {
                cardApplication = cardStateEntry.getInfo().getCardApplication(applicationIDFilter);
                Assert.assertIncorrectParameter(cardApplication, "The given CardApplication cannot be found.");
            } else {
                cardApplication = cardStateEntry.getCurrentCardApplication();
            }
            ArrayList<DIDInfoType> didInfos = new ArrayList<DIDInfoType>(cardApplication.getDIDInfoList());
            if (objectIDFilter != null) {
                it = didInfos.iterator();
                while (it.hasNext()) {
                    next = (DIDInfoType)it.next();
                    if (next.getDifferentialIdentity().getDIDProtocol().equals(objectIDFilter)) continue;
                    it.remove();
                }
            }
            if (applicationFunctionFilter != null) {
                it = didInfos.iterator();
                while (it.hasNext()) {
                    next = (DIDInfoType)it.next();
                    if (next.getDifferentialIdentity().getDIDMarker().getCryptoMarker() == null) {
                        it.remove();
                        continue;
                    }
                    iso.std.iso_iec._24727.tech.schema.CryptoMarkerType rawMarker = next.getDifferentialIdentity().getDIDMarker().getCryptoMarker();
                    CryptoMarkerType cryptoMarker = new CryptoMarkerType(rawMarker);
                    AlgorithmInfoType algInfo = cryptoMarker.getAlgorithmInfo();
                    if (algInfo.getSupportedOperations().contains(applicationFunctionFilter)) continue;
                    it.remove();
                }
            }
            DIDNameListType didNameList = new DIDNameListType();
            for (DIDInfoType didInfo : didInfos) {
                didNameList.getDIDName().add(didInfo.getDifferentialIdentity().getDIDName());
            }
            response.setDIDNameList(didNameList);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DIDCreateResponse didCreate(DIDCreate request) {
        return (DIDCreateResponse)WSHelper.makeResponse(DIDCreateResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    @Override
    @Publish
    public DIDGetResponse didGet(DIDGet request) {
        DIDGetResponse response = (DIDGetResponse)WSHelper.makeResponse(DIDGetResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            String didName = SALUtils.getDIDName(request);
            DIDStructureType didStructure = SALUtils.getDIDStructure(request, didName, cardStateEntry, connectionHandle);
            response.setDIDStructure(didStructure);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DIDUpdateResponse didUpdate(DIDUpdate request) {
        DIDUpdateResponse response = (DIDUpdateResponse)WSHelper.makeResponse(DIDUpdateResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            String didName = request.getDIDName();
            Assert.assertIncorrectParameter(didName, "The parameter DIDName is empty.");
            DIDUpdateDataType didUpdateData = request.getDIDUpdateData();
            Assert.assertIncorrectParameter(didUpdateData, "The parameter DIDUpdateData is empty.");
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, cardApplicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            Assert.securityConditionDID(cardStateEntry, cardApplicationID, didName, DifferentialIdentityServiceActionName.DID_UPDATE);
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, null, protocolURI);
            if (!protocol.hasNextStep(FunctionType.DIDUpdate)) {
                throw new InappropriateProtocolForActionException("DIDUpdate", protocol.toString());
            }
            response = protocol.didUpdate(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    public DIDDeleteResponse didDelete(DIDDelete request) {
        DIDDeleteResponse response = (DIDDeleteResponse)WSHelper.makeResponse(DIDDeleteResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            byte[] cardApplicationID = connectionHandle.getCardApplication();
            CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
            String didName = request.getDIDName();
            Assert.assertIncorrectParameter(didName, "The parameter DIDName is empty.");
            DIDStructureType didStructure = cardStateEntry.getDIDStructure(didName, cardApplicationID);
            Assert.assertNamedEntityNotFound(didStructure, "The given DIDName cannot be found.");
            Assert.securityConditionDID(cardStateEntry, cardApplicationID, didName, DifferentialIdentityServiceActionName.DID_DELETE);
            String protocolURI = didStructure.getDIDMarker().getProtocol();
            SALProtocol protocol = this.getProtocol(connectionHandle, null, protocolURI);
            if (!protocol.hasNextStep(FunctionType.DIDDelete)) {
                throw new InappropriateProtocolForActionException("DIDDelete", protocol.toString());
            }
            response = protocol.didDelete(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public DIDAuthenticateResponse didAuthenticate(DIDAuthenticate request) {
        DIDAuthenticateResponse response = (DIDAuthenticateResponse)WSHelper.makeResponse(DIDAuthenticateResponse.class, WSHelper.makeResultOK());
        try {
            ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
            DIDAuthenticationDataType didAuthenticationData = request.getAuthenticationProtocolData();
            Assert.assertIncorrectParameter(didAuthenticationData, "The parameter AuthenticationProtocolData is empty.");
            String protocolURI = didAuthenticationData.getProtocol();
            if (protocolURI == null) {
                LOG.warn("ProtocolURI was null");
                protocolURI = "urn:oid:1.3.162.15480.3.0.14";
            } else if (protocolURI.equals("urn:oid:1.0.24727.3.0.0.7.2")) {
                LOG.warn("ProtocolURI was urn:oid:1.0.24727.3.0.0.7.2");
                protocolURI = "urn:oid:1.3.162.15480.3.0.14";
            }
            didAuthenticationData.setProtocol(protocolURI);
            SALProtocol protocol = this.getProtocol(connectionHandle, request.getDIDScope(), protocolURI);
            if (!protocol.hasNextStep(FunctionType.DIDAuthenticate)) {
                throw new InappropriateProtocolForActionException("DIDAuthenticate", protocol.toString());
            }
            response = protocol.didAuthenticate(request);
            this.removeFinishedProtocol(connectionHandle, protocolURI, protocol);
        }
        catch (ECardException e) {
            response.setResult(e.getResult());
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
            this.throwThreadKillException(e);
            response.setResult(WSHelper.makeResult(e));
        }
        return response;
    }

    @Override
    @Publish
    public ACLListResponse aclList(ACLList request) {
        ACLListResponse response;
        block6: {
            response = (ACLListResponse)WSHelper.makeResponse(ACLListResponse.class, WSHelper.makeResultOK());
            try {
                ConnectionHandleType connectionHandle = SALUtils.getConnectionHandle(request);
                CardStateEntry cardStateEntry = SALUtils.getCardStateEntry(this.states, connectionHandle, false);
                TargetNameType targetName = request.getTargetName();
                Assert.assertIncorrectParameter(targetName, "The parameter TargetName is empty.");
                byte[] targetAppId = targetName.getCardApplicationName();
                String targetDataSet = targetName.getDataSetName();
                String targetDid = targetName.getDIDName();
                CardInfoWrapper cardInfoWrapper = cardStateEntry.getInfo();
                byte[] handleAppId = connectionHandle.getCardApplication();
                if (targetDataSet != null) {
                    DataSetInfoType dataSetInfo = cardInfoWrapper.getDataSet(targetDataSet, handleAppId);
                    Assert.assertNamedEntityNotFound(dataSetInfo, "The given DataSet cannot be found.");
                    response.setTargetACL(cardInfoWrapper.getDataSet(targetDataSet, handleAppId).getDataSetACL());
                    break block6;
                }
                if (targetDid != null) {
                    DIDInfoType didInfo = cardInfoWrapper.getDIDInfo(targetDid, handleAppId);
                    Assert.assertNamedEntityNotFound(didInfo, "The given DIDInfo cannot be found.");
                    response.setTargetACL(cardInfoWrapper.getDIDInfo(targetDid, handleAppId).getDIDACL());
                    break block6;
                }
                if (targetAppId != null) {
                    CardApplicationWrapper cardApplication = cardInfoWrapper.getCardApplication(targetAppId);
                    Assert.assertNamedEntityNotFound(cardApplication, "The given CardApplication cannot be found.");
                    Assert.securityConditionApplication(cardStateEntry, targetAppId, AuthorizationServiceActionName.ACL_LIST);
                    response.setTargetACL(cardInfoWrapper.getCardApplication(targetAppId).getCardApplicationACL());
                    break block6;
                }
                throw new IncorrectParameterException("The given TargetName is invalid.");
            }
            catch (ECardException e) {
                response.setResult(e.getResult());
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e);
                this.throwThreadKillException(e);
                response.setResult(WSHelper.makeResult(e));
            }
        }
        return response;
    }

    @Override
    public ACLModifyResponse aclModify(ACLModify request) {
        return (ACLModifyResponse)WSHelper.makeResponse(ACLModifyResponse.class, WSHelper.makeResultUnknownError("Not supported yet."));
    }

    public void setGUI(UserConsent uc) {
        this.userConsent = uc;
    }

    private void removeFinishedProtocol(ConnectionHandleType handle, String protocolURI, SALProtocol protocol) throws UnknownConnectionHandleException {
        if (protocol.isFinished()) {
            CardStateEntry entry = SALUtils.getCardStateEntry(this.states, handle, false);
            entry.removeProtocol(protocolURI);
        }
    }

    private SALProtocol getProtocol(@Nonnull ConnectionHandleType handle, @Nullable DIDScopeType scope, @Nonnull String protocolURI) throws UnknownProtocolException, UnknownConnectionHandleException {
        CardStateEntry entry = SALUtils.getCardStateEntry(this.states, handle, scope != DIDScopeType.GLOBAL);
        SALProtocol protocol = entry.getProtocol(protocolURI);
        if (protocol == null) {
            try {
                protocol = this.protocolSelector.getSALProtocol(protocolURI);
                entry.setProtocol(protocolURI, protocol);
            }
            catch (AddonNotFoundException ex) {
                throw new UnknownProtocolException("The protocol URI '" + protocolURI + "' is not available.");
            }
        }
        protocol.getInternalData().put("cardState", entry);
        return protocol;
    }

    private byte[] createFakeFCP(byte[] fid) {
        try {
            TLV fcp = new TLV();
            fcp.setTagNumWithClass((byte)98);
            TLV fileID = new TLV();
            fileID.setTagNumWithClass((byte)-125);
            fileID.setValue(fid);
            fcp.setChild(fileID);
            return fcp.toBER();
        }
        catch (TLVException ex) {
            LOG.error(null, ex);
            return null;
        }
    }

    private void setPinNotAuth(@Nullable CardStateEntry cardStateEntry) {
        if (cardStateEntry != null) {
            LOG.info("Unauthenticate Card PIN (state=false).");
            for (DIDInfoType didInfo : Collections.unmodifiableCollection(cardStateEntry.getAuthenticatedDIDs())) {
                if (!"urn:oid:1.3.162.15480.3.0.9".equals(didInfo.getDifferentialIdentity().getDIDProtocol())) continue;
                cardStateEntry.removeAuthenticated(didInfo);
            }
        }
    }

    private void throwThreadKillException(Exception ex) {
        Throwable cause = ex instanceof InvocationTargetExceptionUnchecked ? ex.getCause() : ex;
        if (cause instanceof ThreadTerminateException) {
            throw (ThreadTerminateException)cause;
        }
        if (cause instanceof InterruptedException) {
            throw new ThreadTerminateException("Thread running inside SAL interrupted.", cause);
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
    }
}

