/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.sal;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.ACLModify;
import iso.std.iso_iec._24727.tech.schema.ACLModifyResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationCreate;
import iso.std.iso_iec._24727.tech.schema.CardApplicationCreateResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDelete;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationEndSessionResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationSelect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationSelectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceCreate;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceCreateResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDelete;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDescribe;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceDescribeResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceLoad;
import iso.std.iso_iec._24727.tech.schema.CardApplicationServiceLoadResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSession;
import iso.std.iso_iec._24727.tech.schema.CardApplicationStartSessionResponse;
import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticate;
import iso.std.iso_iec._24727.tech.schema.DIDAuthenticateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDCreate;
import iso.std.iso_iec._24727.tech.schema.DIDCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DIDDelete;
import iso.std.iso_iec._24727.tech.schema.DIDDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDList;
import iso.std.iso_iec._24727.tech.schema.DIDListResponse;
import iso.std.iso_iec._24727.tech.schema.DIDUpdate;
import iso.std.iso_iec._24727.tech.schema.DIDUpdateResponse;
import iso.std.iso_iec._24727.tech.schema.DSICreate;
import iso.std.iso_iec._24727.tech.schema.DSICreateResponse;
import iso.std.iso_iec._24727.tech.schema.DSIDelete;
import iso.std.iso_iec._24727.tech.schema.DSIDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DSIList;
import iso.std.iso_iec._24727.tech.schema.DSIListResponse;
import iso.std.iso_iec._24727.tech.schema.DSIRead;
import iso.std.iso_iec._24727.tech.schema.DSIReadResponse;
import iso.std.iso_iec._24727.tech.schema.DSIWrite;
import iso.std.iso_iec._24727.tech.schema.DSIWriteResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetCreate;
import iso.std.iso_iec._24727.tech.schema.DataSetCreateResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetDelete;
import iso.std.iso_iec._24727.tech.schema.DataSetDeleteResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetList;
import iso.std.iso_iec._24727.tech.schema.DataSetListResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetSelect;
import iso.std.iso_iec._24727.tech.schema.DataSetSelectResponse;
import iso.std.iso_iec._24727.tech.schema.Decipher;
import iso.std.iso_iec._24727.tech.schema.DecipherResponse;
import iso.std.iso_iec._24727.tech.schema.Encipher;
import iso.std.iso_iec._24727.tech.schema.EncipherResponse;
import iso.std.iso_iec._24727.tech.schema.ExecuteAction;
import iso.std.iso_iec._24727.tech.schema.ExecuteActionResponse;
import iso.std.iso_iec._24727.tech.schema.GetRandom;
import iso.std.iso_iec._24727.tech.schema.GetRandomResponse;
import iso.std.iso_iec._24727.tech.schema.Hash;
import iso.std.iso_iec._24727.tech.schema.HashResponse;
import iso.std.iso_iec._24727.tech.schema.Initialize;
import iso.std.iso_iec._24727.tech.schema.InitializeResponse;
import iso.std.iso_iec._24727.tech.schema.Sign;
import iso.std.iso_iec._24727.tech.schema.SignResponse;
import iso.std.iso_iec._24727.tech.schema.Terminate;
import iso.std.iso_iec._24727.tech.schema.TerminateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificate;
import iso.std.iso_iec._24727.tech.schema.VerifyCertificateResponse;
import iso.std.iso_iec._24727.tech.schema.VerifySignature;
import iso.std.iso_iec._24727.tech.schema.VerifySignatureResponse;
import java.io.InputStream;
import java.util.LinkedList;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.CIFProvider;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.Publish;
import org.openecard.common.sal.SpecializedSAL;
import org.openecard.common.sal.util.SALUtils;
import org.openecard.ws.SAL;

public class SelectorSAL
implements SAL,
CIFProvider {
    private final CardRecognition recognition;
    private final SAL main;
    private final LinkedList<SpecializedSAL> special;
    private final LinkedList<SpecializedSAL> initializedSpecializedSals;
    private final LinkedList<SAL> initializedSals;

    public SelectorSAL(SAL mainSal, Environment env) {
        this.recognition = env.getRecognition();
        this.main = mainSal;
        this.special = new LinkedList();
        this.initializedSpecializedSals = new LinkedList();
        this.initializedSals = new LinkedList();
    }

    public void addSpecializedSAL(SpecializedSAL specialSal) {
        this.special.add(specialSal);
    }

    private SAL getResponsibleSAL(CardApplicationPathType path) {
        for (SpecializedSAL sal : this.initializedSpecializedSals) {
            if (!sal.specializedFor(path)) continue;
            return sal;
        }
        return this.main;
    }

    private SAL getResponsibleSAL(ConnectionHandleType handle) {
        for (SpecializedSAL sal : this.initializedSpecializedSals) {
            if (!sal.specializedFor(handle)) continue;
            return sal;
        }
        return this.main;
    }

    private SAL getResponsibleSAL(String cardType) {
        for (SpecializedSAL sal : this.initializedSpecializedSals) {
            if (!sal.specializedFor(cardType)) continue;
            return sal;
        }
        return this.main;
    }

    @Override
    public CardInfoType getCardInfo(ConnectionHandleType type, String cardType) {
        SAL sal = this.getResponsibleSAL(type);
        if (type != null && sal instanceof CIFProvider) {
            return ((CIFProvider)((Object)sal)).getCardInfo(type, cardType);
        }
        return this.recognition.getCardInfo(cardType);
    }

    @Override
    public CardInfoType getCardInfo(String cardType) throws RuntimeException {
        SAL sal = this.getResponsibleSAL(cardType);
        if (sal instanceof CIFProvider) {
            return ((CIFProvider)((Object)sal)).getCardInfo(cardType);
        }
        return null;
    }

    @Override
    public InputStream getCardImage(String cardType) {
        SAL sal = this.getResponsibleSAL(cardType);
        if (sal instanceof CIFProvider) {
            return ((CIFProvider)((Object)sal)).getCardImage(cardType);
        }
        return null;
    }

    @Override
    public boolean needsRecognition(byte[] atr) {
        for (SpecializedSAL next : this.initializedSpecializedSals) {
            CIFProvider cp;
            if (!(next instanceof CIFProvider) || (cp = (CIFProvider)((Object)next)).needsRecognition(atr)) continue;
            return false;
        }
        if (this.main instanceof CIFProvider) {
            CIFProvider cp = (CIFProvider)((Object)this.main);
            return cp.needsRecognition(atr);
        }
        return true;
    }

    @Override
    public InitializeResponse initialize(Initialize init) {
        InitializeResponse response = (InitializeResponse)WSHelper.makeResponse(InitializeResponse.class, WSHelper.makeResultOK());
        if (this.initializedSals.isEmpty()) {
            LinkedList<SAL> sals = new LinkedList<SAL>();
            sals.add(this.main);
            sals.addAll(this.special);
            for (SAL next : sals) {
                try {
                    InitializeResponse res = next.initialize(init);
                    WSHelper.checkResult(res);
                    if (WSHelper.resultsInWarn(res)) continue;
                    if (next instanceof SpecializedSAL) {
                        this.initializedSpecializedSals.add((SpecializedSAL)next);
                        continue;
                    }
                    this.initializedSals.add(next);
                }
                catch (WSHelper.WSException ex) {
                    String msg = "One of the SAL instances failed to initialize:\n" + ex.getMessage();
                    this.terminate(new Terminate());
                    response.setResult(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/dp#communicationError", msg));
                    return response;
                }
            }
        }
        return response;
    }

    @Override
    public TerminateResponse terminate(Terminate terminate) {
        TerminateResponse response = (TerminateResponse)WSHelper.makeResponse(TerminateResponse.class, WSHelper.makeResultOK());
        if (!this.initializedSals.isEmpty()) {
            boolean errorHit = false;
            for (SAL next : this.initializedSals) {
                try {
                    TerminateResponse res = next.terminate(terminate);
                    WSHelper.checkResult(res);
                }
                catch (WSHelper.WSException ex) {
                    if (errorHit) continue;
                    response.setResult(ex.getResult());
                }
            }
            this.initializedSals.clear();
        }
        return response;
    }

    @Override
    public CardApplicationPathResponse cardApplicationPath(CardApplicationPath parameters) {
        return this.main.cardApplicationPath(parameters);
    }

    @Override
    public CardApplicationConnectResponse cardApplicationConnect(CardApplicationConnect parameters) {
        return this.getResponsibleSAL(parameters.getCardApplicationPath()).cardApplicationConnect(parameters);
    }

    @Override
    public CardApplicationSelectResponse cardApplicationSelect(CardApplicationSelect parameters) {
        return this.getResponsibleSAL(SALUtils.createConnectionHandle(parameters.getSlotHandle())).cardApplicationSelect(parameters);
    }

    @Override
    public CardApplicationDisconnectResponse cardApplicationDisconnect(CardApplicationDisconnect parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationDisconnect(parameters);
    }

    @Override
    @Publish
    public CardApplicationStartSessionResponse cardApplicationStartSession(CardApplicationStartSession parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationStartSession(parameters);
    }

    @Override
    @Publish
    public CardApplicationEndSessionResponse cardApplicationEndSession(CardApplicationEndSession parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationEndSession(parameters);
    }

    @Override
    @Publish
    public CardApplicationListResponse cardApplicationList(CardApplicationList parameters) {
        return this.main.cardApplicationList(parameters);
    }

    @Override
    public CardApplicationCreateResponse cardApplicationCreate(CardApplicationCreate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationCreate(parameters);
    }

    @Override
    public CardApplicationDeleteResponse cardApplicationDelete(CardApplicationDelete parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationDelete(parameters);
    }

    @Override
    @Publish
    public CardApplicationServiceListResponse cardApplicationServiceList(CardApplicationServiceList parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationServiceList(parameters);
    }

    @Override
    public CardApplicationServiceCreateResponse cardApplicationServiceCreate(CardApplicationServiceCreate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationServiceCreate(parameters);
    }

    @Override
    public CardApplicationServiceLoadResponse cardApplicationServiceLoad(CardApplicationServiceLoad parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationServiceLoad(parameters);
    }

    @Override
    public CardApplicationServiceDeleteResponse cardApplicationServiceDelete(CardApplicationServiceDelete parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationServiceDelete(parameters);
    }

    @Override
    @Publish
    public CardApplicationServiceDescribeResponse cardApplicationServiceDescribe(CardApplicationServiceDescribe parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).cardApplicationServiceDescribe(parameters);
    }

    @Override
    public ExecuteActionResponse executeAction(ExecuteAction parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).executeAction(parameters);
    }

    @Override
    @Publish
    public DataSetListResponse dataSetList(DataSetList parameters) {
        return this.main.dataSetList(parameters);
    }

    @Override
    public DataSetCreateResponse dataSetCreate(DataSetCreate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).dataSetCreate(parameters);
    }

    @Override
    @Publish
    public DataSetSelectResponse dataSetSelect(DataSetSelect parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).dataSetSelect(parameters);
    }

    @Override
    public DataSetDeleteResponse dataSetDelete(DataSetDelete parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).dataSetDelete(parameters);
    }

    @Override
    @Publish
    public DSIListResponse dsiList(DSIList parameters) {
        return this.main.dsiList(parameters);
    }

    @Override
    public DSICreateResponse dsiCreate(DSICreate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).dsiCreate(parameters);
    }

    @Override
    public DSIDeleteResponse dsiDelete(DSIDelete parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).dsiDelete(parameters);
    }

    @Override
    @Publish
    public DSIWriteResponse dsiWrite(DSIWrite parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).dsiWrite(parameters);
    }

    @Override
    @Publish
    public DSIReadResponse dsiRead(DSIRead parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).dsiRead(parameters);
    }

    @Override
    @Publish
    public EncipherResponse encipher(Encipher parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).encipher(parameters);
    }

    @Override
    @Publish
    public DecipherResponse decipher(Decipher parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).decipher(parameters);
    }

    @Override
    @Publish
    public GetRandomResponse getRandom(GetRandom parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).getRandom(parameters);
    }

    @Override
    @Publish
    public HashResponse hash(Hash parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).hash(parameters);
    }

    @Override
    @Publish
    public SignResponse sign(Sign parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).sign(parameters);
    }

    @Override
    @Publish
    public VerifySignatureResponse verifySignature(VerifySignature parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).verifySignature(parameters);
    }

    @Override
    @Publish
    public VerifyCertificateResponse verifyCertificate(VerifyCertificate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).verifyCertificate(parameters);
    }

    @Override
    @Publish
    public DIDListResponse didList(DIDList parameters) {
        return this.main.didList(parameters);
    }

    @Override
    public DIDCreateResponse didCreate(DIDCreate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).didCreate(parameters);
    }

    @Override
    @Publish
    public DIDGetResponse didGet(DIDGet parameters) {
        return this.main.didGet(parameters);
    }

    @Override
    public DIDUpdateResponse didUpdate(DIDUpdate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).didUpdate(parameters);
    }

    @Override
    public DIDDeleteResponse didDelete(DIDDelete parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).didDelete(parameters);
    }

    @Override
    @Publish
    public DIDAuthenticateResponse didAuthenticate(DIDAuthenticate parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).didAuthenticate(parameters);
    }

    @Override
    @Publish
    public ACLListResponse aclList(ACLList parameters) {
        return this.main.aclList(parameters);
    }

    @Override
    public ACLModifyResponse aclModify(ACLModify parameters) {
        return this.getResponsibleSAL(parameters.getConnectionHandle()).aclModify(parameters);
    }
}

