/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage.core;

import ch.qos.logback.core.joran.spi.JoranException;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.openecard.addon.AddonPropertiesException;
import org.openecard.common.I18n;
import org.openecard.common.util.FileUtils;
import org.openecard.richclient.LogbackConfig;
import org.openecard.richclient.gui.manage.SettingsFactory;
import org.openecard.richclient.gui.manage.SettingsGroup;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class LogSettingsGroup
extends SettingsGroup {
    private static final long serialVersionUID = 1L;
    private static final I18n lang = I18n.getTranslation("addon");
    private static final Logger LOG = LoggerFactory.getLogger(LogSettingsGroup.class);
    private static final String GROUP = "addon.core.logging.group_name";
    private static final String ROOT_NAME = "addon.core.logging.root";
    private static final String ROOT_DESC = "addon.core.logging.root.desc";
    private static final String ROOT_KEY = "logging.root";
    private static final String PAOS_NAME = "addon.core.logging.paos";
    private static final String PAOS_DESC = "addon.core.logging.paos.desc";
    private static final String PAOS_KEY = "org.openecard.transport.paos";
    private static final String EAC_NAME = "addon.core.logging.eac";
    private static final String EAC_DESC = "addon.core.logging.eac.desc";
    private static final String EAC_KEY = "org.openecard.sal.protocol.eac";
    private static final String PACE_NAME = "addon.core.logging.pace";
    private static final String PACE_DESC = "addon.core.logging.pace.desc";
    private static final String PACE_KEY = "org.openecard.ifd.protocol.pace";
    private static final String TRCHECKS_NAME = "addon.core.logging.trchecks";
    private static final String TRCHECKS_DESC = "addon.core.logging.trchecks.desc";
    private static final String TRCHECKS_KEY = "org.openecard.common.util.TR03112Utils";
    private static final String TCTOKEN_NAME = "addon.core.logging.tctoken";
    private static final String TCTOKEN_DESC = "addon.core.logging.tctoken.desc";
    private static final String TCTOKEN_KEY = "org.openecard.binding.tctoken";
    private static final String EVENT_NAME = "addon.core.logging.event";
    private static final String EVENT_DESC = "addon.core.logging.event.desc";
    private static final String EVENT_KEY = "org.openecard.event";
    private static final String HTTPBIND_NAME = "addon.core.logging.httpbind";
    private static final String HTTPBIND_DESC = "addon.core.logging.httpbind.desc";
    private static final String HTTPBIND_KEY = "org.openecard.control.binding.http";
    private static final String ADDON_NAME = "addon.core.logging.addon";
    private static final String ADDON_DESC = "addon.core.logging.addon.desc";
    private static final String ADDON_KEY = "org.openecard.addon";
    private static final String SALSTATE_NAME = "addon.core.logging.salstate";
    private static final String SALSTATE_DESC = "addon.core.logging.salstate.desc";
    private static final String SALSTATE_KEY = "org.openecard.common.sal.state";
    private static final String MDLW_NAME = "addon.core.logging.middleware";
    private static final String MDLW_DESC = "addon.core.logging.middleware.desc";
    private static final String MDLW_KEY = "org.openecard.mdlw.sal";
    private static final String MDLW_EVENT_NAME = "addon.core.logging.middleware-event";
    private static final String MDLW_EVENT_DESC = "addon.core.logging.middleware-event.desc";
    private static final String MDLW_EVENT_KEY = "org.openecard.mdlw.event";
    private static final String CG_NAME = "addon.core.logging.chipgateway";
    private static final String CG_DESC = "addon.core.logging.chipgateway.desc";
    private static final String CG_KEY = "org.openecard.addons.cg";

    public LogSettingsGroup() {
        super(lang.translationForKey(GROUP, new Object[0]), SettingsFactory.getInstance(LogSettingsGroup.loadProperties()));
        this.addSelectionItem(lang.translationForKey(ROOT_NAME, new Object[0]), lang.translationForKey(ROOT_DESC, new Object[0]), ROOT_KEY, "ERROR", "WARN", "INFO", "DEBUG");
        this.addLogLevelBox(lang.translationForKey(PAOS_NAME, new Object[0]), lang.translationForKey(PAOS_DESC, new Object[0]), PAOS_KEY);
        this.addLogLevelBox(lang.translationForKey(EAC_NAME, new Object[0]), lang.translationForKey(EAC_DESC, new Object[0]), EAC_KEY);
        this.addLogLevelBox(lang.translationForKey(PACE_NAME, new Object[0]), lang.translationForKey(PACE_DESC, new Object[0]), PACE_KEY);
        this.addLogLevelBox(lang.translationForKey(TRCHECKS_NAME, new Object[0]), lang.translationForKey(TRCHECKS_DESC, new Object[0]), TRCHECKS_KEY);
        this.addLogLevelBox(lang.translationForKey(TCTOKEN_NAME, new Object[0]), lang.translationForKey(TCTOKEN_DESC, new Object[0]), TCTOKEN_KEY);
        this.addLogLevelBox(lang.translationForKey(EVENT_NAME, new Object[0]), lang.translationForKey(EVENT_DESC, new Object[0]), EVENT_KEY);
        this.addLogLevelBox(lang.translationForKey(HTTPBIND_NAME, new Object[0]), lang.translationForKey(HTTPBIND_DESC, new Object[0]), HTTPBIND_KEY);
        this.addLogLevelBox(lang.translationForKey(ADDON_NAME, new Object[0]), lang.translationForKey(ADDON_DESC, new Object[0]), ADDON_KEY);
        this.addLogLevelBox(lang.translationForKey(SALSTATE_NAME, new Object[0]), lang.translationForKey(SALSTATE_DESC, new Object[0]), SALSTATE_KEY);
        this.addLogLevelBox(lang.translationForKey(MDLW_NAME, new Object[0]), lang.translationForKey(MDLW_DESC, new Object[0]), MDLW_KEY);
        this.addLogLevelBox(lang.translationForKey(MDLW_EVENT_NAME, new Object[0]), lang.translationForKey(MDLW_EVENT_DESC, new Object[0]), MDLW_EVENT_KEY);
        this.addLogLevelBox(lang.translationForKey(CG_NAME, new Object[0]), lang.translationForKey(CG_DESC, new Object[0]), CG_KEY);
        JComponent panel = this.createSupportPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 10, 0, 5);
        constraints.fill = 0;
        constraints.gridheight = -1;
        constraints.gridwidth = -1;
        constraints.gridx = 0;
        constraints.gridy = this.itemIdx++;
        constraints.anchor = 17;
        this.getContainer().add((Component)panel, constraints);
    }

    private JComboBox addLogLevelBox(String name, String desc, String key) {
        String[] levels = new String[]{"", "WARN", "INFO", "DEBUG"};
        return this.addSelectionItem(name, desc, key, levels);
    }

    @Override
    protected void saveProperties() throws IOException, SecurityException, AddonPropertiesException {
        try {
            File confFile = LogbackConfig.getConfFile();
            InputStream is = FileUtils.resolveResourceAsStream(LogSettingsGroup.class, "/logback.xml");
            try (FileOutputStream os = new FileOutputStream(confFile);){
                int n;
                byte[] buffer = new byte[4096];
                while ((n = is.read(buffer)) > 0) {
                    os.write(buffer, 0, n);
                }
            }
            WSMarshaller m = WSMarshallerFactory.createInstance();
            m.removeAllTypeClasses();
            FileInputStream fin = new FileInputStream(confFile);
            Document conf = m.str2doc(fin);
            String val = this.properties.getProperty(ROOT_KEY);
            val = val != null ? val : "ERROR";
            LogSettingsGroup.setRootlevel(conf, val);
            val = this.properties.getProperty(PAOS_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, PAOS_KEY, val);
            val = this.properties.getProperty(EAC_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, EAC_KEY, val);
            val = this.properties.getProperty(PACE_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, PACE_KEY, val);
            val = this.properties.getProperty(TRCHECKS_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, TRCHECKS_KEY, val);
            val = this.properties.getProperty(TCTOKEN_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, TCTOKEN_KEY, val);
            val = this.properties.getProperty(EVENT_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, EVENT_KEY, val);
            val = this.properties.getProperty(HTTPBIND_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, HTTPBIND_KEY, val);
            val = this.properties.getProperty(ADDON_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, ADDON_KEY, val);
            val = this.properties.getProperty(SALSTATE_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, SALSTATE_KEY, val);
            val = this.properties.getProperty(MDLW_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, MDLW_KEY, val);
            val = this.properties.getProperty(MDLW_EVENT_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, MDLW_EVENT_KEY, val);
            val = this.properties.getProperty(CG_KEY);
            val = val != null ? val : "";
            LogSettingsGroup.setLoglevel(conf, CG_KEY, val);
            try (FileWriter w = new FileWriter(confFile);){
                String confStr = m.doc2str(conf);
                w.write(confStr);
            }
            LogbackConfig.load();
        }
        catch (JoranException ex) {
            throw new AddonPropertiesException(ex.getMessage(), ex);
        }
        catch (TransformerException | WSMarshallerException | SAXException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private static Properties loadProperties() {
        try {
            File confFile = LogbackConfig.getConfFile();
            if (!confFile.exists()) {
                return new Properties();
            }
            WSMarshaller m = WSMarshallerFactory.createInstance();
            m.removeAllTypeClasses();
            FileInputStream fin = new FileInputStream(confFile);
            Document conf = m.str2doc(fin);
            Properties p = new Properties();
            p.setProperty(ROOT_KEY, LogSettingsGroup.getRootlevel(conf));
            p.setProperty(PAOS_KEY, LogSettingsGroup.getLoglevel(conf, PAOS_KEY));
            p.setProperty(EAC_KEY, LogSettingsGroup.getLoglevel(conf, EAC_KEY));
            p.setProperty(PACE_KEY, LogSettingsGroup.getLoglevel(conf, PACE_KEY));
            p.setProperty(TRCHECKS_KEY, LogSettingsGroup.getLoglevel(conf, TRCHECKS_KEY));
            p.setProperty(TCTOKEN_KEY, LogSettingsGroup.getLoglevel(conf, TCTOKEN_KEY));
            p.setProperty(EVENT_KEY, LogSettingsGroup.getLoglevel(conf, EVENT_KEY));
            p.setProperty(HTTPBIND_KEY, LogSettingsGroup.getLoglevel(conf, HTTPBIND_KEY));
            p.setProperty(ADDON_KEY, LogSettingsGroup.getLoglevel(conf, ADDON_KEY));
            p.setProperty(SALSTATE_KEY, LogSettingsGroup.getLoglevel(conf, SALSTATE_KEY));
            p.setProperty(MDLW_KEY, LogSettingsGroup.getLoglevel(conf, MDLW_KEY));
            p.setProperty(MDLW_EVENT_KEY, LogSettingsGroup.getLoglevel(conf, MDLW_EVENT_KEY));
            p.setProperty(CG_KEY, LogSettingsGroup.getLoglevel(conf, CG_KEY));
            return p;
        }
        catch (IOException | AddonPropertiesException | WSMarshallerException | SAXException ex) {
            return new Properties();
        }
    }

    private static String getLoglevel(Document conf, String path) throws AddonPropertiesException {
        try {
            XPath p = XPathFactory.newInstance().newXPath();
            XPathExpression exp = p.compile(String.format("/configuration/logger[@name='%s']", path));
            Element e = (Element)exp.evaluate(conf, XPathConstants.NODE);
            if (e == null) {
                return "";
            }
            return e.getAttribute("level");
        }
        catch (XPathExpressionException | DOMException ex) {
            throw new AddonPropertiesException("Failed to operate on log config document.");
        }
    }

    private static void setLoglevel(Document conf, String path, String level) throws AddonPropertiesException {
        try {
            XPath p = XPathFactory.newInstance().newXPath();
            XPathExpression exp = p.compile(String.format("/configuration/logger[@name='%s']", path));
            Element e = (Element)exp.evaluate(conf, XPathConstants.NODE);
            if (e == null) {
                if (!level.isEmpty()) {
                    e = conf.createElement("logger");
                    e.setAttribute("name", path);
                    e.setAttribute("level", level);
                    conf.getDocumentElement().appendChild(e);
                }
                return;
            }
            if (level.isEmpty()) {
                e.getParentNode().removeChild(e);
            } else {
                e.setAttribute("level", level);
            }
        }
        catch (XPathExpressionException | DOMException ex) {
            throw new AddonPropertiesException("Failed to operate on log config document.");
        }
    }

    private static String getRootlevel(Document conf) throws AddonPropertiesException {
        try {
            XPath p = XPathFactory.newInstance().newXPath();
            XPathExpression exp = p.compile("/configuration/root");
            Element e = (Element)exp.evaluate(conf, XPathConstants.NODE);
            if (e == null) {
                throw new AddonPropertiesException("Logging config is invalid, the root element is missing.");
            }
            return e.getAttribute("level");
        }
        catch (XPathExpressionException | DOMException ex) {
            throw new AddonPropertiesException("Failed to operate on log config document.");
        }
    }

    private static void setRootlevel(Document conf, String level) throws AddonPropertiesException {
        try {
            XPath p = XPathFactory.newInstance().newXPath();
            XPathExpression exp = p.compile("/configuration/root");
            Element e = (Element)exp.evaluate(conf, XPathConstants.NODE);
            if (e == null) {
                throw new AddonPropertiesException("Logging config is invalid, the root element is missing.");
            }
            e.setAttribute("level", level);
        }
        catch (XPathExpressionException | DOMException ex) {
            throw new AddonPropertiesException("Failed to operate on log config document.");
        }
    }

    private JComponent createSupportPanel() {
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument doc = (HTMLDocument)kit.createDefaultDocument();
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setEditorKit(kit);
        editorPane.setDocument(doc);
        editorPane.setPreferredSize(new Dimension(520, 250));
        try {
            URL url = I18n.getTranslation("richclient").translationForFile("debug", "html");
            editorPane.setPage(url);
        }
        catch (IOException ex) {
            editorPane.setText("Page not found.");
        }
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                LogSettingsGroup.this.openUrl(e);
            }
        });
        return editorPane;
    }

    private void openUrl(HyperlinkEvent event) {
        HyperlinkEvent.EventType type = event.getEventType();
        if (type == HyperlinkEvent.EventType.ACTIVATED) {
            String url = event.getURL().toExternalForm();
            try {
                boolean browserOpened = false;
                URI uri = new URI(url);
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(uri);
                        browserOpened = true;
                    }
                    catch (IOException ex) {
                        LOG.debug(ex.getMessage(), ex);
                    }
                }
                if (!browserOpened) {
                    ProcessBuilder pb = new ProcessBuilder("xdg-open", uri.toString());
                    try {
                        pb.start();
                    }
                    catch (IOException ex) {
                        LOG.debug(ex.getMessage(), ex);
                    }
                }
            }
            catch (URISyntaxException ex) {
                LOG.debug(ex.getMessage(), ex);
            }
        }
    }
}

