/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.io.IOException;
import java.util.Properties;
import org.openecard.addon.AddonProperties;
import org.openecard.addon.AddonPropertiesException;
import org.openecard.common.OpenecardProperties;
import org.openecard.richclient.gui.manage.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsFactory {
    private static final Logger logger = LoggerFactory.getLogger(AddonPropertiesWrapper.class);

    public static Settings getInstance() {
        return new OpenecardPropertiesWrapper();
    }

    public static Settings getInstance(Properties props) {
        return new NonSavingProperties(props);
    }

    public static Settings getInstance(AddonProperties props) {
        return new AddonPropertiesWrapper(props);
    }

    private static class NonSavingProperties
    implements Settings {
        protected final Properties props;

        public NonSavingProperties(Properties props) {
            this.props = props;
        }

        @Override
        public void setProperty(String key, String value) {
            this.props.setProperty(key, value);
        }

        @Override
        public String getProperty(String key) {
            return this.props.getProperty(key);
        }

        @Override
        public void store() throws IOException {
            OpenecardProperties.writeChanges(this.props);
        }
    }

    public static class OpenecardPropertiesWrapper
    extends NonSavingProperties {
        private OpenecardPropertiesWrapper() {
            super(OpenecardProperties.properties());
        }

        @Override
        public void store() throws IOException {
            OpenecardProperties.writeChanges(this.props);
        }
    }

    public static class AddonPropertiesWrapper
    implements Settings {
        private final AddonProperties props;

        private AddonPropertiesWrapper(AddonProperties props) {
            this.props = props;
            try {
                props.loadProperties();
            }
            catch (AddonPropertiesException ex) {
                logger.error("Failed to load AddonProperties.", ex);
            }
        }

        @Override
        public void setProperty(String key, String value) {
            this.props.setProperty(key, value);
        }

        @Override
        public String getProperty(String key) {
            return this.props.getProperty(key);
        }

        @Override
        public void store() throws AddonPropertiesException {
            this.props.saveProperties();
        }
    }
}

