/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.manage;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openecard.addon.AddonPropertiesException;
import org.openecard.common.I18n;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.openecard.richclient.gui.manage.AboutPanel;
import org.openecard.richclient.gui.manage.ActionPanel;
import org.openecard.richclient.gui.manage.SettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddonPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AddonPanel.class);
    private final I18n lang = I18n.getTranslation("addon");
    private static final int LOGO_WIDTH = 45;
    private static final int LOGO_HEIGHT = 45;
    private Image logo;
    private SettingsPanel settingsPanel;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();

    public AddonPanel(@Nullable ActionPanel actionPanel, @Nullable SettingsPanel settingsPanel, @Nullable AboutPanel aboutPanel, @Nonnull String name, @Nullable String description, @Nullable Image logo) {
        this.setLayout(new BorderLayout(0, 0));
        this.logo = logo;
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.add(tabbedPane);
        Dimension dim = new Dimension(100, 100);
        if (actionPanel != null) {
            JScrollPane actionScrollPane = new JScrollPane(actionPanel);
            actionScrollPane.setHorizontalScrollBarPolicy(30);
            actionScrollPane.setVerticalScrollBarPolicy(20);
            actionScrollPane.setMinimumSize(dim);
            actionScrollPane.setPreferredSize(dim);
            actionScrollPane.setBorder(EMPTY_BORDER);
            tabbedPane.addTab(this.lang.translationForKey("addon.panel.tab.function", new Object[0]), null, actionScrollPane, null);
        }
        if (settingsPanel != null) {
            if (settingsPanel instanceof SettingsPanel) {
                this.settingsPanel = settingsPanel;
            }
            tabbedPane.addTab(this.lang.translationForKey("addon.panel.tab.settings", new Object[0]), null, settingsPanel, null);
        }
        if (aboutPanel != null) {
            tabbedPane.addTab(this.lang.translationForKey("addon.panel.tab.about", new Object[0]), null, aboutPanel, null);
        }
        this.createHeader(name, description);
    }

    public AddonPanel(@Nonnull JPanel singlePanel, @Nonnull String name, @Nullable String description, @Nullable Image logo) {
        JComponent panel;
        this.setLayout(new BorderLayout(0, 0));
        this.logo = logo;
        this.createHeader(name, description);
        if (!(singlePanel instanceof AboutPanel) && !(singlePanel instanceof SettingsPanel)) {
            JScrollPane singleScrollPane = new JScrollPane(singlePanel);
            singleScrollPane.setHorizontalScrollBarPolicy(31);
            singleScrollPane.setVerticalScrollBarPolicy(20);
            Dimension dim = new Dimension(this.getWidth(), this.getHeight() - 75);
            singleScrollPane.setMinimumSize(dim);
            singleScrollPane.setPreferredSize(dim);
            singleScrollPane.setBorder(EMPTY_BORDER);
            panel = singleScrollPane;
        } else {
            panel = singlePanel;
        }
        if (singlePanel instanceof SettingsPanel) {
            this.settingsPanel = (SettingsPanel)singlePanel;
        }
        this.add(panel);
    }

    public void saveProperties() {
        try {
            if (this.settingsPanel != null) {
                this.settingsPanel.saveProperties();
            }
        }
        catch (IOException ex) {
            logger.error("Failed to save settings.", ex);
        }
        catch (SecurityException ex) {
            logger.error("Missing permissions to save settings.", ex);
        }
        catch (AddonPropertiesException ex) {
            logger.error("Failed to save addon settings.", ex);
        }
    }

    @Nonnull
    public Image getLogo() {
        Image result = this.logo == null ? this.getDefaultLogo() : this.logo.getScaledInstance(45, 45, 4);
        return result;
    }

    private void createHeader(@Nonnull String name, @Nullable String description) {
        Box panel = Box.createVerticalBox();
        this.add((Component)panel, "North");
        Box content = Box.createVerticalBox();
        content.setAlignmentX(0.0f);
        content.setBorder(new EmptyBorder(5, 20, 0, 0));
        content.setMinimumSize(new Dimension(50, 50));
        content.setPreferredSize(new Dimension(50, 50));
        panel.add(content);
        JLabel nameLabel = new JLabel(name);
        nameLabel.setAlignmentX(0.0f);
        nameLabel.setFont(nameLabel.getFont().deriveFont(1, 19.0f));
        nameLabel.setForeground(Color.getHSBColor(0.0f, 0.0f, 0.25f));
        content.add(nameLabel);
        if (description != null && !description.isEmpty()) {
            content.add(Box.createVerticalStrut(5));
            JLabel descLabel = new JLabel(description);
            descLabel.setAlignmentX(0.0f);
            descLabel.setFont(descLabel.getFont().deriveFont(0));
            descLabel.setForeground(Color.getHSBColor(0.0f, 0.0f, 0.25f));
            content.add(descLabel);
        }
        panel.add(Box.createVerticalStrut(4));
        JSeparator rule = new JSeparator(0);
        rule.setBorder(new EmptyBorder(10, 20, 10, 20));
        rule.setAlignmentX(0.0f);
        panel.add(rule);
        panel.add(Box.createVerticalStrut(5));
    }

    private Image getDefaultLogo() {
        Image original = GraphicsUtil.createImage(OecLogoBgWhite.class, 45, 45);
        BufferedImage result = new BufferedImage(45, 45, 2);
        Graphics2D g = result.createGraphics();
        g.setComposite(AlphaComposite.SrcOver.derive(0.3f));
        g.drawImage(original, 0, 0, null);
        g.dispose();
        return result;
    }
}

