/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui.components;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.openecard.richclient.gui.components.MathNumberEditorFormatter;
import org.openecard.richclient.gui.components.SpinnerMathNumberModel;

public class MathNumberEditor
extends JSpinner.DefaultEditor {
    public MathNumberEditor(JSpinner spinner, DecimalFormat format) {
        super(spinner);
        if (!(spinner.getModel() instanceof SpinnerMathNumberModel)) {
            throw new IllegalArgumentException("model not a SpinnerMathNumberModel");
        }
        SpinnerMathNumberModel model = (SpinnerMathNumberModel)spinner.getModel();
        MathNumberEditorFormatter formatter = new MathNumberEditorFormatter(model, format);
        DefaultFormatterFactory factory = new DefaultFormatterFactory(formatter);
        JFormattedTextField ftf = this.getTextField();
        ftf.setEditable(true);
        ftf.setFormatterFactory(factory);
        ftf.setHorizontalAlignment(4);
        try {
            String maxString = formatter.valueToString(model.getMinimum());
            String minString = formatter.valueToString(model.getMaximum());
            ftf.setColumns(Math.max(maxString.length(), minString.length()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public DecimalFormat getFormat() {
        DecimalFormat format = (DecimalFormat)((NumberFormatter)this.getTextField().getFormatter()).getFormat();
        format.setRoundingMode(RoundingMode.HALF_UP);
        return format;
    }

    public SpinnerMathNumberModel getModel() {
        return (SpinnerMathNumberModel)this.getSpinner().getModel();
    }
}

