/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.richclient.gui;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.openecard.addon.AddonManager;
import org.openecard.common.AppVersion;
import org.openecard.common.I18n;
import org.openecard.common.interfaces.Environment;
import org.openecard.gui.graphics.GraphicsUtil;
import org.openecard.gui.graphics.OecLogoBgWhite;
import org.openecard.gui.graphics.OecLogoBlackBgTransparent;
import org.openecard.gui.graphics.OecLogoWhiteBgTransparent;
import org.openecard.richclient.RichClient;
import org.openecard.richclient.gui.GuiUtils;
import org.openecard.richclient.gui.InfoFrame;
import org.openecard.richclient.gui.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppTray {
    private static final Logger LOG = LoggerFactory.getLogger(AppTray.class);
    private static final String ICON_LOADER = "loader";
    private static final String ICON_LOGO = "logo";
    private final I18n lang = I18n.getTranslation("richclient");
    private final RichClient client;
    private SystemTray tray;
    private TrayIcon trayIcon;
    private Status status;
    private InfoFrame frame;
    private Boolean isLinux;
    private Boolean isKde;
    private boolean trayAvailable;

    public AppTray(RichClient client) {
        this.client = client;
    }

    public void beginSetup() {
        if (this.isTraySupported()) {
            this.setupTrayIcon();
        } else {
            this.setupFrame();
        }
    }

    public void endSetup(Environment env, AddonManager manager) {
        this.status = new Status(this, env, manager);
        if (this.trayAvailable) {
            this.trayIcon.setImage(this.getTrayIconImage(ICON_LOGO));
            this.trayIcon.setToolTip(this.lang.translationForKey("tray.title", AppVersion.getName()));
        } else {
            this.frame.setVisible(false);
            this.status.setInfoPanel(this.frame);
            this.frame.pack();
            this.frame.setResizable(false);
            this.frame.setLocationRelativeTo(null);
            this.frame.setState(1);
            this.frame.setVisible(true);
        }
    }

    public Status status() {
        return this.status;
    }

    public void shutdown() {
        if (this.trayAvailable) {
            if (!this.isMacOSX()) {
                String desc = this.lang.translationForKey("tray.message.shutdown", AppVersion.getName());
                this.trayIcon.displayMessage(AppVersion.getName(), desc, TrayIcon.MessageType.INFO);
            }
            this.client.teardown();
            this.tray.remove(this.trayIcon);
        } else {
            this.client.teardown();
        }
        System.exit(0);
    }

    private void setupTrayIcon() {
        this.trayAvailable = true;
        this.tray = SystemTray.getSystemTray();
        this.trayIcon = new TrayIcon(this.getTrayIconImage(ICON_LOADER), this.lang.translationForKey("tray.message.loading", AppVersion.getName()), null);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AppTray.this.status != null) {
                    AppTray.this.status.showInfo(new Point(e.getX(), e.getY()));
                }
            }
        });
        try {
            this.tray.add(this.trayIcon);
        }
        catch (AWTException ex) {
            LOG.error("TrayIcon could not be added to the system tray.", ex);
            this.tray = null;
            this.trayIcon = null;
            this.setupFrame();
        }
    }

    private Image getTrayIconImage(String name) {
        Dimension dim = this.tray.getTrayIconSize();
        if (this.isLinux()) {
            return this.getImageLinux(name, dim);
        }
        if (this.isMacOSX()) {
            return this.getImageMacOSX(name, dim);
        }
        return this.getImageDefault(name, dim);
    }

    private Image getImageLinux(String name, Dimension dim) {
        if (name.equals(ICON_LOADER)) {
            return GuiUtils.getImage("loader_icon_linux_default_256.gif");
        }
        return GraphicsUtil.createImage(OecLogoBgWhite.class, dim.width, dim.height);
    }

    private Image getImageMacOSX(String name, Dimension dim) {
        Class c = this.isMacMenuBarDarkMode() ? OecLogoWhiteBgTransparent.class : OecLogoBlackBgTransparent.class;
        return GraphicsUtil.createImage(c, dim.width - 2, dim.height - 2, dim.width, dim.height, 1, 1);
    }

    private Image getImageDefault(String name, Dimension dim) {
        if (name.equals(ICON_LOADER)) {
            return GuiUtils.getImage("loader_icon_default_256.gif");
        }
        return GraphicsUtil.createImage(OecLogoBgWhite.class, dim.width, dim.height);
    }

    private boolean isMacOSX() {
        return System.getProperty("os.name").contains("OS X");
    }

    private boolean isMacMenuBarDarkMode() {
        final FutureTask<Integer> f = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                Process proc = Runtime.getRuntime().exec(new String[]{"defaults", "read", "-g", "AppleInterfaceStyle"});
                proc.waitFor();
                return proc.exitValue();
            }
        });
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    f.run();
                }
            });
            t.setDaemon(true);
            t.start();
            Integer result = f.get(100L, TimeUnit.MILLISECONDS);
            return result == 0;
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            LOG.warn("Could not determine, whether 'dark mode' is being used. Falling back to default (light) mode.", ex);
            f.cancel(true);
            return false;
        }
    }

    private boolean isLinux() {
        if (this.isLinux == null) {
            String os = System.getProperty("os.name").toLowerCase();
            this.isLinux = os.contains("nux");
        }
        return this.isLinux;
    }

    private boolean isKde() {
        if (this.isKde == null) {
            String kdeSession = System.getenv("KDE_FULL_SESSION");
            this.isKde = kdeSession != null && !kdeSession.isEmpty() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.isKde;
    }

    private boolean isGnome() {
        return "GNOME".equals(System.getenv("XDM_CURRENT_DESKTOP")) || "GNOME".equals(System.getenv("XDG_CURRENT_DESKTOP"));
    }

    private boolean isPlasma() {
        if (this.isKde()) {
            return "5".equals(System.getenv("KDE_SESSION_VERSION"));
        }
        return false;
    }

    private boolean isTraySupported() {
        return SystemTray.isSupported() && !this.isPlasma() && !this.isGnome() && !this.isMacOSX();
    }

    private void setupFrame() {
        this.trayAvailable = false;
        this.frame = new InfoFrame(this.lang.translationForKey("tray.title", AppVersion.getName()));
        this.frame.setDefaultCloseOperation(3);
        this.frame.setIconImage(GraphicsUtil.createImage(OecLogoBgWhite.class, 256, 256));
        JLabel label = new JLabel(new ImageIcon(GraphicsUtil.createImage(OecLogoBgWhite.class, 256, 256)));
        ImageIcon logo = new ImageIcon(GraphicsUtil.createImage(OecLogoBgWhite.class, 256, 256));
        Container c = this.frame.getContentPane();
        c.setPreferredSize(new Dimension(logo.getIconWidth(), logo.getIconHeight()));
        c.setBackground(Color.white);
        c.add(label);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }
}

