/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin;

import iso.std.iso_iec._24727.tech.schema.ActionType;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationConnectResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationDisconnect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPath;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDGet;
import iso.std.iso_iec._24727.tech.schema.DIDGetResponse;
import iso.std.iso_iec._24727.tech.schema.DIDList;
import iso.std.iso_iec._24727.tech.schema.DIDListResponse;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DIDUpdate;
import iso.std.iso_iec._24727.tech.schema.PinCompareDIDUpdateDataType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.addon.ActionInitializationException;
import org.openecard.addon.Context;
import org.openecard.common.WSHelper;
import org.openecard.plugins.pinplugin.AbstractPINAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePinInSALAction
extends AbstractPINAction {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePinInSALAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        List<ConnectionHandleType> connectedCards = null;
        try {
            connectedCards = this.connectCards();
            if (connectedCards.isEmpty()) {
                // empty if block
            }
            for (ConnectionHandleType nextCard : connectedCards) {
                String didName = null;
                try {
                    didName = this.getPinDid(nextCard);
                }
                catch (WSHelper.WSException ex) {
                    LOG.info("Skipping card, because it has no PIN DID.");
                    continue;
                }
                DIDUpdate updateReq = new DIDUpdate();
                updateReq.setConnectionHandle(nextCard);
                updateReq.setDIDName(didName);
                PinCompareDIDUpdateDataType updateData = new PinCompareDIDUpdateDataType();
                updateData.setProtocol("urn:oid:1.3.162.15480.3.0.9");
                updateReq.setDIDUpdateData(updateData);
                this.dispatcher.safeDeliver(updateReq);
            }
        }
        catch (WSHelper.WSException wSException) {
            if (connectedCards != null) {
                for (ConnectionHandleType nextHandle : connectedCards) {
                    CardApplicationDisconnect dr = new CardApplicationDisconnect();
                    dr.setConnectionHandle(nextHandle);
                    dr.setAction(ActionType.RESET);
                    this.dispatcher.safeDeliver(dr);
                }
            }
        }
        finally {
            if (connectedCards != null) {
                for (ConnectionHandleType nextHandle : connectedCards) {
                    CardApplicationDisconnect dr = new CardApplicationDisconnect();
                    dr.setConnectionHandle(nextHandle);
                    dr.setAction(ActionType.RESET);
                    this.dispatcher.safeDeliver(dr);
                }
            }
        }
    }

    @Override
    public void init(Context aCtx) throws ActionInitializationException {
        this.dispatcher = aCtx.getDispatcher();
        this.gui = aCtx.getUserConsent();
        this.recognition = aCtx.getRecognition();
        this.cardStates = aCtx.getCardStates();
        this.evDispatcher = aCtx.getEventDispatcher();
    }

    @Override
    public void destroy() {
    }

    private List<ConnectionHandleType> connectCards() throws WSHelper.WSException {
        CardApplicationPath pathReq = new CardApplicationPath();
        CardApplicationPathType pathType = new CardApplicationPathType();
        pathReq.setCardAppPathRequest(pathType);
        CardApplicationPathResponse pathRes = (CardApplicationPathResponse)this.dispatcher.safeDeliver(pathReq);
        WSHelper.checkResult(pathRes);
        ArrayList<ConnectionHandleType> connectedCards = new ArrayList<ConnectionHandleType>();
        for (CardApplicationPathType path : pathRes.getCardAppPathResultSet().getCardApplicationPathResult()) {
            try {
                CardApplicationConnect conReq = new CardApplicationConnect();
                conReq.setCardApplicationPath(path);
                conReq.setExclusiveUse(false);
                CardApplicationConnectResponse conRes = (CardApplicationConnectResponse)this.dispatcher.safeDeliver(conReq);
                WSHelper.checkResult(conRes);
                connectedCards.add(conRes.getConnectionHandle());
            }
            catch (WSHelper.WSException ex) {
                LOG.error("Failed to connect card, skipping this entry.", ex);
            }
        }
        return connectedCards;
    }

    @Nonnull
    private String getPinDid(ConnectionHandleType handle) throws WSHelper.WSException {
        DIDList listReq = new DIDList();
        listReq.setConnectionHandle(handle);
        DIDListResponse listRes = (DIDListResponse)this.dispatcher.safeDeliver(listReq);
        WSHelper.checkResult(listRes);
        for (String didName : listRes.getDIDNameList().getDIDName()) {
            DIDGet getReq = new DIDGet();
            getReq.setConnectionHandle(handle);
            getReq.setDIDName(didName);
            DIDGetResponse getRes = (DIDGetResponse)this.dispatcher.safeDeliver(getReq);
            DIDStructureType struct = getRes.getDIDStructure();
            if (struct == null || !"urn:oid:1.3.162.15480.3.0.9".equals(struct.getDIDMarker().getProtocol())) continue;
            return didName;
        }
        Result r = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/sal#inappropriateProtocolForAction", "No PIN DID found.");
        throw WSHelper.createException(r);
    }
}

