/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.plugins.pinplugin;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.Disconnect;
import org.openecard.addon.ActionInitializationException;
import org.openecard.addon.Context;
import org.openecard.common.WSHelper;
import org.openecard.plugins.pinplugin.AbstractPINAction;
import org.openecard.plugins.pinplugin.RecognizedState;
import org.openecard.plugins.pinplugin.gui.ChangePINDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangePINAction
extends AbstractPINAction {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePINAction.class);

    @Override
    public void execute() {
        boolean nativePace;
        ConnectionHandleType cHandle = this.waitForCardType("http://bsi.bund.de/cif/npa.xml");
        if (cHandle == null) {
            LOG.debug("User cancelled card insertion.");
            return;
        }
        cHandle = this.connectToRootApplication(cHandle);
        RecognizedState pinState = this.recognizeState(cHandle);
        try {
            nativePace = this.genericPACESupport(cHandle);
        }
        catch (WSHelper.WSException e) {
            LOG.error("Could not get capabilities from reader.");
            return;
        }
        ChangePINDialog uc = new ChangePINDialog(this.gui, this.dispatcher, cHandle, pinState, !nativePace);
        uc.show();
        Disconnect d = new Disconnect();
        d.setSlotHandle(cHandle.getSlotHandle());
        this.dispatcher.safeDeliver(d);
    }

    @Override
    public void init(Context ctx) throws ActionInitializationException {
        this.dispatcher = ctx.getDispatcher();
        this.gui = ctx.getUserConsent();
        this.recognition = ctx.getRecognition();
        this.cardStates = ctx.getCardStates();
        this.evDispatcher = ctx.getEventDispatcher();
    }

    @Override
    public void destroy() {
    }
}

