/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal.config;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.CardTypeType;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.openecard.common.util.FileUtils;
import org.openecard.common.util.FuturePromise;
import org.openecard.common.util.Promise;
import org.openecard.mdlw.sal.config.CardSpecType;
import org.openecard.mdlw.sal.config.MiddlewareConfigType;
import org.openecard.mdlw.sal.config.MiddlewareSALConfig;
import org.openecard.mdlw.sal.config.MiddlewareSpecType;
import org.openecard.ws.marshal.WSMarshaller;
import org.openecard.ws.marshal.WSMarshallerException;
import org.openecard.ws.marshal.WSMarshallerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class MiddlewareConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MiddlewareConfig.class);
    private static final String MIDDLEWARE_CONFIG_PATH = "mwconfig.xml";
    private static final String CARD_IMAGE_PATH = "card-images/";
    private static final String CIF_TEMPLATE_PATH = "/middleware/mw_cif_template.xml";
    private static final Promise<Document> CIF_DOC;
    private static final Promise<WSMarshaller> MARSHALLER;
    private static final JAXBContext MW_CFG_CTX;
    private final Map<String, byte[]> cardImages = new HashMap<String, byte[]>();
    private MiddlewareConfigType middlewareConfigXml;
    private final List<MiddlewareSALConfig> mwSALConfigs = new ArrayList<MiddlewareSALConfig>();

    public MiddlewareConfig(@Nonnull InputStream bundleStream) throws IOException, FileNotFoundException, JAXBException {
        LOG.debug("Loading middleware config.");
        this.loadMwZIPConfig(bundleStream);
        this.addSALConfigs(false);
    }

    public MiddlewareConfig(@Nonnull String baseResPath) throws IOException, JAXBException {
        LOG.debug("Loading middleware config.");
        this.loadMwResourceConfig(baseResPath);
        this.addSALConfigs(true);
    }

    private void loadMwZIPConfig(InputStream is) throws JAXBException, IOException {
        this.middlewareConfigXml = new MiddlewareConfigType();
        try (ZipInputStream zipIn = new ZipInputStream(is);){
            ZipEntry zipEntry;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (!zipEntry.isDirectory()) {
                    String name = zipEntry.getName();
                    if (name.equals(MIDDLEWARE_CONFIG_PATH)) {
                        LOG.debug("Reading middleware config from XML file.");
                        ByteArrayInputStream tmpIn = new ByteArrayInputStream(FileUtils.toByteArray(zipIn));
                        this.middlewareConfigXml = (MiddlewareConfigType)MW_CFG_CTX.createUnmarshaller().unmarshal((InputStream)tmpIn);
                    }
                    if (name.startsWith(CARD_IMAGE_PATH)) {
                        String cardImageName = name.replace(CARD_IMAGE_PATH, "");
                        LOG.debug("CardImageName: " + cardImageName);
                        this.cardImages.put(cardImageName, FileUtils.toByteArray(zipIn));
                    }
                }
                zipIn.closeEntry();
            }
        }
        catch (IOException ex) {
            String msg = "Failed to read middleware config bundle.";
            LOG.error(msg, ex);
            throw new IOException(msg, ex);
        }
    }

    private void loadMwResourceConfig(String baseResPath) throws IOException, JAXBException {
        String imageBasePath = baseResPath + CARD_IMAGE_PATH;
        LOG.debug("Reading middleware config from XML file.");
        InputStream cfgIn = FileUtils.resolveResourceAsStream(this.getClass(), baseResPath + MIDDLEWARE_CONFIG_PATH);
        if (cfgIn == null) {
            throw new FileNotFoundException("Middleware config is not available.");
        }
        this.middlewareConfigXml = (MiddlewareConfigType)MW_CFG_CTX.createUnmarshaller().unmarshal(cfgIn);
        for (MiddlewareSpecType mSpec : this.middlewareConfigXml.getMiddlewareSpecs()) {
            for (CardSpecType cSpec : mSpec.getCardConfig().getCardSpecs()) {
                String cardImageName = cSpec.getCardImageName();
                if (this.cardImages.containsKey(cardImageName)) continue;
                LOG.debug("CardImageName: " + cardImageName);
                InputStream in = FileUtils.resolveResourceAsStream(this.getClass(), imageBasePath + cardImageName);
                if (in != null) {
                    this.cardImages.put(cardImageName, FileUtils.toByteArray(in));
                    continue;
                }
                LOG.error("Failed to load image {}.", (Object)cardImageName);
            }
        }
    }

    private void addSALConfigs(boolean internal) {
        ArrayList<MiddlewareSpecType> mwSpecs = this.middlewareConfigXml.getMiddlewareSpecs();
        for (MiddlewareSpecType mwSpec : mwSpecs) {
            MiddlewareSALConfig mwSALConfig = new MiddlewareSALConfig(this, mwSpec, internal);
            this.mwSALConfigs.add(mwSALConfig);
        }
    }

    @Nonnull
    public List<MiddlewareSALConfig> getMiddlewareSALConfigs() {
        return this.mwSALConfigs;
    }

    @Nullable
    public String mapMiddlewareType(@Nonnull String middlewareCardType) {
        for (MiddlewareSALConfig mwSALConfig : this.getMiddlewareSALConfigs()) {
            String mwType = mwSALConfig.mapMiddlewareType(middlewareCardType);
            if (mwType == null) continue;
            return mwType;
        }
        return null;
    }

    @Nullable
    public InputStream getCardImage(String imageName) {
        return new ByteArrayInputStream(this.cardImages.get(imageName));
    }

    @Nonnull
    private synchronized CardInfoType getCardInfoTemplate() {
        try {
            WSMarshaller m = MARSHALLER.deref();
            assert (m != null);
            Document doc = CIF_DOC.deref();
            CardInfoType cardInfo = (CardInfoType)m.unmarshal(doc, CardInfoType.class).getValue();
            return cardInfo;
        }
        catch (WSMarshallerException ex) {
            String msg = "Can not parse CardInfo-Document.";
            LOG.error(msg, ex);
            throw new RuntimeException(CARD_IMAGE_PATH, ex);
        }
        catch (InterruptedException ex) {
            String msg = "Shutdown requested while retrieving CIF template.";
            LOG.debug(msg);
            throw new RuntimeException(msg);
        }
        catch (NullPointerException ex) {
            String msg = "Marshaller and/ or CIF Template could not be loaded correctly.";
            LOG.error(msg, ex);
            throw new RuntimeException(msg);
        }
    }

    @Nonnull
    private CardTypeType mapCardSpecToCardType(CardSpecType cardSpec) {
        CardTypeType cardType = new CardTypeType();
        cardType.setObjectIdentifier(cardSpec.getObjectIdentifier());
        cardType.setDate(cardSpec.getDate());
        cardType.getCardTypeName().addAll(cardSpec.getCardTypeName());
        cardType.setStatus(cardSpec.getStatus());
        cardType.setVersion(cardSpec.getVersion());
        return cardType;
    }

    public CardInfoType getCardInfoByCardSpec(CardSpecType cardSpec) {
        CardInfoType cardInfo = this.getCardInfoTemplate();
        cardInfo.setCardType(this.mapCardSpecToCardType(cardSpec));
        return cardInfo;
    }

    static {
        MARSHALLER = new FuturePromise<WSMarshaller>(new Callable<WSMarshaller>(){

            @Override
            public WSMarshaller call() throws Exception {
                return WSMarshallerFactory.createInstance();
            }
        });
        CIF_DOC = new FuturePromise<Document>(new Callable<Document>(){

            @Override
            public Document call() throws Exception {
                InputStream in = FileUtils.resolveResourceAsStream(MiddlewareConfig.class, MiddlewareConfig.CIF_TEMPLATE_PATH);
                return ((WSMarshaller)MARSHALLER.deref()).str2doc(in);
            }
        });
        try {
            MW_CFG_CTX = JAXBContext.newInstance((Class[])new Class[]{MiddlewareConfigType.class});
        }
        catch (JAXBException ex) {
            throw new RuntimeException("Failed to initalize JAXB Marshaller", ex);
        }
    }
}

