/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import java.util.Map;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.mdlw.sal.PinEntryStep;
import org.openecard.mdlw.sal.enums.UserType;
import org.openecard.mdlw.sal.exceptions.AuthenticationException;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.PinBlockedException;
import org.openecard.mdlw.sal.exceptions.PinIncorrectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinEntryStepAction
extends StepAction {
    private static final Logger LOG = LoggerFactory.getLogger(PinEntryStepAction.class);
    private final PinEntryStep pinStep;

    public PinEntryStepAction(PinEntryStep pinStep) {
        super(pinStep);
        this.pinStep = pinStep;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        try {
            if (this.pinStep.isProtectedAuthPath()) {
                this.pinStep.getSession().loginExternal(UserType.User);
            } else {
                char[] pPin = this.getPin();
                this.pinStep.getSession().login(UserType.User, pPin);
            }
            this.pinStep.setPinAuthenticated();
            return new StepActionResult(StepActionResultStatus.NEXT);
        }
        catch (PinIncorrectException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PIN incorrect.", ex);
            } else {
                LOG.info("PIN incorrect.");
            }
            this.pinStep.setLastTryFailed();
            try {
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex1) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
        catch (PinBlockedException ex) {
            try {
                this.pinStep.setPinBlocked();
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex2) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
        catch (AuthenticationException ex) {
            LOG.error("Authentication error while entering the PIN.", ex);
            this.pinStep.setLastTryFailed();
            this.pinStep.setUnkownError();
            try {
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex1) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
        catch (CryptokiException ex) {
            LOG.error("Unkonw error while entering the PIN.", ex);
            this.pinStep.setLastTryFailed();
            this.pinStep.setUnkownError();
            try {
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex1) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
    }

    private char[] getPin() {
        for (InputInfoUnit info : this.pinStep.getInputInfoUnits()) {
            if (!"PIN_FIELD".equals(info.getID())) continue;
            return ((PasswordField)info).getValue();
        }
        return null;
    }
}

