/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import java.util.Arrays;
import java.util.Map;
import org.openecard.gui.StepResult;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.mdlw.sal.PinChangeStep;
import org.openecard.mdlw.sal.PinsDoNotMatchException;
import org.openecard.mdlw.sal.enums.UserType;
import org.openecard.mdlw.sal.exceptions.AuthenticationException;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.PinBlockedException;
import org.openecard.mdlw.sal.exceptions.PinIncorrectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinChangeStepAction
extends StepAction {
    private static final Logger LOG = LoggerFactory.getLogger(PinChangeStepAction.class);
    private final PinChangeStep pinStep;

    public PinChangeStepAction(PinChangeStep pinStep) {
        super(pinStep);
        this.pinStep = pinStep;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        try {
            if (this.pinStep.isCapturePuk()) {
                if (this.pinStep.isProtectedAuthPath()) {
                    this.pinStep.getSession().loginExternal(UserType.Security_Officer);
                    this.pinStep.getSession().initPinExternal();
                } else {
                    char[] puk = this.getPuk();
                    this.pinStep.getSession().login(UserType.Security_Officer, puk);
                    char[] newPin = this.getNewPin();
                    this.pinStep.getSession().initPin(newPin);
                }
            } else if (this.pinStep.isProtectedAuthPath()) {
                this.pinStep.getSession().changePinExternal();
            } else {
                char[] oldPin = this.getOldPin();
                char[] newPin = this.getNewPin();
                this.pinStep.getSession().changePin(oldPin, newPin);
            }
            this.pinStep.setPinChangeSuccessful();
            this.pinStep.updateState();
            return new StepActionResult(StepActionResultStatus.REPEAT);
        }
        catch (PinIncorrectException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PIN incorrect.", ex);
            } else {
                LOG.info("PIN incorrect.");
            }
            this.pinStep.setLastTryFailed();
            try {
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex1) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
        catch (PinsDoNotMatchException ex) {
            LOG.debug("Mismatching PINs entered.", ex);
            try {
                this.pinStep.setPinsDoNotMatch();
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex2) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
        catch (PinBlockedException ex) {
            try {
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex2) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
        catch (AuthenticationException ex) {
            LOG.error("Authentication error while entering the PIN.", ex);
            try {
                this.pinStep.setUnkownError();
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex2) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
        catch (CryptokiException ex) {
            LOG.error("Unknown error while entering the PIN.", ex);
            try {
                this.pinStep.setUnkownError();
                this.pinStep.updateState();
                return new StepActionResult(StepActionResultStatus.REPEAT);
            }
            catch (CryptokiException ex2) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
        }
    }

    private char[] getOldPin() {
        for (InputInfoUnit info : this.pinStep.getInputInfoUnits()) {
            if (!"OLD_PIN_FIELD".equals(info.getID())) continue;
            return ((PasswordField)info).getValue();
        }
        return null;
    }

    private char[] getNewPin() throws PinsDoNotMatchException {
        char[] pin1 = null;
        char[] pin2 = null;
        for (InputInfoUnit info : this.pinStep.getInputInfoUnits()) {
            if ("NEW_PIN_FIELD1".equals(info.getID())) {
                pin1 = ((PasswordField)info).getValue();
                continue;
            }
            if (!"NEW_PIN_FIELD2".equals(info.getID())) continue;
            pin2 = ((PasswordField)info).getValue();
        }
        if (pin1 != null && Arrays.equals(pin1, pin2)) {
            return pin1;
        }
        throw new PinsDoNotMatchException("The PINs entered in the UI do not match.");
    }

    private char[] getPuk() {
        for (InputInfoUnit info : this.pinStep.getInputInfoUnits()) {
            if (!"PUK_FIELD".equals(info.getID())) continue;
            return ((PasswordField)info).getValue();
        }
        return null;
    }
}

