/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import javax.annotation.Nonnull;
import org.openecard.common.I18n;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.enums.PinState;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinChangeStep
extends Step {
    private static final Logger LOG = LoggerFactory.getLogger(PinChangeStep.class);
    private static final I18n LANG = I18n.getTranslation("pinplugin");
    public static final String STEP_ID = "sal.middleware.pin-compare.gui-change.pin-step.id";
    protected static final String PUK_FIELD = "PUK_FIELD";
    protected static final String OLD_PIN_FIELD = "OLD_PIN_FIELD";
    protected static final String NEW_PIN_FIELD1 = "NEW_PIN_FIELD1";
    protected static final String NEW_PIN_FIELD2 = "NEW_PIN_FIELD2";
    private final PasswordField oldPin;
    private final PasswordField newPin1;
    private final PasswordField newPin2;
    private final PasswordField puk;
    private final boolean protectedAuthPath;
    private final MwSession session;
    private PinState pinState;
    private boolean pinsDoNotMatch = false;
    private boolean lastTryFailed = false;
    private boolean lastTryPukFailed = false;
    private boolean capturePuk = false;
    private boolean unkownError = false;
    private boolean pinChangeSuccessful = false;

    public PinChangeStep(boolean protectedAuthPath, @Nonnull MwSession session) throws CryptokiException {
        super(STEP_ID);
        this.protectedAuthPath = protectedAuthPath;
        this.session = session;
        this.oldPin = new PasswordField(OLD_PIN_FIELD);
        this.oldPin.setDescription(LANG.translationForKey("action.changepin.userconsent.pinstep.oldpin", new Object[0]));
        this.oldPin.setMinLength(4);
        this.newPin1 = new PasswordField(NEW_PIN_FIELD1);
        this.newPin1.setDescription(LANG.translationForKey("action.changepin.userconsent.pinstep.newpin", new Object[0]));
        this.newPin1.setMinLength(4);
        this.newPin2 = new PasswordField(NEW_PIN_FIELD2);
        this.newPin2.setDescription(LANG.translationForKey("action.changepin.userconsent.pinstep.newpinrepeat", new Object[0]));
        this.newPin2.setMinLength(4);
        this.puk = new PasswordField(PUK_FIELD);
        this.puk.setDescription(LANG.translationForKey("action.unblockpin.userconsent.pukstep.puk", new Object[0]));
        this.puk.setMinLength(4);
        this.updateState();
    }

    protected MwSession getSession() {
        return this.session;
    }

    boolean isProtectedAuthPath() {
        return this.protectedAuthPath;
    }

    boolean isCapturePuk() {
        return this.capturePuk;
    }

    public void setPinsDoNotMatch() {
        this.pinsDoNotMatch = true;
    }

    protected void setLastTryFailed() {
        this.lastTryFailed = true;
    }

    protected void setLastTryPukFailed() {
        this.lastTryPukFailed = true;
    }

    void setUnkownError() {
        this.unkownError = true;
    }

    public void setPinChangeSuccessful() {
        this.pinChangeSuccessful = true;
    }

    private void generateGui() {
        if (this.unkownError) {
            this.setTitle(LANG.translationForKey("action.error.title", new Object[0]));
            this.setAction(null);
            this.createErrorGui();
            return;
        }
        if (this.pinChangeSuccessful) {
            this.setTitle(LANG.translationForKey("action.changepin.userconsent.successstep.title", new Object[0]));
            this.setAction(null);
            this.createSuccessGui();
            return;
        }
        switch (this.pinState) {
            case PIN_OK: 
            case PIN_COUNT_LOW: 
            case PIN_FINAL_TRY: 
            case PIN_NEEDS_CHANGE: {
                this.setTitle(LANG.translationForKey("action.changepin.userconsent.pinstep.title", new Object[0]));
                if (this.protectedAuthPath) {
                    this.createPinChangeNativeGui();
                    break;
                }
                this.createPinChangeGui();
                break;
            }
            case PIN_LOCKED: {
                this.setTitle(LANG.translationForKey("action.unblockpin.userconsent.pukstep.title", new Object[0]));
                this.capturePuk = true;
                if (this.protectedAuthPath) {
                    this.createPukChangeNativeGui();
                    break;
                }
                this.createPukChangeGui();
                break;
            }
            case PIN_NOT_INITIALIZED: {
                this.setTitle(LANG.translationForKey("action.error.title", new Object[0]));
                this.setAction(null);
                this.createErrorGui();
                break;
            }
            default: {
                String msg = "Invalid pin state found.";
                LOG.error(msg);
                throw new IllegalStateException(msg);
            }
        }
    }

    protected final void updateState() throws CryptokiException {
        this.capturePuk = false;
        PinState oldState = this.pinState;
        this.pinState = PinState.getUserPinState(this.session.getSlot().getTokenInfo());
        LOG.debug("PinState detection: {} -> {}", (Object)oldState, (Object)this.pinState);
        this.getInputInfoUnits().clear();
        if (this.pinsDoNotMatch) {
            this.newPin1.setValue(null);
            this.newPin2.setValue(null);
        } else {
            this.oldPin.setValue(null);
            this.newPin1.setValue(null);
            this.newPin2.setValue(null);
            this.puk.setValue(null);
        }
        this.generateGui();
        this.pinsDoNotMatch = false;
        this.lastTryFailed = false;
        this.lastTryPukFailed = false;
    }

    private void createPinChangeGui() {
        this.setInstantReturn(false);
        if (this.lastTryFailed) {
            this.addVerifyFailed("PIN");
        } else {
            String desc = LANG.translationForKey("action.changepin.userconsent.pinstep.description", "PIN");
            Text descText = new Text(desc);
            this.getInputInfoUnits().add(descText);
        }
        this.getInputInfoUnits().add(this.oldPin);
        this.getInputInfoUnits().add(this.newPin1);
        this.getInputInfoUnits().add(this.newPin2);
        if (this.pinsDoNotMatch) {
            this.addPinsDoNotMatch();
        }
        if (this.pinState == PinState.PIN_COUNT_LOW) {
            String pinLowStr = LANG.translationForKey("action.changepin.userconsent.pinstep.remaining_attempts", 2);
            Text pinLowText = new Text(pinLowStr);
            this.getInputInfoUnits().add(pinLowText);
        } else if (this.pinState == PinState.PIN_FINAL_TRY) {
            String noteStr = LANG.translationForKey("action.pinentry.userconsent.pinstep.final_try_note", new Object[0]);
            Text noteText = new Text(noteStr);
            this.getInputInfoUnits().add(noteText);
        }
    }

    private void createPinChangeNativeGui() {
        this.setInstantReturn(true);
        if (this.lastTryFailed) {
            this.addVerifyFailed("PIN");
        } else {
            String desc = LANG.translationForKey("action.changepin.userconsent.pinstep.description", "PIN");
            Text descText = new Text(desc);
            this.getInputInfoUnits().add(descText);
        }
        if (this.pinState == PinState.PIN_COUNT_LOW) {
            String pinLowStr = LANG.translationForKey("action.changepin.userconsent.pinstep.remaining_attempts", 2);
            Text pinLowText = new Text(pinLowStr);
            this.getInputInfoUnits().add(pinLowText);
        } else if (this.pinState == PinState.PIN_FINAL_TRY) {
            String noteStr = LANG.translationForKey("action.pinentry.userconsent.pinstep.final_try_note", new Object[0]);
            Text noteText = new Text(noteStr);
            this.getInputInfoUnits().add(noteText);
        }
    }

    private void createPukChangeGui() {
        this.setInstantReturn(false);
        if (this.lastTryFailed) {
            this.addVerifyFailed("PIN");
        } else if (this.lastTryPukFailed) {
            this.addVerifyFailed("PUK");
        } else {
            String desc = LANG.translationForKey("action.unblockpin.userconsent.pukstep.description", new Object[0]);
            Text descText = new Text(desc);
            this.getInputInfoUnits().add(descText);
        }
        this.getInputInfoUnits().add(this.puk);
        this.getInputInfoUnits().add(this.newPin1);
        this.getInputInfoUnits().add(this.newPin2);
        if (this.pinsDoNotMatch) {
            this.addPinsDoNotMatch();
        }
    }

    private void createPukChangeNativeGui() {
        this.setInstantReturn(true);
        if (this.lastTryFailed) {
            this.addVerifyFailed("PIN");
        } else if (this.lastTryPukFailed) {
            this.addVerifyFailed("PUK");
        } else {
            String desc = LANG.translationForKey("action.unblockpin.userconsent.pukstep.native_description", new Object[0]);
            Text descText = new Text(desc);
            this.getInputInfoUnits().add(descText);
        }
    }

    private void createErrorGui() {
        this.setInstantReturn(false);
        this.setReversible(false);
        if (this.lastTryFailed) {
            this.addVerifyFailed("PIN");
        }
        String errorStr = LANG.translationForKey("action.error.internal", new Object[0]);
        Text errorText = new Text(errorStr);
        this.getInputInfoUnits().add(errorText);
    }

    private void createSuccessGui() {
        this.setInstantReturn(false);
        this.setReversible(false);
        String successStr = LANG.translationForKey("action.changepin.userconsent.successstep.description", new Object[0]);
        Text successText = new Text(successStr);
        this.getInputInfoUnits().add(successText);
    }

    private void addVerifyFailed(String secretName) {
        Text incorrectInput = new Text();
        incorrectInput.setText(LANG.translationForKey("action.changepin.userconsent.pinstep.incorrect_input", secretName));
        this.getInputInfoUnits().add(incorrectInput);
    }

    private void addPinsDoNotMatch() {
        Text incorrectInput = new Text();
        incorrectInput.setText(LANG.translationForKey("action.error.missing_password_match", new Object[0]));
        this.getInputInfoUnits().add(incorrectInput);
    }
}

