/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;

public class NativeLongArray {
    private final int numElements;
    private final Memory mem;

    public NativeLongArray(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative value supplied to array allocation.");
        }
        this.numElements = size;
        this.mem = new Memory(NativeLong.SIZE * size);
    }

    public Memory getReference() {
        return this.mem;
    }

    public long getValue(int idx) {
        if (idx < 0 || idx >= this.numElements) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return this.mem.getNativeLong(idx * NativeLong.SIZE).longValue();
    }

    long[] getValues(int numValues) {
        if (numValues < 0 || numValues > this.numElements) {
            throw new ArrayIndexOutOfBoundsException(numValues);
        }
        long[] result = new long[numValues];
        for (int i = 0; i < numValues; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }
}

