/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import java.nio.charset.StandardCharsets;
import org.openecard.mdlw.sal.cryptoki.CK_TOKEN_INFO;
import org.openecard.mdlw.sal.cryptoki.CK_VERSION;
import org.openecard.mdlw.sal.enums.Flag;

public class MwToken {
    private final CK_TOKEN_INFO orig;

    public MwToken(CK_TOKEN_INFO pInfo) {
        this.orig = pInfo;
    }

    public String getUtcTime() {
        return new String(this.orig.getUtcTime(), StandardCharsets.UTF_8).trim();
    }

    public long getUlTotalPublicMemory() {
        return this.orig.getUlTotalPublicMemory().longValue();
    }

    public long getUlTotalPrivateMemory() {
        return this.orig.getUlTotalPrivateMemory().longValue();
    }

    public long getUlSessionCount() {
        return this.orig.getUlSessionCount().longValue();
    }

    public long getUlRwSessionCount() {
        return this.orig.getUlRwSessionCount().longValue();
    }

    public long getUlMinPinLen() {
        return this.orig.getUlMinPinLen().longValue();
    }

    public long getUlMaxSessionCount() {
        return this.orig.getUlMaxSessionCount().longValue();
    }

    public long getUlMaxRwSessionCount() {
        return this.orig.getUlMaxRwSessionCount().longValue();
    }

    public long getUlMaxPinLen() {
        return this.orig.getUlMaxPinLen().longValue();
    }

    public long getUlFreePublicMemory() {
        return this.orig.getUlFreePublicMemory().longValue();
    }

    public String getSerialNumber() {
        return new String(this.orig.getSerialNumber(), StandardCharsets.UTF_8).trim();
    }

    public long getUlFreePrivateMemory() {
        return this.orig.getUlFreePrivateMemory().longValue();
    }

    public CK_VERSION getFirmwareVerion() {
        return this.orig.getFirmwareVersion();
    }

    public boolean getAutoRead() {
        return this.orig.getAutoRead();
    }

    public boolean getAutoWrite() {
        return this.orig.getAutoWrite();
    }

    public CK_VERSION getHardwareVersion() {
        return this.orig.getHardwareVersion();
    }

    public boolean containsFlag(Flag flag) {
        return (this.orig.getFlags().longValue() & flag.getValue()) > 0L;
    }

    public String getLabel() {
        return new String(this.orig.getLabel(), StandardCharsets.UTF_8).trim();
    }

    public String getManufacturerID() {
        return new String(this.orig.getManufacturerID(), StandardCharsets.UTF_8).trim();
    }

    public String getModel() {
        return new String(this.orig.getModel(), StandardCharsets.UTF_8).trim();
    }
}

