/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import javax.annotation.Nullable;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.mdlw.sal.AttributeUtils;
import org.openecard.mdlw.sal.MiddleWareWrapper;
import org.openecard.mdlw.sal.MwAbstractKey;
import org.openecard.mdlw.sal.MwSession;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.struct.CkAttribute;

public class MwPublicKey
extends MwAbstractKey {
    private final Boolean encrypt = this.loadAttrValueEncrypt();
    private final Boolean verify = this.loadAttrValueVerify();
    private final Boolean verifyRecover = this.loadAttrValueVerifyRecover();
    private final Boolean wrap = this.loadAttrValueWrap();
    private final Boolean trusted = this.loadAttrValueTrusted();
    private final String keyLabel = this.loadAttrValueLabel();
    private final byte[] subject = this.loadAttrValueSubject();

    public MwPublicKey(long objectHandle, MiddleWareWrapper mw, MwSession mwSession) throws CryptokiException {
        super(objectHandle, mw, mwSession);
    }

    private Boolean loadAttrValueEncrypt() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 260L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueVerify() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 266L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueVerifyRecover() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 267L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueWrap() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 262L);
        return AttributeUtils.getBool(raw);
    }

    private Boolean loadAttrValueTrusted() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(134);
        return raw != null ? AttributeUtils.getBool(raw) : false;
    }

    private String loadAttrValueLabel() throws CryptokiException {
        CkAttribute raw = this.mw.getAttributeValue(this.session.getSessionId(), this.objectHandle, 3L);
        return AttributeUtils.getString(raw);
    }

    private byte[] loadAttrValueSubject() throws CryptokiException {
        CkAttribute raw = this.getAttributeChecked(257);
        return raw != null ? AttributeUtils.getBytes(raw) : null;
    }

    public long getObjectHandle() {
        return this.objectHandle;
    }

    public MiddleWareWrapper getmw() {
        return this.mw;
    }

    public MwSession getSession() {
        return this.session;
    }

    public Boolean getEncrypt() {
        return this.encrypt;
    }

    public Boolean getVerify() {
        return this.verify;
    }

    public Boolean getVerify_Recover() {
        return this.verifyRecover;
    }

    public Boolean getWrap() {
        return this.wrap;
    }

    public Boolean getTrusted() {
        return this.trusted;
    }

    public String getKeyLabel() {
        return this.keyLabel;
    }

    @Nullable
    public byte[] getSubject() {
        return Arrays.clone(this.subject);
    }

    public String toString() {
        return "PKCS#11 Public Key: {label=" + this.getKeyLabel() + ", type=" + this.getKeyTypeName() + "}";
    }
}

