/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.openecard.mdlw.sal.cryptoki.CryptokiLibrary;

public class MutexStore {
    private final HashMap<Long, ReentrantLock> entries = new HashMap();
    private long mutexNums = 1L;

    public CryptokiLibrary.CK_CREATEMUTEX getCreateMutexFun() {
        return new CryptokiLibrary.CK_CREATEMUTEX(){

            @Override
            public synchronized NativeLong apply(PointerByReference ppMutex) {
                long mutexIdx = MutexStore.this.mutexNums++;
                Pointer mutexRef = Pointer.createConstant(mutexIdx);
                ReentrantLock mutex = new ReentrantLock();
                MutexStore.this.entries.put(mutexIdx, mutex);
                ppMutex.setValue(mutexRef);
                return new NativeLong(0L);
            }
        };
    }

    public CryptokiLibrary.CK_DESTROYMUTEX getDestroyMutexFun() {
        return new CryptokiLibrary.CK_DESTROYMUTEX(){

            @Override
            public synchronized NativeLong apply(Pointer pMutex) {
                long mutexIdx = Pointer.nativeValue(pMutex);
                ReentrantLock mutex = (ReentrantLock)MutexStore.this.entries.remove(mutexIdx);
                if (mutex != null) {
                    return new NativeLong(0L);
                }
                return new NativeLong(416L);
            }
        };
    }

    public CryptokiLibrary.CK_LOCKMUTEX getLockMutexFun() {
        return new CryptokiLibrary.CK_LOCKMUTEX(){

            @Override
            public NativeLong apply(Pointer pMutex) {
                long mutexIdx = Pointer.nativeValue(pMutex);
                ReentrantLock mutex = (ReentrantLock)MutexStore.this.entries.get(mutexIdx);
                if (mutex != null) {
                    mutex.lock();
                    return new NativeLong(0L);
                }
                return new NativeLong(416L);
            }
        };
    }

    public CryptokiLibrary.CK_UNLOCKMUTEX getUnlockMutexFun() {
        return new CryptokiLibrary.CK_UNLOCKMUTEX(){

            @Override
            public NativeLong apply(Pointer pMutex) {
                long mutexIdx = Pointer.nativeValue(pMutex);
                ReentrantLock mutex = (ReentrantLock)MutexStore.this.entries.get(mutexIdx);
                if (mutex != null) {
                    try {
                        mutex.unlock();
                        return new NativeLong(0L);
                    }
                    catch (IllegalMonitorStateException ex) {
                        return new NativeLong(5L);
                    }
                }
                return new NativeLong(416L);
            }
        };
    }
}

