/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.sal;

import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.openecard.mdlw.sal.struct.CkAttribute;

public class AttributeUtils {
    @Nullable
    public static byte[] getBytes(CkAttribute raw) {
        int dataLen = raw.getLength().intValue();
        if (dataLen > 0) {
            return raw.getData().getByteArray(0L, dataLen);
        }
        return new byte[0];
    }

    @Nullable
    public static String getString(CkAttribute raw) {
        int dataLen = raw.getLength().intValue();
        if (dataLen > 0) {
            byte[] rawData = raw.getData().getByteArray(0L, dataLen);
            return new String(rawData, StandardCharsets.UTF_8).trim();
        }
        return null;
    }

    @Nullable
    public static Boolean getBool(CkAttribute raw) {
        int dataLen = raw.getLength().intValue();
        if (dataLen > 0) {
            return raw.getData().getByte(0L) == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    @Nullable
    public static long getLong(CkAttribute raw) {
        int dataLen = raw.getLength().intValue();
        if (dataLen > 0) {
            if (dataLen == 4) {
                return raw.getData().getInt(0L);
            }
            return raw.getData().getLong(0L);
        }
        return -1L;
    }

    @Nullable
    public static long[] getLongs(CkAttribute raw) {
        int dataLen = raw.getLength().intValue();
        if (dataLen > 0) {
            return raw.getData().getLongArray(0L, dataLen / 8);
        }
        return new long[0];
    }
}

