/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.mdlw.event;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import org.openecard.common.event.EventObject;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.util.HandlerBuilder;
import org.openecard.mdlw.event.MwEventObject;
import org.openecard.mdlw.sal.MwModule;
import org.openecard.mdlw.sal.MwSlot;
import org.openecard.mdlw.sal.MwToken;
import org.openecard.mdlw.sal.enums.Flag;
import org.openecard.mdlw.sal.enums.TokenState;
import org.openecard.mdlw.sal.exceptions.CryptokiException;
import org.openecard.mdlw.sal.exceptions.SessionException;
import org.openecard.mdlw.sal.exceptions.TokenException;
import org.openecard.mdlw.sal.struct.CkSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MwEventRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MwEventRunner.class);
    private final Environment env;
    private final HandlerBuilder builder;
    private final DatatypeFactory dataFactory;
    private final MwModule mwModule;
    private final Map<Long, SlotInfo> slots;
    private boolean supportsBlockingWait = true;
    private boolean supportsNonBlockingWait = true;

    MwEventRunner(Environment env, HandlerBuilder builder, DatatypeFactory dataFactory, MwModule mwModule) {
        this.env = env;
        this.dataFactory = dataFactory;
        this.builder = builder;
        this.mwModule = mwModule;
        this.slots = new HashMap<Long, SlotInfo>();
    }

    void initRunner() throws CryptokiException {
        for (MwSlot slot : this.mwModule.getSlotList(TokenState.NotPresent)) {
            this.sendTerminalAdded(slot);
            String ifdName = slot.getSlotInfo().getSlotDescription();
            try {
                slot.getTokenInfo().getLabel();
                this.sendCardInserted(slot);
                this.sendCardRecognized(slot);
            }
            catch (SessionException | TokenException e) {
                LOG.debug("Error getting token information, no card present in the requested slot.", e);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        MwEventRunner.LOG.debug("Start event loop.");
        while (true) lbl-1000:
        // 3 sources

        {
            try {
                while (true) {
                    MwEventRunner.LOG.debug("Waiting for Middleware event.");
                    if (this.supportsBlockingWait) {
                        slotId = this.mwModule.waitForSlotEvent(0);
                    } else if (this.supportsNonBlockingWait) {
                        slotId = this.mwModule.waitForSlotEvent(1);
                        if (slotId == -1L) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex) {
                                MwEventRunner.LOG.debug("Middleware Event Runner interrupted.");
                                return;
                            }
                        }
                    } else {
                        throw new IllegalStateException("This point should never be reached");
                    }
                    MwEventRunner.LOG.debug("Middleware event detected.");
                    isProcessed = false;
                    for (MwSlot slot : this.mwModule.getSlotList(false)) {
                        if (slot.getSlotInfo().getSlotID() != slotId) continue;
                        isProcessed = true;
                        ifdName = slot.getSlotInfo().getSlotDescription();
                        MwEventRunner.LOG.debug("Slot event recognized, slotId={}, ifdName={}.", (Object)slotId, (Object)ifdName);
                        try {
                            slot.getTokenInfo().getLabel();
                            this.sendCardInserted(slot);
                            this.sendCardRecognized(slot);
                        }
                        catch (SessionException | TokenException ex) {
                            MwEventRunner.LOG.debug("Error requesting token information.", ex);
                            this.sendCardRemoved(slot);
                        }
                    }
                    if (isProcessed) continue;
                    this.sendTerminalRemoved(slotId);
                }
            }
            catch (CryptokiException ex) {
                if (ex.getErrorCode() == 84L) {
                    if (this.supportsBlockingWait) {
                        MwEventRunner.LOG.info("Blocking wait is not supported. Falling back to non-blocking wait.");
                        this.supportsBlockingWait = false;
                        continue;
                    }
                    if (this.supportsNonBlockingWait) {
                        MwEventRunner.LOG.info("Non-blocking wait is not supported. Terminating event thread.");
                        this.supportsNonBlockingWait = false;
                        return;
                    }
                }
                MwEventRunner.LOG.error("Unrecoverable error during operation on the token list.", ex);
                try {
                    Thread.sleep(10000L);
                    continue;
                }
                catch (InterruptedException ex1) {
                    MwEventRunner.LOG.debug("Middleware Event Runner interrupted.");
                    return;
                }
            }
            ** while (true)
            catch (RuntimeException ex) {
                MwEventRunner.LOG.error("Unexpected exception occurred in Middleware Event Runner.", ex);
                throw ex;
            }
            break;
        }
    }

    private void sendTerminalAdded(MwSlot slot) {
        if (this.slots.get(slot.getSlotInfo().getSlotID()) != null) {
            return;
        }
        SlotInfo sl = new SlotInfo();
        sl.ifdName = slot.getSlotInfo().getSlotDescription();
        sl.slotId = slot.getSlotInfo().getSlotID();
        this.slots.put(slot.getSlotInfo().getSlotID(), sl);
        String ifdName = slot.getSlotInfo().getSlotDescription();
        LOG.debug("Sending TERMINAL_ADDED event, ifdName={}.", (Object)ifdName);
        ConnectionHandleType insertHandle = this.makeConnectionHandle(ifdName);
        MwEventObject addedEvent = new MwEventObject(insertHandle, slot);
        this.notify(EventType.TERMINAL_ADDED, addedEvent);
    }

    private void sendTerminalRemoved(long slotId) {
        if (this.slots.get(slotId) == null) {
            return;
        }
        this.sendCardRemoved(this.slots.get(slotId));
        String ifdName = this.slots.get((Object)Long.valueOf((long)slotId)).ifdName;
        LOG.debug("Sending TERMINAL_REMOVED event, ifdName={}.", (Object)ifdName);
        ConnectionHandleType insertHandle = this.makeConnectionHandle(ifdName);
        MwEventObject addedEvent = new MwEventObject(insertHandle, null);
        this.notify(EventType.TERMINAL_REMOVED, addedEvent);
        this.slots.remove(slotId);
    }

    private void sendCardInserted(MwSlot slot) {
        this.sendTerminalAdded(slot);
        if (this.slots.get((Object)Long.valueOf((long)slot.getSlotInfo().getSlotID())).isCardPresent) {
            return;
        }
        String ifdName = slot.getSlotInfo().getSlotDescription();
        ConnectionHandleType insertHandle = this.makeUnknownCardHandle(ifdName);
        MwEventObject insertEvent = new MwEventObject(insertHandle, slot);
        this.notify(EventType.CARD_INSERTED, insertEvent);
        this.slots.get((Object)Long.valueOf((long)slot.getSlotInfo().getSlotID())).isCardPresent = true;
    }

    private void sendCardRecognized(MwSlot slot) throws CryptokiException {
        if (this.slots.get((Object)Long.valueOf((long)slot.getSlotInfo().getSlotID())).isCardRecognized) {
            return;
        }
        MwToken token = slot.getTokenInfo();
        String ifdName = slot.getSlotInfo().getSlotDescription();
        String cardType = String.format("%s_%s", token.getManufacturerID(), token.getModel());
        cardType = this.mwModule.getMiddlewareSALConfig().mapMiddlewareType(cardType);
        if (cardType != null) {
            boolean protectedAuthPath = token.containsFlag(Flag.CKF_PROTECTED_AUTHENTICATION_PATH);
            ConnectionHandleType recHandle = this.makeKnownCardHandle(ifdName, cardType, protectedAuthPath);
            MwEventObject recEvent = new MwEventObject(recHandle, slot);
            this.notify(EventType.CARD_RECOGNIZED, recEvent);
            this.slots.get((Object)Long.valueOf((long)slot.getSlotInfo().getSlotID())).isCardRecognized = true;
        }
    }

    private void sendCardRemoved(MwSlot slot) {
        CkSlot ckSlot = slot.getSlotInfo();
        SlotInfo slotInfo = this.slots.get(ckSlot.getSlotID());
        if (slotInfo == null || !slotInfo.isCardPresent) {
            return;
        }
        String ifdName = slot.getSlotInfo().getSlotDescription();
        ConnectionHandleType handle = this.makeConnectionHandle(ifdName);
        MwEventObject remEvent = new MwEventObject(handle, slot);
        this.notify(EventType.CARD_REMOVED, remEvent);
        this.slots.get((Object)Long.valueOf((long)slot.getSlotInfo().getSlotID())).isCardPresent = false;
        this.slots.get((Object)Long.valueOf((long)slot.getSlotInfo().getSlotID())).isCardRecognized = false;
    }

    private void sendCardRemoved(SlotInfo sl) {
        if (!this.slots.get((Object)Long.valueOf((long)sl.slotId)).isCardPresent) {
            return;
        }
        String ifdName = sl.ifdName;
        ConnectionHandleType handle = this.makeConnectionHandle(ifdName);
        MwEventObject remEvent = new MwEventObject(handle, null);
        this.notify(EventType.CARD_REMOVED, remEvent);
        this.slots.get((Object)Long.valueOf((long)sl.slotId)).isCardPresent = false;
        this.slots.get((Object)Long.valueOf((long)sl.slotId)).isCardRecognized = false;
    }

    private ConnectionHandleType makeConnectionHandle(String ifdName) {
        ConnectionHandleType h = this.builder.setIfdName(ifdName).setSlotIdx(BigInteger.ZERO).buildConnectionHandle();
        return h;
    }

    private ConnectionHandleType makeUnknownCardHandle(String ifdName) {
        ConnectionHandleType h = this.builder.setIfdName(ifdName).setSlotIdx(BigInteger.ZERO).setCardType("http://bsi.bund.de/cif/unknown").buildConnectionHandle();
        return h;
    }

    private ConnectionHandleType makeKnownCardHandle(String ifdName, String cardType, boolean isProtectedAuthPath) {
        ConnectionHandleType.RecognitionInfo rInfo = new ConnectionHandleType.RecognitionInfo();
        rInfo.setCardType(cardType);
        rInfo.setCaptureTime(this.dataFactory.newXMLGregorianCalendar(new GregorianCalendar()));
        ConnectionHandleType h = this.builder.setIfdName(ifdName).setSlotIdx(BigInteger.ZERO).setRecognitionInfo(rInfo).setProtectedAuthPath(isProtectedAuthPath).buildConnectionHandle();
        return h;
    }

    private synchronized void notify(EventType eventType, EventObject eventData) {
        LOG.debug("Notify {}, {}", (Object)eventType, (Object)eventData);
        this.env.getEventDispatcher().notify(eventType, eventData);
    }

    private class SlotInfo {
        public long slotId;
        public String ifdName;
        public boolean isCardPresent = false;
        public boolean isCardRecognized = false;

        private SlotInfo() {
        }
    }
}

