/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.wrapper;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.openecard.common.ifd.scio.NoSuchTerminal;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOTerminal;
import org.openecard.common.ifd.scio.SCIOTerminals;
import org.openecard.common.ifd.scio.TerminalFactory;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.Pair;
import org.openecard.common.util.ValueGenerators;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.wrapper.ByteArrayComparator;
import org.openecard.ifd.scio.wrapper.IFDTerminalFactory;
import org.openecard.ifd.scio.wrapper.NoSuchChannel;
import org.openecard.ifd.scio.wrapper.SingleThreadChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelManager.class);
    private final SCIOTerminals terminals;
    private final HashMap<String, SingleThreadChannel> baseChannels;
    private final TreeMap<byte[], SingleThreadChannel> handledChannels;
    private final HashMap<String, Set<byte[]>> ifdNameToHandles;

    public ChannelManager() throws IFDException {
        TerminalFactory f = IFDTerminalFactory.getInstance();
        this.terminals = f.terminals();
        this.baseChannels = new HashMap();
        this.handledChannels = new TreeMap(new ByteArrayComparator());
        this.ifdNameToHandles = new HashMap();
    }

    public static byte[] createHandle(int size) {
        return ValueGenerators.generateRandom(size * 2);
    }

    public static byte[] createSlotHandle() {
        return ChannelManager.createHandle(24);
    }

    public static byte[] createCtxHandle() {
        return ChannelManager.createHandle(16);
    }

    public SCIOTerminals getTerminals() {
        return this.terminals;
    }

    public synchronized SingleThreadChannel openMasterChannel(@Nonnull String ifdName) throws NoSuchTerminal, SCIOException {
        if (this.baseChannels.containsKey(ifdName)) {
            LOG.warn("Terminal '" + ifdName + "' is already connected.");
            return this.baseChannels.get(ifdName);
        }
        SCIOTerminal t = this.getTerminals().getTerminal(ifdName);
        SingleThreadChannel ch = new SingleThreadChannel(t, true);
        this.baseChannels.put(ifdName, ch);
        this.ifdNameToHandles.put(ifdName, new TreeSet<byte[]>(new ByteArrayComparator()));
        return ch;
    }

    public synchronized Pair<byte[], SingleThreadChannel> openSlaveChannel(@Nonnull String ifdName) throws NoSuchTerminal, SCIOException {
        SingleThreadChannel baseCh = this.getMasterChannel(ifdName);
        SCIOTerminal term = baseCh.getChannel().getCard().getTerminal();
        SingleThreadChannel slaveCh = new SingleThreadChannel(term, true);
        byte[] slotHandle = ChannelManager.createSlotHandle();
        this.handledChannels.put(slotHandle, slaveCh);
        this.ifdNameToHandles.get(ifdName).add(slotHandle);
        return new Pair<byte[], SingleThreadChannel>(slotHandle, slaveCh);
    }

    public synchronized SingleThreadChannel getMasterChannel(@Nonnull String ifdName) throws NoSuchTerminal {
        SingleThreadChannel ch = this.baseChannels.get(ifdName);
        if (ch == null) {
            throw new NoSuchTerminal("No terminal with name '" + ifdName + "' available.");
        }
        return ch;
    }

    public synchronized SingleThreadChannel getSlaveChannel(@Nonnull byte[] slotHandle) throws NoSuchChannel {
        SingleThreadChannel ch = this.handledChannels.get(slotHandle);
        if (ch == null) {
            throw new NoSuchChannel("No channel for slot '" + ByteUtils.toHexString(slotHandle) + "' available.");
        }
        return ch;
    }

    public synchronized void closeMasterChannel(String ifdName) {
        SingleThreadChannel ch;
        Set<byte[]> slotHandles = this.ifdNameToHandles.get(ifdName);
        if (slotHandles != null) {
            for (byte[] slotHandle : slotHandles) {
                try {
                    this.closeSlaveChannel(slotHandle);
                }
                catch (SCIOException | NoSuchChannel ex) {
                    LOG.warn("Failed to close channel for terminal '" + ifdName + "'.", ex);
                }
            }
            this.ifdNameToHandles.remove(ifdName);
        }
        if ((ch = this.baseChannels.remove(ifdName)) == null) {
            LOG.error("No master channel for terminal '" + ifdName + "' available.");
        } else {
            try {
                ch.shutdown();
            }
            catch (SCIOException ex) {
                LOG.warn("Failed to shut down master channel for terminal '" + ifdName + "'.");
            }
        }
    }

    public synchronized void closeSlaveChannel(@Nonnull byte[] slotHandle) throws NoSuchChannel, SCIOException {
        SingleThreadChannel ch = this.handledChannels.remove(slotHandle);
        if (ch == null) {
            throw new NoSuchChannel("No channel for slot '" + ByteUtils.toHexString(slotHandle) + "' available.");
        }
        String ifdName = ch.getChannel().getCard().getTerminal().getName();
        this.ifdNameToHandles.get(ifdName).remove(slotHandle);
        ch.shutdown();
    }
}

