/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio.reader;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.openecard.common.util.ByteUtils;

public class PCSCFeatures {
    public static final int VERIFY_PIN_START = 1;
    public static final int VERIFY_PIN_FINISH = 2;
    public static final int MODIFY_PIN_START = 3;
    public static final int MODIFY_PIN_FINISH = 4;
    public static final int GET_KEY_PRESSED = 5;
    public static final int VERIFY_PIN_DIRECT = 6;
    public static final int MODIFY_PIN_DIRECT = 7;
    public static final int MCT_READER_DIRECT = 8;
    public static final int MCT_UNIVERSAL = 9;
    public static final int IFD_PIN_PROPERTIES = 10;
    public static final int ABORT = 11;
    public static final int SET_SPE_MESSAGE = 12;
    public static final int VERIFY_PIN_DIRECT_APP_ID = 13;
    public static final int MODIFY_PIN_DIRECT_APP_ID = 14;
    public static final int WRITE_DISPLAY = 15;
    public static final int GET_KEY = 16;
    public static final int IFD_DISPLAY_PROPERTIES = 17;
    public static final int GET_TLV_PROPERTIES = 18;
    public static final int CCID_ESC_COMMAND = 19;
    public static final int EXECUTE_PACE = 32;

    public static int GET_FEATURE_REQUEST_CTLCODE() {
        return PCSCFeatures.SCARD_CTL_CODE(3400);
    }

    private static int SCARD_CTL_CODE(int code) {
        if (PCSCFeatures.isWindows()) {
            return 0x310000 | code << 2;
        }
        return 0x42000000 + code;
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("windows");
    }

    public static Map<Integer, Integer> featureMapFromRequest(byte[] featureResponse) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        if (featureResponse.length % 6 == 0) {
            for (int i = 0; i < featureResponse.length; i += 6) {
                byte[] nextChunk = Arrays.copyOfRange(featureResponse, i, i + 6);
                if (nextChunk.length != 6 || nextChunk[1] != 4) continue;
                byte tag = nextChunk[0];
                byte[] codeData = Arrays.copyOfRange(nextChunk, 2, 6);
                int code = ByteUtils.toInteger(codeData);
                result.put(new Integer(tag), code);
            }
        }
        return result;
    }
}

