/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.PinInputType;
import java.util.Map;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.gui.StepResult;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.reader.PCSCPinVerify;
import org.openecard.ifd.scio.wrapper.SingleThreadChannel;
import org.openecard.ifd.scio.wrapper.TerminalInfo;

public class NativePinStepAction
extends StepAction {
    public IFDException exception = null;
    public byte[] response = null;
    private final PinInputType pinInput;
    private final SingleThreadChannel ch;
    private final TerminalInfo termInfo;
    private final byte[] template;

    public NativePinStepAction(String stepName, PinInputType pinInput, SingleThreadChannel ch, TerminalInfo termInfo, byte[] template) {
        super(stepName);
        this.pinInput = pinInput;
        this.ch = ch;
        this.termInfo = termInfo;
        this.template = template;
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        try {
            this.response = this.nativePinVerify();
        }
        catch (SCIOException ex) {
            this.exception = new IFDException(ex);
        }
        catch (IFDException ex) {
            this.exception = ex;
        }
        return new StepActionResult(StepActionResultStatus.NEXT);
    }

    private byte[] nativePinVerify() throws IFDException, SCIOException {
        PCSCPinVerify verifyStruct = new PCSCPinVerify(this.pinInput.getPasswordAttributes(), this.template);
        byte[] verifyStructData = verifyStruct.toBytes();
        Map<Integer, Integer> features = this.termInfo.getFeatureCodes();
        byte[] result = this.ch.transmitControlCommand(features.get(6), verifyStructData);
        return result;
    }
}

