/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.ifd.scio.NoSuchTerminal;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.TerminalState;
import org.openecard.common.ifd.scio.TerminalWatcher;
import org.openecard.ifd.scio.wrapper.ChannelManager;
import org.openecard.ifd.scio.wrapper.SingleThreadChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventWatcher
implements Callable<List<IFDStatusType>> {
    private static final Logger LOG = LoggerFactory.getLogger(EventWatcher.class);
    private final ChannelManager cm;
    private final long timeout;
    private final ChannelHandleType callback;
    private final TerminalWatcher watcher;
    private ArrayList<IFDStatusType> currentState;
    private List<IFDStatusType> expectedState;

    public EventWatcher(@Nonnull ChannelManager cm, long timeout, @Nullable ChannelHandleType callback) throws SCIOException {
        this.cm = cm;
        this.timeout = timeout;
        this.callback = callback;
        this.watcher = cm.getTerminals().getWatcher();
    }

    @Nonnull
    public List<IFDStatusType> start() throws SCIOException {
        List<TerminalState> initialState = this.watcher.start();
        this.currentState = this.convert(initialState);
        return this.convert(initialState);
    }

    public void setExpectedState(@Nonnull List<IFDStatusType> expectedState) {
        this.expectedState = expectedState;
    }

    public boolean isAsync() {
        return this.callback != null;
    }

    @Override
    public List<IFDStatusType> call() throws SCIOException {
        List<IFDStatusType> diff = this.compare(this.expectedState);
        if (!diff.isEmpty()) {
            return diff;
        }
        ArrayList<TerminalWatcher.StateChangeEvent> events = new ArrayList<TerminalWatcher.StateChangeEvent>();
        TerminalWatcher.StateChangeEvent event = this.watcher.waitForChange(this.timeout);
        if (!event.isCancelled()) {
            do {
                events.add(event);
            } while (!(event = this.watcher.waitForChange(1L)).isCancelled());
        }
        for (TerminalWatcher.StateChangeEvent next : events) {
            this.updateState(next);
        }
        diff = this.compare(this.expectedState);
        return diff;
    }

    private void updateState(TerminalWatcher.StateChangeEvent event) {
        String name = event.getTerminal();
        if (event.getState() == TerminalWatcher.EventType.TERMINAL_ADDED) {
            this.currentState.add(EventWatcher.createEmptyState(name));
        } else {
            for (IFDStatusType next : this.currentState) {
                SlotStatusType slot = next.getSlotStatus().get(0);
                if (!next.getIFDName().equals(name)) continue;
                switch (event.getState()) {
                    case CARD_INSERTED: {
                        try {
                            SingleThreadChannel ch = new SingleThreadChannel(this.watcher.getTerminals().getTerminal(name), true);
                            slot.setCardAvailable(true);
                            slot.setATRorATS(ch.getChannel().getCard().getATR().getBytes());
                            ch.shutdown();
                        }
                        catch (NoSuchTerminal | SCIOException ex) {
                            LOG.error("Failed to open master channel for terminal '" + name + "'.", ex);
                            slot.setCardAvailable(false);
                        }
                        break;
                    }
                    case CARD_REMOVED: {
                        this.cm.closeMasterChannel(name);
                        slot.setCardAvailable(false);
                        break;
                    }
                    case TERMINAL_REMOVED: {
                        slot.setCardAvailable(false);
                        next.setConnected(false);
                    }
                }
                break;
            }
        }
    }

    @Nonnull
    public List<IFDStatusType> compare(@Nonnull List<IFDStatusType> expectedStatus) {
        ArrayList<IFDStatusType> remaining = new ArrayList<IFDStatusType>(this.currentState);
        for (IFDStatusType nextExpect : expectedStatus) {
            Iterator<IFDStatusType> it = remaining.iterator();
            boolean matchFound = false;
            while (it.hasNext()) {
                IFDStatusType nextRemain = it.next();
                if (!nextRemain.getIFDName().equals(nextExpect.getIFDName())) continue;
                matchFound = true;
                if (!EventWatcher.isStateEqual(nextRemain, nextExpect)) break;
                it.remove();
                break;
            }
            if (matchFound) continue;
            IFDStatusType removed = EventWatcher.clone(nextExpect);
            removed.setIFDName(nextExpect.getIFDName());
            removed.setConnected(false);
            remaining.add(removed);
        }
        return EventWatcher.clone(remaining);
    }

    @Nonnull
    private ArrayList<IFDStatusType> convert(@Nonnull List<TerminalState> terminals) {
        ArrayList<IFDStatusType> result = new ArrayList<IFDStatusType>(terminals.size());
        for (TerminalState next : terminals) {
            result.add(this.convert(next));
        }
        return result;
    }

    @Nonnull
    private IFDStatusType convert(@Nonnull TerminalState next) {
        IFDStatusType result = new IFDStatusType();
        result.setIFDName(next.getName());
        result.setConnected(true);
        SlotStatusType slot = new SlotStatusType();
        result.getSlotStatus().add(slot);
        slot.setIndex(BigInteger.ZERO);
        slot.setCardAvailable(next.isCardPresent());
        return result;
    }

    @Nonnull
    private static List<IFDStatusType> clone(@Nonnull List<IFDStatusType> orig) {
        ArrayList<IFDStatusType> result = new ArrayList<IFDStatusType>(orig.size());
        for (IFDStatusType next : orig) {
            result.add(EventWatcher.clone(next));
        }
        return result;
    }

    @Nonnull
    private static IFDStatusType clone(@Nonnull IFDStatusType orig) {
        IFDStatusType newStat = new IFDStatusType();
        newStat.setIFDName(orig.getIFDName());
        newStat.setConnected(orig.isConnected());
        for (SlotStatusType next : orig.getSlotStatus()) {
            newStat.getSlotStatus().add(EventWatcher.clone(next));
        }
        return newStat;
    }

    @Nonnull
    private static SlotStatusType clone(@Nonnull SlotStatusType orig) {
        SlotStatusType slot = new SlotStatusType();
        slot.setCardAvailable(orig.isCardAvailable());
        slot.setIndex(orig.getIndex());
        byte[] atr = orig.getATRorATS();
        if (atr != null) {
            slot.setATRorATS((byte[])atr.clone());
        }
        return slot;
    }

    private static IFDStatusType createEmptyState(String name) {
        IFDStatusType status = new IFDStatusType();
        status.setIFDName(name);
        status.setConnected(true);
        status.getSlotStatus().add(EventWatcher.createEmptySlot());
        return status;
    }

    private static SlotStatusType createEmptySlot() {
        SlotStatusType slot = new SlotStatusType();
        slot.setCardAvailable(false);
        slot.setIndex(BigInteger.ZERO);
        return slot;
    }

    private static boolean isStateEqual(@Nonnull IFDStatusType a, @Nonnull IFDStatusType b) {
        if (!a.getIFDName().equals(b.getIFDName())) {
            return false;
        }
        if (!a.isConnected().equals(b.isConnected())) {
            return false;
        }
        List<SlotStatusType> sa = a.getSlotStatus();
        List<SlotStatusType> sb = b.getSlotStatus();
        if (sa.size() != sb.size()) {
            return false;
        }
        for (int i = 0; i < sa.size(); ++i) {
            if (EventWatcher.isSlotEqual(sa.get(i), sb.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSlotEqual(@Nonnull SlotStatusType a, @Nonnull SlotStatusType b) {
        if (a.isCardAvailable() != b.isCardAvailable()) {
            return false;
        }
        return a.getIndex().equals(b.getIndex());
    }
}

