/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.scio;

import iso.std.iso_iec._24727.tech.schema.AltVUMessagesType;
import iso.std.iso_iec._24727.tech.schema.DisplayCapabilityType;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.IFDCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.InputUnitType;
import iso.std.iso_iec._24727.tech.schema.KeyPadCapabilityType;
import iso.std.iso_iec._24727.tech.schema.OutputInfoType;
import iso.std.iso_iec._24727.tech.schema.PasswordAttributesType;
import iso.std.iso_iec._24727.tech.schema.PinInputType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import iso.std.iso_iec._24727.tech.schema.VerifyUser;
import iso.std.iso_iec._24727.tech.schema.VerifyUserResponse;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.util.PINUtils;
import org.openecard.common.util.UtilException;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.gui.executor.StepAction;
import org.openecard.ifd.scio.IFD;
import org.openecard.ifd.scio.IFDException;
import org.openecard.ifd.scio.NativePinStepAction;
import org.openecard.ifd.scio.wrapper.ChannelManager;
import org.openecard.ifd.scio.wrapper.SingleThreadChannel;
import org.openecard.ifd.scio.wrapper.TerminalInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbstractTerminal {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTerminal.class);
    private static final I18n LANG = I18n.getTranslation("pinplugin");
    private final IFD ifd;
    private final ChannelManager cm;
    private final SingleThreadChannel channel;
    private final TerminalInfo terminalInfo;
    private final UserConsent gui;
    private final byte[] ctxHandle;
    private final BigInteger displayIdx;
    private IFDCapabilitiesType capabilities;
    private Boolean canBeep = null;
    private Boolean canBlink = null;
    private Boolean canDisplay = null;
    private Boolean canEnter = null;
    private BigInteger keyIdx = null;

    public AbstractTerminal(IFD ifd, ChannelManager cm, SingleThreadChannel channel, UserConsent gui, byte[] ctxHandle, BigInteger displayIdx) {
        this.ifd = ifd;
        this.cm = cm;
        this.channel = channel;
        this.terminalInfo = new TerminalInfo(cm, channel);
        this.gui = gui;
        this.ctxHandle = ctxHandle;
        this.displayIdx = displayIdx;
    }

    public void output(String ifdName, OutputInfoType outInfo) throws IFDException {
        Boolean optic;
        this.getCapabilities();
        BigInteger didx = outInfo.getDisplayIndex();
        if (didx == null) {
            didx = BigInteger.valueOf(0L);
        }
        String msg = outInfo.getMessage();
        BigInteger timeout = outInfo.getTimeout();
        Boolean acoustic = outInfo.isAcousticalSignal();
        if (acoustic == null) {
            acoustic = Boolean.FALSE;
        }
        if ((optic = outInfo.isOpticalSignal()) == null) {
            optic = Boolean.FALSE;
        }
        if (acoustic.booleanValue()) {
            if (this.canBeep() || this.isVirtual()) {
                this.beep();
            } else {
                IFDException ex = new IFDException("No device to output a beep available.");
                LOG.warn(ex.getMessage(), ex);
                throw ex;
            }
        }
        if (optic.booleanValue()) {
            if (this.canBlink() || this.isVirtual()) {
                this.blink();
            } else {
                IFDException ex = new IFDException("No device to output a blink available.");
                LOG.warn(ex.getMessage(), ex);
                throw ex;
            }
        }
        if (msg != null) {
            if (this.canDisplay() || this.isVirtual()) {
                this.display(msg, timeout);
            } else {
                IFDException ex = new IFDException("No device to output a message available.");
                LOG.warn(ex.getMessage(), ex);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VerifyUserResponse verifyUser(VerifyUser verify) throws SCIOException, IFDException {
        byte[] handle = verify.getSlotHandle();
        this.getCapabilities();
        List<String> protoList = this.capabilities.getSlotCapability().get(0).getProtocol();
        if (!protoList.contains("urn:oid:1.3.162.15480.3.0.9")) {
            throw new IFDException("PinCompare protocol is not supported by this IFD.");
        }
        InputUnitType inputUnit = verify.getInputUnit();
        AltVUMessagesType allMsgs = AbstractTerminal.getMessagesOrDefaults(verify.getAltVUMessages());
        BigInteger firstTimeout = verify.getTimeoutUntilFirstKey();
        firstTimeout = firstTimeout == null ? BigInteger.valueOf(60000L) : firstTimeout;
        BigInteger otherTimeout = verify.getTimeoutAfterFirstKey();
        otherTimeout = otherTimeout == null ? BigInteger.valueOf(15000L) : otherTimeout;
        byte[] template = verify.getTemplate();
        if (inputUnit.getBiometricInput() != null) {
            String msg = "Biometric authentication not supported by IFD.";
            IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownInputUnit", msg);
            LOG.warn(ex.getMessage(), ex);
            throw ex;
        }
        if (inputUnit.getPinInput() != null) {
            PinInputType pinInput = inputUnit.getPinInput();
            if (this.terminalInfo.supportsPinCompare()) {
                VerifyUserResponse response;
                NativePinStepAction pinAction = new NativePinStepAction("enter-pin", pinInput, this.channel, this.terminalInfo, template);
                UserConsentDescription uc = this.pinUserConsent("action.changepin.userconsent.pinstep.title", pinAction);
                UserConsentNavigator ucr = this.gui.obtainNavigator(uc);
                ExecutionEngine exec = new ExecutionEngine(ucr);
                ResultStatus status = exec.process();
                if (status == ResultStatus.CANCEL) {
                    String msg = "PIN entry cancelled by user.";
                    LOG.warn(msg);
                    Result result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", msg);
                    response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, result);
                } else if (pinAction.exception != null) {
                    LOG.warn(pinAction.exception.getMessage(), pinAction.exception);
                    Result result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/authenticationFailed", pinAction.exception.getMessage());
                    response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, result);
                } else {
                    byte[] verifyResponse = pinAction.response;
                    Result result = AbstractTerminal.checkNativePinVerify(verifyResponse);
                    response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, result);
                    response.setResponse(verifyResponse);
                }
                return response;
            }
            if (this.isVirtual()) {
                TransmitResponse transResp;
                Transmit verifyTransmit;
                int maxLength;
                int minLength = pinInput.getPasswordAttributes().getMinLength().intValue();
                UserConsentDescription uc = this.pinUserConsent("action.changepin.userconsent.pinstep.title", minLength, maxLength = pinInput.getPasswordAttributes().getMaxLength().intValue());
                UserConsentNavigator ucr = this.gui.obtainNavigator(uc);
                ExecutionEngine exec = new ExecutionEngine(ucr);
                ResultStatus status = exec.process();
                if (status == ResultStatus.CANCEL) {
                    String msg = "PIN entry cancelled by user.";
                    LOG.warn(msg);
                    Result result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", msg);
                    VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, result);
                    return response;
                }
                char[] rawPIN = AbstractTerminal.getPinFromUserConsent(exec);
                PasswordAttributesType attributes = pinInput.getPasswordAttributes();
                try {
                    verifyTransmit = PINUtils.buildVerifyTransmit(rawPIN, attributes, template, handle);
                }
                catch (UtilException e) {
                    VerifyUserResponse response;
                    String msg = "Failed to create the verifyTransmit message.";
                    LOG.error(msg, e);
                    Result result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/unknownError", msg);
                    VerifyUserResponse verifyUserResponse = response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, result);
                    return verifyUserResponse;
                }
                finally {
                    Arrays.fill(rawPIN, ' ');
                }
                try {
                    transResp = this.ifd.transmit(verifyTransmit);
                }
                finally {
                    for (InputAPDUInfoType apdu : verifyTransmit.getInputAPDUInfo()) {
                        byte[] rawApdu = apdu.getInputAPDU();
                        if (rawApdu == null) continue;
                        Arrays.fill(rawApdu, (byte)0);
                    }
                }
                if (transResp.getResult().getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
                    if (transResp.getOutputAPDU().isEmpty()) {
                        Result result = WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/authenticationFailed", transResp.getResult().getResultMessage().getValue());
                        VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, result);
                        return response;
                    }
                    VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, transResp.getResult());
                    response.setResponse(transResp.getOutputAPDU().get(0));
                    if (response.getResponse() != null) {
                        CardResponseAPDU resApdu = new CardResponseAPDU(response.getResponse());
                        byte[] statusBytes = resApdu.getStatusBytes();
                        boolean isMainStatus = statusBytes[0] == 99;
                        boolean isMinorStatus = (statusBytes[1] & 0xFFFFFFF0) == -64;
                        int triesLeft = statusBytes[1] & 0xF;
                        if (isMainStatus && isMinorStatus && triesLeft > 0) {
                            LOG.info("PIN not entered successful. There are {} tries left.", (Object)(statusBytes[1] & 0xF));
                            return this.verifyUser(verify);
                        }
                    }
                    return response;
                }
                VerifyUserResponse response = (VerifyUserResponse)WSHelper.makeResponse(VerifyUserResponse.class, transResp.getResult());
                response.setResponse(transResp.getOutputAPDU().get(0));
                return response;
            }
            IFDException ex = new IFDException("No input unit available to perform PinCompare protocol.");
            LOG.warn(ex.getMessage(), ex);
            throw ex;
        }
        String msg = "Unsupported authentication input method requested.";
        IFDException ex = new IFDException("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/IO#unknownInputUnit", msg);
        LOG.warn(ex.getMessage(), ex);
        throw ex;
    }

    private static AltVUMessagesType getMessagesOrDefaults(AltVUMessagesType messages) {
        AltVUMessagesType allMsgs = new AltVUMessagesType();
        if (messages == null || messages.getAuthenticationRequestMessage() == null) {
            allMsgs.setAuthenticationRequestMessage("Enter secret:");
        } else {
            allMsgs.setAuthenticationRequestMessage(messages.getAuthenticationRequestMessage());
        }
        if (messages == null || messages.getSuccessMessage() == null) {
            allMsgs.setSuccessMessage("Secret entered successfully.");
        } else {
            allMsgs.setSuccessMessage(messages.getSuccessMessage());
        }
        if (messages == null || messages.getAuthenticationFailedMessage() == null) {
            allMsgs.setAuthenticationFailedMessage("Secret not entered successfully.");
        } else {
            allMsgs.setAuthenticationFailedMessage(messages.getAuthenticationFailedMessage());
        }
        if (messages == null || messages.getRequestConfirmationMessage() == null) {
            allMsgs.setRequestConfirmationMessage("Enter secret again:");
        } else {
            allMsgs.setRequestConfirmationMessage(messages.getRequestConfirmationMessage());
        }
        if (messages == null || messages.getCancelMessage() == null) {
            allMsgs.setCancelMessage("Canceled secret input.");
        } else {
            allMsgs.setCancelMessage(messages.getCancelMessage());
        }
        return allMsgs;
    }

    private void beep() {
        if (this.canBeep()) {
            // empty if block
        }
    }

    private void blink() {
        if (this.canBlink()) {
            // empty if block
        }
    }

    private void display(String msg, BigInteger timeout) {
        if (this.canDisplay()) {
            // empty if block
        }
    }

    private boolean canBeep() {
        if (this.canBeep == null) {
            this.canBeep = this.capabilities.isAcousticSignalUnit();
        }
        return this.canBeep;
    }

    private boolean canBlink() {
        if (this.canBlink == null) {
            this.canBlink = this.capabilities.isOpticalSignalUnit();
        }
        return this.canBlink;
    }

    private boolean canDisplay() {
        if (this.canDisplay == null) {
            this.canDisplay = Boolean.FALSE;
            if (this.displayIdx == null && !this.capabilities.getDisplayCapability().isEmpty()) {
                this.canDisplay = Boolean.TRUE;
            } else {
                for (DisplayCapabilityType disp : this.capabilities.getDisplayCapability()) {
                    if (!disp.getIndex().equals(this.displayIdx)) continue;
                    this.canDisplay = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.canDisplay;
    }

    private DisplayCapabilityType getDisplayCapabilities() {
        if (this.canDisplay.booleanValue()) {
            if (this.displayIdx == null) {
                DisplayCapabilityType disp = this.capabilities.getDisplayCapability().get(0);
                return disp;
            }
            for (DisplayCapabilityType disp : this.capabilities.getDisplayCapability()) {
                if (!disp.getIndex().equals(this.displayIdx)) continue;
                return disp;
            }
            return null;
        }
        return null;
    }

    private boolean canEnter() {
        if (this.canEnter == null) {
            this.canEnter = Boolean.FALSE;
            if (this.keyIdx == null && !this.capabilities.getKeyPadCapability().isEmpty()) {
                this.canEnter = Boolean.TRUE;
            } else {
                for (KeyPadCapabilityType key : this.capabilities.getKeyPadCapability()) {
                    if (!key.getIndex().equals(this.keyIdx)) continue;
                    this.canEnter = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.canEnter;
    }

    private KeyPadCapabilityType getKeypadCapabilities() {
        if (this.canEnter.booleanValue()) {
            if (this.keyIdx == null) {
                KeyPadCapabilityType key = this.capabilities.getKeyPadCapability().get(0);
                return key;
            }
            for (KeyPadCapabilityType key : this.capabilities.getKeyPadCapability()) {
                if (!key.getIndex().equals(this.keyIdx)) continue;
                return key;
            }
            return null;
        }
        return null;
    }

    private boolean isVirtual() {
        return this.gui != null;
    }

    private static Result checkNativePinVerify(byte[] response) {
        byte sw1 = response[0];
        byte sw2 = response[1];
        if (sw1 == 100) {
            if (sw2 == 0) {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl/common#timeoutError", "Verify operation timed out.");
            }
            if (sw2 == 1) {
                return WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/ifdl#cancellationByUser", "Verify operation was cancelled with the cancel button.");
            }
            if (sw2 == 2) {
                return WSHelper.makeResultUnknownError("Modify PIN operation failed because two PINs were different.");
            }
            if (sw2 == 3) {
                return WSHelper.makeResultUnknownError("PIN has wrong length.");
            }
        } else if (sw1 == 107) {
            if (sw2 == -128) {
                return WSHelper.makeResultUnknownError("Invalid parameter passed to verify command.");
            }
        } else if (sw1 == -112 && sw2 == 0) {
            return WSHelper.makeResultOK();
        }
        return WSHelper.makeResultUnknownError(CardCommandStatus.getMessage(response));
    }

    private void getCapabilities() throws IFDException {
        GetIFDCapabilities capabilitiesReq = new GetIFDCapabilities();
        capabilitiesReq.setContextHandle(this.ctxHandle);
        capabilitiesReq.setIFDName(this.terminalInfo.getName());
        GetIFDCapabilitiesResponse cap = this.ifd.getIFDCapabilities(capabilitiesReq);
        Result r = cap.getResult();
        if (r.getResultMajor().equals("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#error")) {
            IFDException ex = new IFDException(r);
            LOG.warn(ex.getMessage(), ex);
            throw ex;
        }
        this.capabilities = cap.getIFDCapabilities();
    }

    private UserConsentDescription pinUserConsent(String title, int minLength, int maxLength) {
        UserConsentDescription uc = new UserConsentDescription(LANG.translationForKey(title, new Object[0]), "pin_entry_dialog");
        Step s = new Step("enter-pin", LANG.translationForKey("action.changepin.userconsent.pinstep.title", new Object[0]));
        uc.getSteps().add(s);
        Text i1 = new Text();
        s.getInputInfoUnits().add(i1);
        i1.setText(LANG.translationForKey("action.pinentry.userconsent.pinstep.enter_pin", new Object[0]));
        PasswordField i2 = new PasswordField("pin");
        s.getInputInfoUnits().add(i2);
        i2.setDescription("PIN");
        i2.setMinLength(minLength);
        i2.setMaxLength(maxLength);
        return uc;
    }

    private UserConsentDescription pinUserConsent(String title, StepAction action) {
        UserConsentDescription uc = new UserConsentDescription(LANG.translationForKey(title, new Object[0]), "pin_entry_dialog");
        Step s = new Step("enter-pin", LANG.translationForKey("action.changepin.userconsent.pinstep.title", new Object[0]));
        s.setAction(action);
        uc.getSteps().add(s);
        s.setInstantReturn(true);
        Text i1 = new Text();
        s.getInputInfoUnits().add(i1);
        i1.setText(LANG.translationForKey("action.pinentry.userconsent.pinstep.enter_pin_term", new Object[0]));
        return uc;
    }

    private static char[] getPinFromUserConsent(ExecutionEngine response) {
        PasswordField p = (PasswordField)response.getResults().get("enter-pin").getResult("pin");
        return p.getValue();
    }
}

