/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.protocol.pace.crypto;

import java.security.GeneralSecurityException;
import java.util.List;
import org.openecard.bouncycastle.crypto.engines.AESEngine;
import org.openecard.bouncycastle.crypto.macs.CMac;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.asn1.eac.PACEInfo;
import org.openecard.crypto.common.asn1.utils.ObjectIdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticationToken {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationToken.class.getName());
    private final PACEInfo pi;
    private final byte[] token = new byte[8];
    private byte[] currentCAR;
    private byte[] previousCAR;

    public AuthenticationToken(PACEInfo pi) {
        this.pi = pi;
    }

    public void generateToken(byte[] keyMac, byte[] key) throws GeneralSecurityException {
        byte[] tmp = new byte[16];
        byte[] macData = this.getMACObject(key);
        CMac cMAC = new CMac(new AESEngine());
        cMAC.init(new KeyParameter(keyMac));
        cMAC.update(macData, 0, macData.length);
        cMAC.doFinal(tmp, 0);
        System.arraycopy(tmp, 0, this.token, 0, 8);
    }

    public boolean verifyToken(AuthenticationToken token, boolean specifiedCHAT) throws GeneralSecurityException {
        return this.verifyToken(token.toByteArray(), specifiedCHAT);
    }

    public boolean verifyToken(byte[] T_PICC, boolean specifiedCHAT) throws GeneralSecurityException {
        try {
            TLV dataSet = TLV.fromBER(T_PICC);
            if (dataSet.getTagNumWithClass() != 124L) {
                throw new GeneralSecurityException("The returned object is not a set of dynamic authentication data.");
            }
            List<TLV> authTokens = dataSet.findChildTags(134L);
            if (authTokens.isEmpty()) {
                String msg = "Authentication Token is missing in set of dynamic authentication data.";
                throw new GeneralSecurityException(msg);
            }
            if (authTokens.size() > 1) {
                String msg = "Authentication Token is present multiple times in set of dynamic authentication data.";
                throw new GeneralSecurityException(msg);
            }
            byte[] newToken = authTokens.get(0).getValue();
            if (!ByteUtils.compare(newToken, this.token)) {
                throw new GeneralSecurityException("Can not verify authentication token.");
            }
            if (specifiedCHAT) {
                List<TLV> car1 = dataSet.findChildTags(135L);
                if (car1.isEmpty()) {
                    String msg = "Current CAR is missing in set of dynamic authentication data.";
                    throw new GeneralSecurityException(msg);
                }
                if (car1.size() > 1) {
                    String msg = "Current CAR is present multiple times in set of dynamic authentication data.";
                    throw new GeneralSecurityException(msg);
                }
                this.currentCAR = car1.get(0).getValue();
                AuthenticationToken.verifyCAR("Current CAR", this.currentCAR);
                List<TLV> car2 = dataSet.findChildTags(136L);
                if (car2.size() > 1) {
                    String msg = "Previous CAR is present multiple times in set of dynamic authentication data.";
                    throw new GeneralSecurityException(msg);
                }
                if (car2.size() == 1) {
                    this.previousCAR = car2.get(0).getValue();
                    AuthenticationToken.verifyCAR("Previous CAR", this.previousCAR);
                }
            }
        }
        catch (TLVException ex) {
            throw new GeneralSecurityException("Given data is not a valid ASN.1 object.", ex);
        }
        return true;
    }

    public byte[] toByteArray() {
        return this.token;
    }

    public byte[] getCurrentCAR() {
        return this.currentCAR;
    }

    public byte[] getPreviousCAR() {
        return this.previousCAR;
    }

    private byte[] getMACObject(byte[] key) throws GeneralSecurityException {
        byte[] ret = null;
        try {
            TLV keyObject = new TLV();
            keyObject.setTagNumWithClass((byte)-122);
            keyObject.setValue(ByteUtils.cutLeadingNullBytes(key));
            TLV oidObject = new TLV();
            oidObject.setTagNumWithClass((byte)6);
            oidObject.setValue(ObjectIdentifierUtils.getValue(this.pi.getProtocol()));
            oidObject.addToEnd(keyObject);
            TLV macObject = new TLV();
            macObject.setTagNum((byte)73);
            macObject.setTagClass(TagClass.APPLICATION);
            macObject.setChild(oidObject);
            ret = macObject.toBER(true);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            throw new GeneralSecurityException(e);
        }
        return ret;
    }

    private static void verifyCAR(String name, byte[] car) throws GeneralSecurityException {
        int s = car.length;
        if (8 > s || s > 16) {
            throw new GeneralSecurityException(String.format("%s is not withing specified size.", name));
        }
    }
}

