/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.event;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.IFDCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.KeyPadCapabilityType;
import iso.std.iso_iec._24727.tech.schema.SlotStatusType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.WSHelper;
import org.openecard.common.event.EventType;
import org.openecard.common.event.IfdEventObject;
import org.openecard.common.ifd.scio.NoSuchTerminal;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.util.HandlerBuilder;
import org.openecard.ifd.event.IfdEventManager;
import org.openecard.ifd.event.Recognizer;
import org.openecard.ifd.scio.wrapper.ChannelManager;
import org.openecard.ifd.scio.wrapper.SingleThreadChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfdEventRunner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(IfdEventRunner.class);
    private static final long[] RECOVER_TIME = new long[]{1L, 500L, 2000L, 5000L};
    private final Environment env;
    private final IfdEventManager evtManager;
    private final HandlerBuilder builder;
    private final ChannelManager cm;
    private final byte[] ctxHandle;
    private final List<IFDStatusType> initialState;
    private final List<IFDStatusType> currentState;

    public IfdEventRunner(Environment env, IfdEventManager evtManager, HandlerBuilder builder, ChannelManager cm, byte[] ctxHandle) throws WSHelper.WSException {
        this.env = env;
        this.evtManager = evtManager;
        this.builder = builder;
        this.cm = cm;
        this.ctxHandle = ctxHandle;
        this.initialState = new ArrayList<IFDStatusType>(evtManager.ifdStatus());
        this.currentState = new ArrayList<IFDStatusType>();
    }

    @Override
    public void run() {
        this.fireEvents(this.initialState);
        try {
            int failCount = 0;
            while (true) {
                try {
                    while (true) {
                        List<IFDStatusType> diff = this.evtManager.wait(this.currentState);
                        this.fireEvents(diff);
                        failCount = 0;
                    }
                }
                catch (WSHelper.WSException ex) {
                    LOG.warn("IFD Wait returned with error.", ex);
                    int sleepIdx = failCount < RECOVER_TIME.length ? failCount : RECOVER_TIME.length - 1;
                    Thread.sleep(RECOVER_TIME[sleepIdx]);
                    ++failCount;
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException ex) {
            LOG.info("Event thread interrupted.", ex);
            return;
        }
    }

    private IFDStatusType getCorresponding(String ifdName, List<IFDStatusType> statuses) {
        for (IFDStatusType next : statuses) {
            if (!next.getIFDName().equals(ifdName)) continue;
            return next;
        }
        return null;
    }

    private SlotStatusType getCorresponding(BigInteger idx, List<SlotStatusType> statuses) {
        for (SlotStatusType next : statuses) {
            if (!next.getIndex().equals(idx)) continue;
            return next;
        }
        return null;
    }

    private ConnectionHandleType makeConnectionHandle(String ifdName, BigInteger slotIdx, IFDCapabilitiesType slotCapabilities) {
        ConnectionHandleType h = this.builder.setIfdName(ifdName).setSlotIdx(slotIdx).setProtectedAuthPath(this.hasKeypad(slotCapabilities)).buildConnectionHandle();
        return h;
    }

    private ConnectionHandleType makeUnknownCardHandle(String ifdName, SlotStatusType status, IFDCapabilitiesType slotCapabilities) {
        ConnectionHandleType h = this.builder.setIfdName(ifdName).setSlotIdx(status.getIndex()).setCardType("http://bsi.bund.de/cif/unknown").setCardIdentifier(status.getATRorATS()).setProtectedAuthPath(this.hasKeypad(slotCapabilities)).buildConnectionHandle();
        return h;
    }

    private void fireEvents(@Nonnull List<IFDStatusType> diff) {
        for (IFDStatusType term : diff) {
            String ifdName = term.getIFDName();
            IFDStatusType oldTerm = this.getCorresponding(ifdName, this.currentState);
            boolean terminalAdded = oldTerm == null;
            IFDCapabilitiesType slotCapabilities = this.getCapabilities(ifdName);
            if (terminalAdded) {
                oldTerm = new IFDStatusType();
                oldTerm.setIFDName(ifdName);
                oldTerm.setConnected(true);
                this.currentState.add(oldTerm);
                ConnectionHandleType h = this.makeConnectionHandle(ifdName, null, slotCapabilities);
                LOG.debug("Found a terminal added event ({}).", (Object)ifdName);
                this.env.getEventDispatcher().notify(EventType.TERMINAL_ADDED, new IfdEventObject(h));
            }
            for (SlotStatusType slot : term.getSlotStatus()) {
                boolean cardWasPresent;
                SlotStatusType oldSlot = this.getCorresponding(slot.getIndex(), oldTerm.getSlotStatus());
                boolean cardPresent = slot.isCardAvailable();
                boolean bl = cardWasPresent = oldSlot != null && oldSlot.isCardAvailable();
                if (cardPresent && !cardWasPresent) {
                    SlotStatusType newSlot = oldSlot;
                    if (newSlot == null) {
                        newSlot = new SlotStatusType();
                        oldTerm.getSlotStatus().add(newSlot);
                    }
                    newSlot.setIndex(slot.getIndex());
                    newSlot.setCardAvailable(true);
                    newSlot.setATRorATS(slot.getATRorATS());
                    LOG.debug("Found a card insert event ({}).", (Object)ifdName);
                    ConnectionHandleType handle = this.makeUnknownCardHandle(ifdName, newSlot, slotCapabilities);
                    this.env.getEventDispatcher().notify(EventType.CARD_INSERTED, new IfdEventObject(handle));
                    try {
                        SingleThreadChannel ch = this.cm.openMasterChannel(ifdName);
                        if (!this.evtManager.isRecognize()) continue;
                        String proto = ch.getChannel().getCard().getProtocol().toUri();
                        this.evtManager.threadPool.submit(new Recognizer(this.env, handle, proto));
                    }
                    catch (NoSuchTerminal | SCIOException ex) {
                        LOG.error("Failed to connect card, nevertheless sending CARD_INSERTED event.", ex);
                    }
                    continue;
                }
                if (terminalAdded || cardPresent || !cardWasPresent) continue;
                BigInteger idx = oldSlot.getIndex();
                Iterator<SlotStatusType> it = oldTerm.getSlotStatus().iterator();
                while (it.hasNext()) {
                    SlotStatusType next = it.next();
                    if (!idx.equals(next.getIndex())) continue;
                    it.remove();
                    break;
                }
                LOG.debug("Found a card removed event ({}).", (Object)ifdName);
                ConnectionHandleType h = this.makeConnectionHandle(ifdName, idx, slotCapabilities);
                this.env.getEventDispatcher().notify(EventType.CARD_REMOVED, new IfdEventObject(h));
            }
            boolean terminalPresent = term.isConnected();
            if (terminalPresent) continue;
            Iterator<IFDStatusType> it = this.currentState.iterator();
            while (it.hasNext()) {
                IFDStatusType toDel = it.next();
                if (!toDel.getIFDName().equals(term.getIFDName())) continue;
                it.remove();
            }
            ConnectionHandleType h = this.makeConnectionHandle(ifdName, null, slotCapabilities);
            LOG.debug("Found a terminal removed event ({}).", (Object)ifdName);
            this.env.getEventDispatcher().notify(EventType.TERMINAL_REMOVED, new IfdEventObject(h));
        }
    }

    @Nullable
    private IFDCapabilitiesType getCapabilities(String ifdName) {
        GetIFDCapabilities req = new GetIFDCapabilities();
        req.setContextHandle(this.ctxHandle);
        req.setIFDName(ifdName);
        GetIFDCapabilitiesResponse res = (GetIFDCapabilitiesResponse)this.env.getDispatcher().safeDeliver(req);
        return res.getIFDCapabilities();
    }

    private boolean hasKeypad(@Nullable IFDCapabilitiesType capabilities) {
        if (capabilities != null) {
            List<KeyPadCapabilityType> keyCaps = capabilities.getKeyPadCapability();
            return !keyCaps.isEmpty();
        }
        return false;
    }
}

