/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.ifd.event;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilities;
import iso.std.iso_iec._24727.tech.schema.GetIFDCapabilitiesResponse;
import iso.std.iso_iec._24727.tech.schema.GetStatus;
import iso.std.iso_iec._24727.tech.schema.GetStatusResponse;
import iso.std.iso_iec._24727.tech.schema.IFDCapabilitiesType;
import iso.std.iso_iec._24727.tech.schema.IFDStatusType;
import iso.std.iso_iec._24727.tech.schema.Wait;
import iso.std.iso_iec._24727.tech.schema.WaitResponse;
import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.WSHelper;
import org.openecard.common.event.EventType;
import org.openecard.common.event.IfdEventObject;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.util.HandlerBuilder;
import org.openecard.common.util.ValueGenerators;
import org.openecard.ifd.event.IfdEventRunner;
import org.openecard.ifd.event.Recognizer;
import org.openecard.ifd.scio.wrapper.ChannelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfdEventManager {
    private static final Logger LOG = LoggerFactory.getLogger(IfdEventManager.class);
    private static final AtomicInteger THREAD_NUM = new AtomicInteger(1);
    protected final Environment env;
    protected final ChannelManager cm;
    protected final byte[] ctx;
    protected final String sessionId;
    private final HandlerBuilder builder;
    protected ExecutorService threadPool;
    private Future<?> watcher;

    public IfdEventManager(Environment env, ChannelManager cm, byte[] ctx) {
        this.env = env;
        this.cm = cm;
        this.ctx = ctx;
        this.sessionId = ValueGenerators.genBase64Session();
        this.builder = HandlerBuilder.create().setContextHandle(ctx).setSessionId(this.sessionId);
    }

    public synchronized void initialize() {
        this.threadPool = Executors.newCachedThreadPool(new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger(0);
            private final ThreadGroup group = new ThreadGroup("IFD Event Manager");

            @Override
            public Thread newThread(Runnable r) {
                String name = String.format("IFD Watcher %d", this.num.getAndIncrement());
                Thread t = new Thread(this.group, r, name);
                t.setDaemon(false);
                return t;
            }
        });
        try {
            this.watcher = this.threadPool.submit(new IfdEventRunner(this.env, this, this.builder, this.cm, this.ctx));
        }
        catch (WSHelper.WSException ex) {
            throw new RuntimeException("Failed to request initial status from IFD.");
        }
    }

    public synchronized void terminate() {
        this.watcher.cancel(true);
        this.threadPool.shutdownNow();
    }

    @Nonnull
    protected List<IFDStatusType> ifdStatus() throws WSHelper.WSException {
        GetStatus status = new GetStatus();
        status.setContextHandle(this.ctx);
        GetStatusResponse statusResponse = this.env.getIFD().getStatus(status);
        WSHelper.checkResult(statusResponse);
        List<IFDStatusType> result = statusResponse.getIFDStatus();
        return result;
    }

    @Nonnull
    protected List<IFDStatusType> wait(@Nonnull List<IFDStatusType> lastKnown) throws WSHelper.WSException {
        Wait wait = new Wait();
        wait.setContextHandle(this.ctx);
        wait.getIFDStatus().addAll(lastKnown);
        WaitResponse resp = this.env.getIFD().wait(wait);
        WSHelper.checkResult(resp);
        List<IFDStatusType> result = resp.getIFDEvent();
        return result;
    }

    public void resetCard(ConnectionHandleType cHandleRm, ConnectionHandleType cHandleIn, String ifaceProtocol) {
        this.env.getEventDispatcher().notify(EventType.CARD_REMOVED, new IfdEventObject(cHandleRm, null));
        IFDCapabilitiesType slotCapabilities = this.getCapabilities(cHandleRm.getContextHandle(), cHandleRm.getIFDName());
        boolean protectedAuthPath = slotCapabilities != null ? !slotCapabilities.getKeyPadCapability().isEmpty() : false;
        HandlerBuilder chBuilder = HandlerBuilder.create();
        ConnectionHandleType cInNew = chBuilder.setSessionId(this.sessionId).setCardType(cHandleIn.getRecognitionInfo()).setCardIdentifier(cHandleIn.getRecognitionInfo()).setContextHandle(cHandleIn.getContextHandle()).setIfdName(cHandleIn.getIFDName()).setSlotIdx(BigInteger.ZERO).setSlotHandle(cHandleIn.getSlotHandle()).setProtectedAuthPath(protectedAuthPath).buildConnectionHandle();
        this.env.getEventDispatcher().notify(EventType.CARD_INSERTED, new IfdEventObject(cInNew));
        if (this.isRecognize()) {
            Recognizer rec = new Recognizer(this.env, cInNew, ifaceProtocol);
            Thread recThread = new Thread((Runnable)rec, "Recoginiton-" + THREAD_NUM.getAndIncrement());
            recThread.start();
        }
    }

    boolean isRecognize() {
        return this.env.getRecognition() != null;
    }

    @Nullable
    private IFDCapabilitiesType getCapabilities(byte[] ctxHandle, String ifdName) {
        GetIFDCapabilities req = new GetIFDCapabilities();
        req.setContextHandle(ctxHandle);
        req.setIFDName(ifdName);
        GetIFDCapabilitiesResponse res = (GetIFDCapabilitiesResponse)this.env.getDispatcher().safeDeliver(req);
        return res.getIFDCapabilities();
    }
}

