/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.steplayout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.openecard.gui.definition.Checkbox;
import org.openecard.gui.definition.Hyperlink;
import org.openecard.gui.definition.ImageBox;
import org.openecard.gui.definition.InputInfoUnit;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.Radiobox;
import org.openecard.gui.definition.TextField;
import org.openecard.gui.swing.Logo;
import org.openecard.gui.swing.ScrollPanel;
import org.openecard.gui.swing.components.AbstractInput;
import org.openecard.gui.swing.components.Radiobutton;
import org.openecard.gui.swing.components.StepComponent;
import org.openecard.gui.swing.components.Text;
import org.openecard.gui.swing.components.ToggleText;
import org.openecard.gui.swing.steplayout.StepLayouter;

public class PinEntryStepLayouter
extends StepLayouter {
    private final ArrayList<StepComponent> components;
    private final JPanel rootPanel;

    protected PinEntryStepLayouter(List<InputInfoUnit> infoUnits, String stepName) {
        this.components = new ArrayList(infoUnits.size());
        this.rootPanel = new JPanel(new BorderLayout());
        JPanel pageStart = new JPanel(new BorderLayout());
        ImageIcon logo = Logo.loadLogoIcon();
        JLabel title = new JLabel("<html><h3>" + stepName + "</h3></html>");
        title.setIcon(logo);
        title.setIconTextGap(20);
        title.setBorder(new EmptyBorder(0, 0, 3, 0));
        pageStart.add((Component)title, "First");
        JSeparator sep = new JSeparator(0);
        pageStart.add((Component)sep, "Center");
        pageStart.setBorder(new EmptyBorder(0, 0, 15, 0));
        this.rootPanel.add((Component)pageStart, "First");
        ScrollPanel contentPanel = new ScrollPanel();
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        for (InputInfoUnit next : infoUnits) {
            StepComponent nextComponent = null;
            switch (next.type()) {
                case CHECK_BOX: {
                    nextComponent = new org.openecard.gui.swing.components.Checkbox((Checkbox)next);
                    break;
                }
                case HYPERLINK: {
                    nextComponent = new org.openecard.gui.swing.components.Hyperlink((Hyperlink)next);
                    break;
                }
                case IMAGE_BOX: {
                    nextComponent = new org.openecard.gui.swing.components.ImageBox((ImageBox)next);
                    break;
                }
                case PASSWORD_FIELD: {
                    nextComponent = new AbstractInput((PasswordField)next);
                    break;
                }
                case RADIO_BOX: {
                    nextComponent = new Radiobutton((Radiobox)next);
                    break;
                }
                case SIGNAUTRE_FIELD: {
                    throw new UnsupportedOperationException("Not implemented yet.");
                }
                case TEXT: {
                    nextComponent = new Text((org.openecard.gui.definition.Text)next);
                    break;
                }
                case TEXT_FIELD: {
                    nextComponent = new AbstractInput((TextField)next);
                    break;
                }
                case TOGGLE_TEXT: {
                    nextComponent = new ToggleText((org.openecard.gui.definition.ToggleText)next);
                }
            }
            if (nextComponent == null) continue;
            this.components.add(nextComponent);
            contentPanel.add(nextComponent.getComponent());
            contentPanel.add(Box.createRigidArea(new Dimension(0, 6)));
        }
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.rootPanel.add((Component)scrollPane, "Center");
    }

    @Override
    public List<StepComponent> getComponents() {
        return this.components;
    }

    @Override
    public Container getPanel() {
        return this.rootPanel;
    }
}

