/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.openecard.common.util.FileUtils;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.swing.components.VirtualPinPadDialog;

public class VirtualPinPadButton
extends JLabel {
    private final JTextComponent inputField;
    private final PasswordField passDef;

    public VirtualPinPadButton(JTextComponent inputField, PasswordField passDef) {
        super(VirtualPinPadButton.getPinPadIcon());
        this.inputField = inputField;
        this.passDef = passDef;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addMouseListener(new ButtonStyleHandler());
        this.addMouseListener(new VirtualPinPadDialogHandler());
    }

    private static ImageIcon getPinPadIcon() {
        URL imgUrl = FileUtils.resolveResourceAsURL(VirtualPinPadButton.class, "virtual-pinpad-button.png");
        ImageIcon img = new ImageIcon(imgUrl);
        return img;
    }

    private class VirtualPinPadDialogHandler
    implements MouseListener {
        private VirtualPinPadDialogHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            VirtualPinPadDialog dialog = new VirtualPinPadDialog(VirtualPinPadButton.this, VirtualPinPadButton.this.inputField, VirtualPinPadButton.this.passDef);
            dialog.setVisible(true);
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class ButtonStyleHandler
    implements MouseListener {
        private ButtonStyleHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            VirtualPinPadButton.this.setBorder(BorderFactory.createLoweredBevelBorder());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            VirtualPinPadButton.this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

