/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JLabel;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.swing.components.StepComponent;

public class Hyperlink
implements StepComponent {
    private final URL href;
    private final String text;
    private final String underlineText;
    private final JLabel label;

    public Hyperlink(org.openecard.gui.definition.Hyperlink link) {
        this.href = link.getHref();
        this.text = link.getText() != null ? link.getText() : this.href.toString();
        this.underlineText = "<html><u>" + this.text + "</u></html>";
        this.label = new JLabel(this.text);
        this.label.setDoubleBuffered(true);
        this.label.setForeground(Color.blue);
        this.label.setToolTipText(this.href.toString());
        this.label.addMouseListener(new BrowserLauncher());
    }

    @Override
    public Component getComponent() {
        return this.label;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public boolean isValueType() {
        return false;
    }

    @Override
    public OutputInfoUnit getValue() {
        return null;
    }

    private class BrowserLauncher
    implements MouseListener {
        private BrowserLauncher() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                boolean browserOpened = false;
                URI uri = new URI(Hyperlink.this.href.toString());
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(uri);
                        browserOpened = true;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (!browserOpened) {
                    ProcessBuilder pb = new ProcessBuilder("xdg-open", uri.toString());
                    try {
                        pb.start();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Hyperlink.this.label.setText(Hyperlink.this.underlineText);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Hyperlink.this.label.setText(Hyperlink.this.text);
        }
    }
}

