/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.openecard.gui.definition.AbstractTextField;
import org.openecard.gui.definition.OutputInfoUnit;
import org.openecard.gui.definition.PasswordField;
import org.openecard.gui.definition.TextField;
import org.openecard.gui.swing.components.Focusable;
import org.openecard.gui.swing.components.StepComponent;
import org.openecard.gui.swing.components.VirtualPinPadButton;

public class AbstractInput
implements StepComponent,
Focusable {
    private final String name;
    private final int minLength;
    private final int maxLength;
    private final JPanel panel;
    private final JLabel label;
    private final JTextField textField;
    private final AbstractTextField result;

    public AbstractInput(TextField input) {
        this(input, new TextField(input.getID()), new JTextField(20));
    }

    public AbstractInput(PasswordField input) {
        this(input, new PasswordField(input.getID()), new JPasswordField(12));
        this.panel.add((Component)new VirtualPinPadButton(this.textField, input), 1);
    }

    private AbstractInput(AbstractTextField input, AbstractTextField output, JTextField textFieldImpl) {
        this.name = input.getID();
        this.minLength = input.getMinLength();
        this.maxLength = input.getMaxLength();
        char[] value = input.getValue();
        String labelText = input.getDescription();
        this.result = output;
        this.result.setMinLength(this.minLength);
        this.result.setMaxLength(this.maxLength);
        this.result.setDescription(labelText);
        this.textField = textFieldImpl;
        if (!(this.textField instanceof JPasswordField)) {
            this.textField.setText(new String(value));
            this.textField.selectAll();
        }
        this.label = new JLabel();
        this.label.setMinimumSize(new Dimension(100, 0));
        this.label.setMaximumSize(new Dimension(100, 50));
        this.label.setSize(100, this.label.getSize().height);
        if (labelText != null) {
            this.label.setText(labelText);
        }
        this.panel = new JPanel();
        FlowLayout panelLayout = new FlowLayout(0);
        this.panel.setLayout(panelLayout);
        this.panel.add(this.textField);
        this.panel.add(this.label);
    }

    @Nonnull
    private char[] getFieldValue() {
        Document doc = this.textField.getDocument();
        Segment txt = new Segment();
        try {
            doc.getText(0, doc.getLength(), txt);
        }
        catch (BadLocationException e) {
            return new char[0];
        }
        char[] retValue = new char[txt.count];
        System.arraycopy(txt.array, txt.offset, retValue, 0, txt.count);
        return retValue;
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public boolean validate() {
        int textSize;
        String textValue = this.textField.getText();
        if (textValue == null) {
            textValue = "";
        }
        return this.minLength <= (textSize = textValue.length()) && textSize <= this.maxLength;
    }

    @Override
    public boolean isValueType() {
        return true;
    }

    @Override
    public OutputInfoUnit getValue() {
        char[] textValue = this.getFieldValue();
        this.result.setValue(textValue);
        Arrays.fill(textValue, ' ');
        return this.result;
    }

    @Override
    public void setFocus() {
        this.textField.requestFocusInWindow();
    }
}

