/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openecard.gui.FileDialog;
import org.openecard.gui.MessageDialog;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.swing.Logo;
import org.openecard.gui.swing.NavigationBar;
import org.openecard.gui.swing.StepBar;
import org.openecard.gui.swing.SwingDialogWrapper;
import org.openecard.gui.swing.SwingFileDialog;
import org.openecard.gui.swing.SwingMessageDialog;
import org.openecard.gui.swing.SwingNavigator;

public class SwingUserConsent
implements UserConsent {
    private final SwingDialogWrapper baseDialogWrapper;

    public SwingUserConsent(SwingDialogWrapper dialogWrapper) {
        this.baseDialogWrapper = dialogWrapper;
    }

    @Override
    public UserConsentNavigator obtainNavigator(UserConsentDescription parameters) {
        SwingDialogWrapper dialogWrapper = this.baseDialogWrapper.derive();
        dialogWrapper.setTitle(parameters.getTitle());
        Container rootPanel = dialogWrapper.getContentPane();
        rootPanel.removeAll();
        boolean isPinEntryDialog = parameters.getDialogType().equals("pin_entry_dialog");
        boolean isPinChangeDialog = parameters.getDialogType().equals("pin_change_dialog");
        boolean isUpdateDialog = parameters.getDialogType().equals("update_dialog");
        if (isPinEntryDialog) {
            dialogWrapper.setSize(350, 284);
        } else if (isPinChangeDialog) {
            dialogWrapper.setSize(570, 430);
        } else if (isUpdateDialog) {
            dialogWrapper.setSize(480, 330);
        }
        String dialogType = parameters.getDialogType();
        List<Step> steps = parameters.getSteps();
        JPanel stepPanel = new JPanel(new BorderLayout());
        JPanel sideBar = new JPanel();
        StepBar stepBar = new StepBar(steps);
        final NavigationBar navBar = new NavigationBar(steps.size());
        Logo l = new Logo();
        this.initializeSidePanel(sideBar, l, stepBar);
        final SwingNavigator navigator = new SwingNavigator(dialogWrapper, dialogType, steps, stepPanel, navBar, stepBar);
        navBar.registerEvents(navigator);
        dialogWrapper.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "process-next-button");
        dialogWrapper.getRootPane().getActionMap().put("process-next-button", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (navBar.isNextButtonAccessible()) {
                    ActionEvent e = new ActionEvent(navBar, 1001, "Button.next");
                    navigator.actionPerformed(e);
                }
            }
        });
        dialogWrapper.getDialog().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ActionEvent e = new ActionEvent(navBar, 1001, "Button.cancel");
                navigator.actionPerformed(e);
            }
        });
        GroupLayout layout = new GroupLayout(rootPanel);
        rootPanel.setLayout(layout);
        layout.setAutoCreateGaps(false);
        layout.setAutoCreateContainerGaps(true);
        if (isPinEntryDialog || isPinChangeDialog || isUpdateDialog) {
            layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(stepPanel).addComponent(navBar)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(layout.createSequentialGroup().addComponent(stepPanel).addComponent(navBar)));
        } else {
            layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(sideBar, 200, 200, 200).addGroup(layout.createParallelGroup().addComponent(stepPanel).addComponent(navBar)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(sideBar).addGroup(layout.createSequentialGroup().addComponent(stepPanel).addComponent(navBar)));
        }
        rootPanel.validate();
        rootPanel.repaint();
        return navigator;
    }

    @Override
    public FileDialog obtainFileDialog() {
        return new SwingFileDialog();
    }

    @Override
    public MessageDialog obtainMessageDialog() {
        return new SwingMessageDialog();
    }

    private void initializeSidePanel(JPanel panel, JComponent ... components) {
        panel.setLayout(new BoxLayout(panel, 3));
        for (JComponent c : components) {
            c.setAlignmentX(0.0f);
            panel.add(c);
        }
    }
}

