/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.gui.graphics;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GraphicsUtil.class);

    public static Image createImage(Class<? extends Icon> clazz, int imageWidth, int imageHeight) {
        return GraphicsUtil.createImage(clazz, imageWidth, imageHeight, imageWidth, imageHeight, 0, 0);
    }

    public static Image createImage(Class<? extends Icon> clazz, int imageWidth, int imageHeight, int canvasWidth, int canvasHeight, int posX, int posY) {
        BufferedImage image = new BufferedImage(canvasWidth, canvasHeight, 2);
        try {
            Icon svgIcon = clazz.newInstance();
            Method method = clazz.getMethod("setDimension", Dimension.class);
            method.invoke((Object)svgIcon, new Dimension(imageWidth, imageHeight));
            method = clazz.getMethod("paintIcon", Component.class, Graphics.class, Integer.TYPE, Integer.TYPE);
            method.invoke((Object)svgIcon, null, image.createGraphics(), posX, posY);
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), ex);
        }
        return image;
    }
}

