/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.verify;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustStoreLoader {
    private static final Logger LOG = LoggerFactory.getLogger(TrustStoreLoader.class);
    private static final String DEFAULT_TRUSTSTORE_FILE = "oec_cacerts.zip";
    private static final Map<String, KeyStore> TRUST_STORES = new HashMap<String, KeyStore>();
    private static final Map<String, Set<TrustAnchor>> TRUST_ANCHORS = new HashMap<String, Set<TrustAnchor>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void reset() {
        Class<TrustStoreLoader> clazz = TrustStoreLoader.class;
        synchronized (TrustStoreLoader.class) {
            TRUST_STORES.clear();
            TRUST_ANCHORS.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    protected String getStoreFileName() {
        return DEFAULT_TRUSTSTORE_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        try {
            String tmAlg = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(tmAlg);
            KeyStore ks = this.loadInternalStore();
            tmFactory.init(ks);
            HashSet<TrustAnchor> anchors = new HashSet<TrustAnchor>();
            TrustManager[] tms = tmFactory.getTrustManagers();
            for (TrustManager tm : tms) {
                if (!(tm instanceof X509TrustManager)) continue;
                X509TrustManager x509Tm = (X509TrustManager)tm;
                for (X509Certificate cert : x509Tm.getAcceptedIssuers()) {
                    TrustAnchor ta = new TrustAnchor(cert, null);
                    anchors.add(ta);
                }
            }
            if (anchors.isEmpty()) {
                LOG.error("No trusted CAs found.");
            }
            if (ks == null) {
                ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null);
                for (TrustAnchor a : anchors) {
                    X509Certificate cert = a.getTrustedCert();
                    if (ks.getCertificateAlias(cert) != null) continue;
                    ks.setCertificateEntry(cert.getSubjectX500Principal().getName(), cert);
                }
            }
            Class<TrustStoreLoader> clazz = TrustStoreLoader.class;
            synchronized (TrustStoreLoader.class) {
                TRUST_STORES.put(this.getStoreFileName(), ks);
                TRUST_ANCHORS.put(this.getStoreFileName(), Collections.unmodifiableSet(anchors));
                // ** MonitorExit[var6_8] (shouldn't be in output)
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            String msg = "Failed to create or initialize TrustManagerFactory.";
            LOG.error(msg, ex);
            throw new RuntimeException(msg, ex);
        }
        {
            return;
        }
    }

    protected boolean useInternalStore() {
        String useSysStr = OpenecardProperties.getProperty("tls.truststore.use-system");
        boolean useSys = Boolean.valueOf(useSysStr);
        return !useSys;
    }

    protected KeyStore loadInternalStore() {
        if (this.useInternalStore()) {
            try {
                ZipInputStream zis;
                KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                ks.load(null);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                InputStream is = FileUtils.resolveResourceAsStream(TrustStoreLoader.class, this.getStoreFileName());
                ZipInputStream zipInputStream = zis = is != null ? new ZipInputStream(is) : null;
                if (zis != null) {
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        int numRead;
                        if (entry.isDirectory()) continue;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] data = new byte[4096];
                        do {
                            if ((numRead = zis.read(data, 0, 4096)) == -1) continue;
                            baos.write(data, 0, numRead);
                        } while (numRead != -1);
                        ByteArrayInputStream dataStream = new ByteArrayInputStream(baos.toByteArray());
                        Certificate cert = cf.generateCertificate(dataStream);
                        ks.setCertificateEntry(entry.getName(), cert);
                    }
                    return ks;
                }
                LOG.error("Internal keystore not found, falling back to next available trust store.");
            }
            catch (IOException ex) {
                LOG.error("Error reading embedded keystore.", ex);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                LOG.error("Failed to obtain keystore or save entry in it..", ex);
            }
        }
        return null;
    }

    public Set<TrustAnchor> getTrustAnchors() {
        Set<TrustAnchor> result = TRUST_ANCHORS.get(this.getStoreFileName());
        if (result != null) {
            return result;
        }
        this.load();
        return this.getTrustAnchors();
    }

    public KeyStore getTrustStore() {
        KeyStore result = TRUST_STORES.get(this.getStoreFileName());
        if (result != null) {
            return result;
        }
        this.load();
        return this.getTrustStore();
    }
}

