/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.verify;

import java.io.IOException;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.tls.CertificateVerificationException;
import org.openecard.crypto.tls.CertificateVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameCertVerifier
implements CertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(SameCertVerifier.class);
    private TlsServerCertificate firstCert;

    @Override
    public void isValid(TlsServerCertificate serverCertificate, String hostOrIP) throws CertificateVerificationException {
        if (this.firstCert == null) {
            this.firstCert = serverCertificate;
        } else {
            if (serverCertificate == null) {
                String msg = "No server certificate transmitted. Test against first certificate is invalid.";
                LOG.error(msg);
                throw new CertificateVerificationException(msg);
            }
            if (this.firstCert.getCertificate().getLength() != serverCertificate.getCertificate().getLength()) {
                String msg = "Server certificate changed during transaction..";
                LOG.error(msg);
                throw new CertificateVerificationException(msg);
            }
            for (int i = 0; i < this.firstCert.getCertificate().getLength(); ++i) {
                byte[] second;
                byte[] first;
                try {
                    first = this.firstCert.getCertificate().getCertificateAt(i).getEncoded();
                    second = serverCertificate.getCertificate().getCertificateAt(i).getEncoded();
                }
                catch (IOException ex) {
                    String msg = "Failed to serialize certificate";
                    LOG.error(msg);
                    throw new CertificateVerificationException(msg, ex);
                }
                if (ByteUtils.compare(first, second)) continue;
                String msg = "Certificates retransmitted by the server differ.";
                LOG.error(msg);
                throw new CertificateVerificationException(msg);
            }
        }
    }
}

