/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.verify;

import java.io.IOException;
import org.openecard.bouncycastle.asn1.x509.Certificate;
import org.openecard.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.util.PublicKeyFactory;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;
import org.openecard.crypto.common.keystore.KeyLengthException;
import org.openecard.crypto.common.keystore.KeyTools;
import org.openecard.crypto.tls.CertificateVerificationException;
import org.openecard.crypto.tls.CertificateVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyLengthVerifier
implements CertificateVerifier {
    private static final Logger LOG = LoggerFactory.getLogger(KeyLengthVerifier.class);

    @Override
    public void isValid(TlsServerCertificate chain, String hostname) throws CertificateVerificationException {
        try {
            boolean firstCert = true;
            for (TlsCertificate next : chain.getCertificate().getCertificateList()) {
                boolean isRootCert;
                Certificate x509 = Certificate.getInstance(next.getEncoded());
                boolean selfSigned = x509.getIssuer().equals(x509.getSubject());
                boolean bl = isRootCert = selfSigned && !firstCert;
                if (isRootCert) continue;
                SubjectPublicKeyInfo pkInfo = x509.getSubjectPublicKeyInfo();
                AsymmetricKeyParameter key = PublicKeyFactory.createKey(pkInfo);
                KeyTools.assertKeyLength(key);
                firstCert = false;
            }
        }
        catch (IOException ex) {
            String msg = "Failed to extract public key from certificate.";
            throw new CertificateVerificationException(msg, ex);
        }
        catch (KeyLengthException ex) {
            String msg = "The key in the certificate does not satisfy the length requirements.";
            throw new CertificateVerificationException(msg, ex);
        }
    }
}

