/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.proxy;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.selector.fixed.FixedSocksSelector;
import com.github.markusbernhardt.proxy.selector.misc.ProtocolDispatchSelector;
import com.github.markusbernhardt.proxy.util.Logger;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.OpenecardProperties;
import org.openecard.crypto.tls.proxy.HttpConnectProxy;
import org.openecard.crypto.tls.proxy.NoProxySelector;
import org.openecard.crypto.tls.proxy.RegexProxySelector;
import org.openecard.crypto.tls.proxy.SelectorSupplier;
import org.openecard.crypto.tls.proxy.SingleProxySelector;
import org.openecard.crypto.tls.proxy.UpdatingProxySelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySettings {
    private static final Logger LOG = LoggerFactory.getLogger(ProxySettings.class);
    private final ProxySelector selector;

    public static synchronized void load() {
        ProxySelector selector = new NoProxySelector();
        String scheme = OpenecardProperties.getProperty("proxy.scheme");
        scheme = scheme != null ? scheme.toUpperCase() : "";
        String validate = OpenecardProperties.getProperty("proxy.validate_tls");
        String host = OpenecardProperties.getProperty("proxy.host");
        String port = OpenecardProperties.getProperty("proxy.port");
        String user = OpenecardProperties.getProperty("proxy.user");
        String pass = OpenecardProperties.getProperty("proxy.pass");
        String excl = OpenecardProperties.getProperty("proxy.excludes");
        ProxySettings.setSystemProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        ProxySettings.clearSystemProperties();
        switch (scheme) {
            case "SOCKS": {
                if (host == null || port == null) break;
                ProxySettings.setSystemProperty("socksProxyHost", host);
                ProxySettings.setSystemProperty("socksProxyPort", port);
                ProxySettings.setSystemProperty("socksProxyVersion", "5");
                ProxySettings.setSystemProperty("java.net.socks.username", user);
                ProxySettings.setSystemProperty("java.net.socks.password", pass);
                ProtocolDispatchSelector ps = new ProtocolDispatchSelector();
                ps.setFallbackSelector(new FixedSocksSelector(host, Integer.parseInt(port)));
                selector = ps;
                List<Pattern> exclusions = ProxySettings.parseExclusionHosts(excl);
                selector = new RegexProxySelector(selector, exclusions);
                break;
            }
            case "HTTP": 
            case "HTTPS": {
                if (host == null || port == null) break;
                try {
                    if ("HTTP".equals(scheme)) {
                        ProxySettings.setSystemProperty("http.proxyHost", host);
                        ProxySettings.setSystemProperty("http.proxyPort", port);
                        ProxySettings.setSystemProperty("https.proxyHost", host);
                        ProxySettings.setSystemProperty("https.proxyPort", port);
                        if (user != null && pass != null) {
                            try {
                                Authenticator.setDefault(ProxySettings.createAuthenticator(user, pass));
                            }
                            catch (SecurityException ignore) {
                                LOG.error("Failed to set new Proxy Authenticator.");
                            }
                        }
                        ProxySearch ps = new ProxySearch();
                        ps.addStrategy(ProxySearch.Strategy.JAVA);
                        selector = ps.getProxySelector();
                    } else {
                        boolean valid = true;
                        if (validate != null) {
                            valid = Boolean.parseBoolean(validate);
                        }
                        HttpConnectProxy proxy = new HttpConnectProxy(scheme, valid, host, Integer.parseInt(port), user, pass);
                        selector = new SingleProxySelector(proxy);
                    }
                    List<Pattern> exclusions = ProxySettings.parseExclusionHosts(excl);
                    selector = new RegexProxySelector(selector, exclusions);
                }
                catch (NumberFormatException ex) {
                    LOG.error("Invalid port specified for HTTPS proxy, using system defaults.");
                }
                break;
            }
            case "NO PROXY": {
                selector = new NoProxySelector();
                break;
            }
            default: {
                ProxySelector ps;
                if (!"SYSTEM PROXY".equals(scheme)) {
                    LOG.warn("Unsupported proxy scheme {} used.", (Object)scheme);
                }
                List<Proxy> proxies = (ps = ProxySearch.getDefaultProxySearch().getProxySelector()) != null ? ps.select(URI.create("https://google.com/")) : Collections.EMPTY_LIST;
                ProxySettings.setSocksProperties(proxies);
                ProxySettings.setHttpProperties(proxies);
                selector = new UpdatingProxySelector(new SelectorSupplier(){

                    @Override
                    public ProxySelector find() {
                        ProxySearch ps = ProxySearch.getDefaultProxySearch();
                        ProxySelector selector = ps.getProxySelector();
                        return selector;
                    }
                });
            }
        }
        ProxySelector.setDefault(selector);
    }

    public static List<Pattern> parseExclusionHosts(@Nullable String excl) {
        List<String> exclStrs = ProxySettings.tokenizeExclusionHosts(excl);
        ArrayList<Pattern> result = new ArrayList<Pattern>(exclStrs.size());
        for (String next : exclStrs) {
            try {
                Pattern p = ProxySettings.createPattern(next);
                result.add(p);
            }
            catch (PatternSyntaxException ex) {
                LOG.error("Failed to parse proxy exclusion pattern '{}'.", (Object)next);
            }
        }
        return result;
    }

    private static List<String> tokenizeExclusionHosts(@Nullable String excl) {
        if (excl == null) {
            return Collections.emptyList();
        }
        try (Scanner s = new Scanner(excl).useDelimiter(";");){
            ArrayList<String> exclStrs = new ArrayList<String>();
            while (s.hasNext()) {
                String next = s.next().trim();
                if (next.isEmpty()) continue;
                exclStrs.add(next);
            }
            ArrayList<String> arrayList = exclStrs;
            return arrayList;
        }
    }

    private static void clearSystemProperties() {
        ProxySettings.clearSystemProperty("http.proxyHost");
        ProxySettings.clearSystemProperty("http.proxyPort");
        ProxySettings.clearSystemProperty("https.proxyHost");
        ProxySettings.clearSystemProperty("https.proxyPort");
        ProxySettings.clearSystemProperty("http.nonProxyHosts");
        ProxySettings.clearSystemProperty("ftp.proxyHost");
        ProxySettings.clearSystemProperty("ftp.proxyPort");
        ProxySettings.clearSystemProperty("ftp.nonProxyHosts");
        ProxySettings.clearSystemProperty("socksProxyHost");
        ProxySettings.clearSystemProperty("socksProxyPort");
        ProxySettings.clearSystemProperty("socksProxyVersion");
        ProxySettings.clearSystemProperty("java.net.socks.username");
        ProxySettings.clearSystemProperty("java.net.socks.password");
        ProxySettings.clearSystemProperty("java.net.useSystemProxies");
        try {
            Authenticator.setDefault(null);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static void clearSystemProperty(@Nonnull String key) throws IllegalArgumentException {
        try {
            System.clearProperty(key);
        }
        catch (SecurityException ex) {
            LOG.warn("Failed to clear system property '{}'.", (Object)key);
        }
    }

    private static void setSystemProperty(@Nonnull String key, @Nullable String value) {
        if (value != null) {
            try {
                System.setProperty(key, value);
            }
            catch (SecurityException ex) {
                LOG.warn("Failed to set system property '{}'.", (Object)key);
            }
        }
    }

    private static void setSocksProperties(List<Proxy> proxies) {
        InetSocketAddress addr = ProxySettings.getProxyAddress(Proxy.Type.SOCKS, proxies);
        if (addr != null) {
            LOG.debug("Setting proxy properties to SOCKS@{}", (Object)addr);
            ProxySettings.setSystemProperty("socksProxyHost", addr.getHostString());
            if (addr.getPort() > 0) {
                ProxySettings.setSystemProperty("socksProxyPort", Integer.toString(addr.getPort()));
            }
            ProxySettings.setSystemProperty("socksProxyVersion", "5");
        }
    }

    private static void setHttpProperties(List<Proxy> proxies) {
        InetSocketAddress addr = ProxySettings.getProxyAddress(Proxy.Type.SOCKS, proxies);
        if (addr != null) {
            LOG.debug("Setting proxy properties to HTTP@{}", (Object)addr);
            ProxySettings.setSystemProperty("http.proxyHost", addr.getHostString());
            if (addr.getPort() > 0) {
                ProxySettings.setSystemProperty("http.proxyPort", Integer.toString(addr.getPort()));
            }
        }
    }

    @Nullable
    private static InetSocketAddress getProxyAddress(Proxy.Type type, List<Proxy> proxies) {
        Object addr = null;
        for (Proxy next : proxies) {
            SocketAddress sa;
            if (next.type() != Proxy.Type.SOCKS || !((sa = next.address()) instanceof InetSocketAddress)) continue;
            return (InetSocketAddress)sa;
        }
        return null;
    }

    private static Authenticator createAuthenticator(final @Nonnull String user, final @Nonnull String pass) {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String prot = this.getRequestingProtocol().toLowerCase();
                    String host = System.getProperty(prot + ".proxyHost", "");
                    String port = System.getProperty(prot + ".proxyPort", "80");
                    if (this.getRequestingHost().equalsIgnoreCase(host) && Integer.parseInt(port) == this.getRequestingPort()) {
                        return new PasswordAuthentication(user, pass.toCharArray());
                    }
                }
                return null;
            }
        };
    }

    private static Pattern createPattern(String expr) throws PatternSyntaxException {
        String port;
        String host;
        String[] hostPort = expr.split(":");
        if (hostPort.length == 1) {
            host = hostPort[0];
            port = "(:*)?";
        } else {
            host = hostPort[0];
            port = ":" + hostPort[1];
        }
        return Pattern.compile(ProxySettings.replaceMetaChars("^" + host + port + "$"));
    }

    private static String replaceMetaChars(String expr) {
        String result = expr.replace(".", "\\.");
        result = result.replace("*", ".*?");
        return result;
    }

    public ProxySettings(@Nonnull ProxySelector selector) {
        this.selector = selector;
    }

    public static ProxySettings getDefault() {
        return new ProxySettings(ProxySelector.getDefault());
    }

    private Proxy getProxy(String protocol, String hostname, int port) throws URISyntaxException {
        Proxy p = Proxy.NO_PROXY;
        URI uri = new URI(protocol + "://" + hostname + ":" + port);
        List<Proxy> proxies = this.selector.select(uri);
        for (Proxy next : proxies) {
            if (next.type() == Proxy.Type.DIRECT) continue;
            p = proxies.get(0);
            break;
        }
        LOG.debug("Selecting proxy: {}", (Object)p);
        return p;
    }

    public Socket getSocket(String protocol, String hostname, int port) throws IOException, URISyntaxException {
        Proxy p = this.getProxy(protocol, hostname, port);
        Socket sock = new Socket(p);
        InetSocketAddress addr = p.type() == Proxy.Type.DIRECT ? new InetSocketAddress(hostname, port) : InetSocketAddress.createUnresolved(hostname, port);
        sock.setKeepAlive(true);
        sock.setSoTimeout(300000);
        sock.connect(addr, 60000);
        return sock;
    }

    static {
        com.github.markusbernhardt.proxy.util.Logger.setBackend(new Logger.LogBackEnd(){
            private final HashMap<Class<?>, Logger> loggerCache = new HashMap();

            private synchronized Logger getLogger(Class<?> clazz) {
                Logger l = this.loggerCache.get(clazz);
                if (l == null) {
                    l = LoggerFactory.getLogger(clazz);
                    this.loggerCache.put(clazz, l);
                }
                return l;
            }

            @Override
            public void log(Class<?> clazz, Logger.LogLevel logLevel, String msg, Object ... params) {
                Logger l = this.getLogger(clazz);
                switch (logLevel) {
                    case TRACE: {
                        l.trace(msg, params);
                        break;
                    }
                    case DEBUG: {
                        l.debug(msg, params);
                        break;
                    }
                    case INFO: {
                        l.info(msg, params);
                        break;
                    }
                    case WARNING: {
                        l.warn(msg, params);
                        break;
                    }
                    case ERROR: {
                        l.error(msg, params);
                    }
                }
            }

            @Override
            public boolean isLogginEnabled(Logger.LogLevel logLevel) {
                return true;
            }
        });
        ProxySettings.load();
    }
}

