/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.bouncycastle.tls.crypto.TlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.openecard.bouncycastle.util.encoders.Base64;
import org.openecard.crypto.common.ReusableSecureRandom;
import org.openecard.crypto.tls.CertificateVerifier;
import org.openecard.crypto.tls.ClientCertDefaultTlsClient;
import org.openecard.crypto.tls.SocketWrapper;
import org.openecard.crypto.tls.auth.DynamicAuthentication;
import org.openecard.crypto.tls.proxy.HttpConnectProxyException;
import org.openecard.crypto.tls.verify.CertificateVerifierBuilder;
import org.openecard.crypto.tls.verify.HostnameVerifier;
import org.openecard.crypto.tls.verify.JavaSecVerifier;
import org.openecard.crypto.tls.verify.KeyLengthVerifier;

public final class HttpConnectProxy
extends Proxy {
    private final String proxyScheme;
    private final boolean proxyValidate;
    private final String proxyHost;
    private final int proxyPort;
    private final String proxyUser;
    private final String proxyPass;

    public HttpConnectProxy(@Nonnull String proxyScheme, boolean proxyValidate, @Nonnull String proxyHost, @Nonnegative int proxyPort, @Nullable String proxyUser, @Nullable String proxyPass) {
        super(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
        this.proxyScheme = proxyScheme;
        this.proxyValidate = proxyValidate;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUser = proxyUser;
        this.proxyPass = proxyPass;
    }

    @Nonnull
    public Socket getSocket(@Nonnull String host, @Nonnegative int port) throws IOException {
        Socket sock = this.connectSocket();
        String requestStr = this.makeRequestStr(host, port);
        sock.getOutputStream().write(requestStr.getBytes());
        InputStream in = sock.getInputStream();
        String proxyResponse = this.getResponse(in);
        this.validateResponse(proxyResponse);
        if (in.available() > 0) {
            in.skip(in.available());
        }
        return sock;
    }

    private Socket connectSocket() throws IOException {
        Socket sock = new Socket();
        InetSocketAddress addr = new InetSocketAddress(this.proxyHost, this.proxyPort);
        sock.setKeepAlive(true);
        sock.setSoTimeout(300000);
        sock.connect(addr, 60000);
        if ("HTTPS".equals(this.proxyScheme)) {
            BcTlsCrypto crypto = new BcTlsCrypto(ReusableSecureRandom.getInstance());
            ClientCertDefaultTlsClient tlsClient = new ClientCertDefaultTlsClient((TlsCrypto)crypto, this.proxyHost, true);
            DynamicAuthentication tlsAuth = new DynamicAuthentication(this.proxyHost);
            if (this.proxyValidate) {
                CertificateVerifier cv = new CertificateVerifierBuilder().and(new HostnameVerifier()).and(new KeyLengthVerifier()).and(new JavaSecVerifier()).build();
                tlsAuth.setCertificateVerifier(cv);
            }
            tlsClient.setAuthentication(tlsAuth);
            TlsClientProtocol proto = new TlsClientProtocol(sock.getInputStream(), sock.getOutputStream());
            proto.connect(tlsClient);
            SocketWrapper tlsSock = new SocketWrapper(sock, proto.getInputStream(), proto.getOutputStream());
            return tlsSock;
        }
        return sock;
    }

    private String makeRequestStr(String host, int port) {
        StringBuilder requestStr = new StringBuilder(1024);
        requestStr.append("CONNECT ").append(host).append(":").append(port).append(" HTTP/1.0\r\n");
        if (this.proxyUser != null && !this.proxyUser.isEmpty() && this.proxyPass != null && !this.proxyPass.isEmpty()) {
            String proxyUserPass = String.format("%s:%s", this.proxyUser, this.proxyPass);
            proxyUserPass = Base64.toBase64String(proxyUserPass.getBytes());
            requestStr.append("Proxy-Authorization: Basic ").append(proxyUserPass).append("\r\n");
        }
        requestStr.append("\r\n");
        return requestStr.toString();
    }

    private String getResponse(InputStream in) throws IOException {
        byte[] tmpBuffer = new byte[512];
        int len = in.read(tmpBuffer, 0, tmpBuffer.length);
        if (len == 0) {
            throw new SocketException("Invalid response from proxy.");
        }
        String proxyResponse = new String(tmpBuffer, 0, len, "UTF-8");
        return proxyResponse;
    }

    private void validateResponse(String response) throws IOException {
        Pattern p = Pattern.compile("HTTP/1\\.(1|0) (\\d{3}) (.*)\\r\\n(?s).*");
        Matcher m = p.matcher(response);
        if (m.matches()) {
            String code = m.group(2);
            String desc = m.group(3);
            int codeNum = Integer.parseInt(code);
            if (codeNum != 200) {
                throw new HttpConnectProxyException("Failed to create proxy socket.", codeNum, desc);
            }
        } else {
            throw new HttpConnectProxyException("Invalid HTTP response from proxy.", 500, "Response malformed.");
        }
    }
}

