/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.auth;

import iso.std.iso_iec._24727.tech.schema.AlgorithmInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.io.IOException;
import java.io.StringWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import org.openecard.bouncycastle.asn1.x500.X500Name;
import org.openecard.bouncycastle.tls.Certificate;
import org.openecard.bouncycastle.tls.CertificateRequest;
import org.openecard.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.TlsContext;
import org.openecard.bouncycastle.tls.TlsCredentialedSigner;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;
import org.openecard.bouncycastle.tls.crypto.TlsCrypto;
import org.openecard.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.openecard.bouncycastle.util.io.pem.PemObject;
import org.openecard.bouncycastle.util.io.pem.PemWriter;
import org.openecard.common.SecurityConditionUnsatisfiable;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.crypto.common.HashAlgorithms;
import org.openecard.crypto.common.KeyTypes;
import org.openecard.crypto.common.SignatureAlgorithms;
import org.openecard.crypto.common.UnsupportedAlgorithmException;
import org.openecard.crypto.common.sal.did.DataSetInfo;
import org.openecard.crypto.common.sal.did.DidInfo;
import org.openecard.crypto.common.sal.did.DidInfos;
import org.openecard.crypto.common.sal.did.NoSuchDid;
import org.openecard.crypto.common.sal.did.TokenCache;
import org.openecard.crypto.tls.auth.ContextAware;
import org.openecard.crypto.tls.auth.CredentialFactory;
import org.openecard.crypto.tls.auth.SmartCardSignerCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardCredentialFactory
implements CredentialFactory,
ContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SmartCardCredentialFactory.class);
    private final TokenCache tokenCache;
    private final ConnectionHandleType handle;
    private final boolean filterAlwaysReadable;
    private TlsContext context;

    public SmartCardCredentialFactory(@Nonnull Dispatcher dispatcher, @Nonnull ConnectionHandleType handle, boolean filterAlwaysReadable) {
        this.tokenCache = new TokenCache(dispatcher);
        this.handle = handle;
        this.filterAlwaysReadable = filterAlwaysReadable;
    }

    @Override
    public void setContext(TlsContext context) {
        this.context = context;
    }

    @Override
    public List<TlsCredentialedSigner> getClientCredentials(CertificateRequest cr) {
        ArrayList<TlsCredentialedSigner> credentials = new ArrayList<TlsCredentialedSigner>();
        TlsCryptoParameters tlsCrypto = new TlsCryptoParameters(this.context);
        try {
            DidInfos didInfos = this.tokenCache.getInfo(null, this.handle);
            List<DidInfo> infos = didInfos.getCryptoDidInfos();
            for (DidInfo info : infos) {
                try {
                    DefaultTlsCredentialedSigner cred;
                    if (this.filterAlwaysReadable && this.isCertNeedsPin(info)) continue;
                    List<X509Certificate> chain = info.getRelatedCertificateChain();
                    if (LOG.isDebugEnabled()) {
                        for (X509Certificate cert : chain) {
                            StringWriter out = new StringWriter();
                            PemWriter pw = new PemWriter(out);
                            pw.writeObject(new PemObject("CERTIFICATE", cert.getEncoded()));
                            pw.close();
                            LOG.debug("Certificate for DID {}\n{}", (Object)info.getDidName(), (Object)out);
                            LOG.debug("Certificate details\n{}", (Object)cert);
                        }
                    }
                    Certificate clientCert = this.convertCert(this.context.getCrypto(), chain);
                    if (!this.matchesCertReq(cr, chain) || !this.isAuthCert(info, chain)) continue;
                    if (cr.getSupportedSignatureAlgorithms() == null) {
                        if (!this.isRawRSA(info)) continue;
                        LOG.debug("Adding raw RSA signer.");
                        SmartCardSignerCredential signer = new SmartCardSignerCredential(info);
                        cred = new DefaultTlsCredentialedSigner(tlsCrypto, signer, clientCert, null);
                        credentials.add(cred);
                        continue;
                    }
                    for (Object algObj : cr.getSupportedSignatureAlgorithms()) {
                        AlgorithmInfoType algInfo;
                        SignatureAlgorithms alg;
                        SignatureAndHashAlgorithm reqAlg = (SignatureAndHashAlgorithm)algObj;
                        if (!this.matchesAlg(reqAlg, alg = SignatureAlgorithms.fromAlgId((algInfo = info.getGenericCryptoMarker().getAlgorithmInfo()).getAlgorithmIdentifier().getAlgorithm()))) continue;
                        LOG.debug("Adding {} signer.", (Object)alg.getJcaAlg());
                        SmartCardSignerCredential signer = new SmartCardSignerCredential(info);
                        cred = new DefaultTlsCredentialedSigner(tlsCrypto, signer, clientCert, reqAlg);
                        credentials.add(cred);
                    }
                }
                catch (IOException | CertificateException | SecurityConditionUnsatisfiable | NoSuchDid ex) {
                    LOG.error("Failed to read certificates from card. Skipping DID " + info.getDidName() + ".", ex);
                }
                catch (UnsupportedAlgorithmException ex) {
                    LOG.error("Unsupported algorithm used in CIF. Skipping DID " + info.getDidName() + ".", ex);
                }
                catch (WSHelper.WSException ex) {
                    LOG.error("Unknown error accessing DID " + info.getDidName() + ".", ex);
                }
            }
        }
        catch (WSHelper.WSException | NoSuchDid ex) {
            LOG.error("Failed to access DIDs of smartcard. Proceeding without client authentication.", ex);
        }
        return credentials;
    }

    private boolean isCertNeedsPin(DidInfo info) throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        boolean needsPin = false;
        List<DataSetInfo> dsis = info.getRelatedDataSets();
        for (DataSetInfo dsi : dsis) {
            needsPin = needsPin && dsi.needsPin();
        }
        return needsPin;
    }

    private boolean matchesCertReq(CertificateRequest cr, List<X509Certificate> chain) {
        if (cr.getCertificateAuthorities().isEmpty()) {
            LOG.debug("Any certificate matches.");
            return true;
        }
        for (Object issuerObj : cr.getCertificateAuthorities()) {
            try {
                X500Name issuer = (X500Name)issuerObj;
                X500Principal reqIss = new X500Principal(issuer.getEncoded("DER"));
                for (X509Certificate cert : chain) {
                    if (!cert.getIssuerX500Principal().equals(reqIss)) continue;
                    LOG.debug("Issuer {} matched one of the certificate issuers.", (Object)issuer);
                    return true;
                }
            }
            catch (IOException ex) {
                LOG.error("Unencodable issuer in requested authorities. Skipping entry.");
            }
        }
        LOG.debug("No issuer matches.");
        return false;
    }

    private boolean isAuthCert(DidInfo info, List<X509Certificate> chain) throws WSHelper.WSException {
        AlgorithmInfoType algInfo = info.getGenericCryptoMarker().getAlgorithmInfo();
        if (!algInfo.getSupportedOperations().contains("Compute-signature")) {
            LOG.debug("DID ({}): AlgorithmInfo does not provide Compute-signature flag.", (Object)info.getDidName());
            return false;
        }
        X509Certificate cert = chain.get(0);
        boolean isAuthCert = cert.getKeyUsage()[0];
        boolean isSigCert = cert.getKeyUsage()[1];
        if (!isAuthCert || isSigCert) {
            LOG.debug("DID ({}): Certificate key usage does not permit authentication signatures.", (Object)info.getDidName());
            return false;
        }
        return true;
    }

    private boolean matchesAlg(SignatureAndHashAlgorithm reqAlg, SignatureAlgorithms alg) {
        switch (alg) {
            case CKM_ECDSA_SHA1: 
            case CKM_ECDSA_SHA224: 
            case CKM_ECDSA_SHA256: 
            case CKM_ECDSA_SHA384: 
            case CKM_ECDSA_SHA512: 
            case CKM_RSA_PKCS: 
            case CKM_SHA1_RSA_PKCS: 
            case CKM_SHA224_RSA_PKCS: 
            case CKM_SHA256_RSA_PKCS: 
            case CKM_SHA384_RSA_PKCS: 
            case CKM_SHA512_RSA_PKCS: {
                break;
            }
            default: {
                return false;
            }
        }
        try {
            SignatureAndHashAlgorithm bcAlg = SmartCardCredentialFactory.convertSignatureAlgorithm(alg);
            if (bcAlg == null) {
                if (reqAlg.getSignature() == 1) {
                    switch (reqAlg.getHash()) {
                        case 2: 
                        case 3: 
                        case 4: {
                            return true;
                        }
                    }
                }
                return false;
            }
            return reqAlg.equals(bcAlg);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private boolean isRawRSA(DidInfo info) throws WSHelper.WSException, UnsupportedAlgorithmException {
        AlgorithmInfoType algInfo = info.getGenericCryptoMarker().getAlgorithmInfo();
        SignatureAlgorithms alg = SignatureAlgorithms.fromAlgId(algInfo.getAlgorithmIdentifier().getAlgorithm());
        return SignatureAlgorithms.CKM_RSA_PKCS == alg;
    }

    @Nullable
    private static SignatureAndHashAlgorithm convertSignatureAlgorithm(SignatureAlgorithms alg) {
        short sig;
        short hash;
        KeyTypes keyType;
        block12: {
            block11: {
                HashAlgorithms hashAlg = alg.getHashAlg();
                keyType = alg.getKeyType();
                if (hashAlg == null) break block11;
                switch (hashAlg) {
                    case CKM_SHA_1: {
                        hash = 2;
                        break block12;
                    }
                    case CKM_SHA224: {
                        hash = 3;
                        break block12;
                    }
                    case CKM_SHA256: {
                        hash = 4;
                        break block12;
                    }
                    case CKM_SHA384: {
                        hash = 5;
                        break block12;
                    }
                    case CKM_SHA512: {
                        hash = 6;
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported hash algorithm selected.");
                    }
                }
            }
            return null;
        }
        switch (keyType) {
            case CKK_RSA: {
                sig = 1;
                break;
            }
            case CKK_EC: {
                sig = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported signature algorithm selected.");
            }
        }
        return new SignatureAndHashAlgorithm(hash, sig);
    }

    private Certificate convertCert(TlsCrypto crypto, List<X509Certificate> chain) throws IOException, CertificateEncodingException {
        TlsCertificate cert = crypto.createCertificate(chain.get(0).getEncoded());
        return new Certificate(new TlsCertificate[]{cert});
    }
}

