/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls.auth;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.tls.CertificateRequest;
import org.openecard.bouncycastle.tls.TlsAuthentication;
import org.openecard.bouncycastle.tls.TlsContext;
import org.openecard.bouncycastle.tls.TlsCredentialedSigner;
import org.openecard.bouncycastle.tls.TlsCredentials;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.crypto.tls.CertificateVerifier;
import org.openecard.crypto.tls.auth.ContextAware;
import org.openecard.crypto.tls.auth.CredentialFactory;
import org.openecard.crypto.tls.verify.CertificateVerifierBuilder;
import org.openecard.crypto.tls.verify.ExpirationVerifier;
import org.openecard.crypto.tls.verify.HostnameVerifier;
import org.openecard.crypto.tls.verify.KeyLengthVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicAuthentication
implements TlsAuthentication,
ContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicAuthentication.class);
    private String hostname;
    private CertificateVerifier certVerifier;
    private CredentialFactory credentialFactory;
    private TlsServerCertificate lastCertChain;
    private TlsContext context;

    public DynamicAuthentication(@Nonnull String hostName) {
        this(hostName, new CertificateVerifierBuilder().and(new HostnameVerifier()).and(new KeyLengthVerifier()).and(new ExpirationVerifier()).build(), null);
    }

    public DynamicAuthentication(@Nonnull String hostName, @Nullable CertificateVerifier certVerifier, @Nullable CredentialFactory credentialFactory) {
        this.hostname = hostName;
        this.certVerifier = certVerifier;
        this.credentialFactory = credentialFactory;
    }

    @Override
    public void setContext(TlsContext context) {
        this.context = context;
    }

    public void setHostname(@Nonnull String hostname) {
        this.hostname = hostname;
    }

    public void setCertificateVerifier(CertificateVerifier certVerifier) {
        this.certVerifier = certVerifier;
    }

    public void addCertificateVerifier(@Nonnull CertificateVerifier certVerifier) {
        CertificateVerifierBuilder builder = new CertificateVerifierBuilder();
        if (this.certVerifier != null) {
            builder = builder.and(this.certVerifier);
        }
        this.certVerifier = builder.and(certVerifier).build();
    }

    public void setCredentialFactory(@Nullable CredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
    }

    @Override
    public void notifyServerCertificate(TlsServerCertificate serverCert) throws IOException {
        boolean noServerCert;
        boolean bl = noServerCert = serverCert == null || serverCert.getCertificate() == null || serverCert.getCertificate().isEmpty();
        if (noServerCert) {
            throw new TlsFatalAlert(40);
        }
        this.lastCertChain = serverCert;
        if (this.certVerifier != null) {
            this.certVerifier.isValid(serverCert, this.hostname);
        } else {
            LOG.warn("No certificate verifier available, skipping certificate verification.");
        }
    }

    @Override
    public TlsCredentials getClientCredentials(CertificateRequest cr) {
        if (this.credentialFactory != null) {
            List<TlsCredentialedSigner> credentials;
            if (this.credentialFactory instanceof ContextAware) {
                ((ContextAware)((Object)this.credentialFactory)).setContext(this.context);
            }
            if (!(credentials = this.credentialFactory.getClientCredentials(cr)).isEmpty()) {
                TlsCredentials cred = credentials.get(0);
                if (cred instanceof ContextAware) {
                    ((ContextAware)((Object)cred)).setContext(this.context);
                }
                return cred;
            }
        }
        return null;
    }

    @Nullable
    public TlsServerCertificate getServerCertificate() {
        return this.lastCertChain;
    }
}

