/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.tls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.bouncycastle.tls.DefaultTlsClient;
import org.openecard.bouncycastle.tls.ProtocolVersion;
import org.openecard.bouncycastle.tls.ServerName;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.TlsAuthentication;
import org.openecard.bouncycastle.tls.TlsClientContext;
import org.openecard.bouncycastle.tls.TlsDHUtils;
import org.openecard.bouncycastle.tls.TlsECCUtils;
import org.openecard.bouncycastle.tls.TlsExtensionsUtils;
import org.openecard.bouncycastle.tls.TlsSession;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsCrypto;
import org.openecard.common.OpenecardProperties;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.tls.ClientCertTlsClient;
import org.openecard.crypto.tls.TlsError;
import org.openecard.crypto.tls.auth.ContextAware;
import org.openecard.crypto.tls.auth.DynamicAuthentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertDefaultTlsClient
extends DefaultTlsClient
implements ClientCertTlsClient {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCertDefaultTlsClient.class);
    private final String host;
    private TlsAuthentication tlsAuth;
    private boolean enforceSameSession = false;
    private TlsSession firstSession;
    private TlsSession lastSession;
    protected List<ServerName> serverNames;
    protected ProtocolVersion clientVersion = ProtocolVersion.TLSv12;
    protected ProtocolVersion minClientVersion = ProtocolVersion.TLSv10;

    public ClientCertDefaultTlsClient(@Nonnull TlsCrypto tcf, @Nullable String host, boolean doSni) {
        super(tcf);
        boolean tls1;
        if (doSni) {
            this.serverNames = Collections.singletonList(this.makeServerName(host));
        }
        this.minClientVersion = (tls1 = Boolean.valueOf(OpenecardProperties.getProperty("legacy.tls1")).booleanValue()) ? ProtocolVersion.TLSv10 : ProtocolVersion.TLSv11;
        this.host = host;
    }

    public void setServerName(@Nonnull String serverName) {
        this.serverNames = Collections.singletonList(this.makeServerName(serverName));
    }

    public void setServerNames(@Nonnull List<String> serverNames) {
        this.serverNames = new ArrayList<ServerName>();
        for (String next : serverNames) {
            this.serverNames.add(this.makeServerName(next));
        }
    }

    @Override
    protected Vector getSNIServerNames() {
        return this.serverNames != null ? new Vector<ServerName>(this.serverNames) : null;
    }

    private ServerName makeServerName(String name) {
        return new ServerName(0, name);
    }

    @Override
    public ProtocolVersion getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void setClientVersion(ProtocolVersion version) {
        this.clientVersion = version;
    }

    @Override
    public void setMinimumVersion(ProtocolVersion minClientVersion) {
        this.minClientVersion = minClientVersion;
    }

    @Override
    public ProtocolVersion getMinimumVersion() {
        return this.minClientVersion;
    }

    public void setEnforceSameSession(boolean enforceSameSession) {
        this.enforceSameSession = enforceSameSession;
    }

    @Override
    public synchronized TlsAuthentication getAuthentication() throws IOException {
        if (this.tlsAuth == null) {
            this.tlsAuth = new DynamicAuthentication(this.host);
        }
        if (this.tlsAuth instanceof ContextAware) {
            ((ContextAware)((Object)this.tlsAuth)).setContext(this.context);
        }
        return this.tlsAuth;
    }

    @Override
    public synchronized void setAuthentication(TlsAuthentication tlsAuth) {
        this.tlsAuth = tlsAuth;
    }

    @Override
    public void init(TlsClientContext context) {
        if (this.enforceSameSession && this.firstSession == null && this.lastSession != null) {
            this.firstSession = this.lastSession;
        }
        super.init(context);
    }

    @Override
    public int[] getCipherSuites() {
        ArrayList<Integer> ciphers = new ArrayList<Integer>(Arrays.asList(49196, 49200, 159, 49188, 49192, 107, 49195, 49199, 158, 49187, 49191, 103));
        if (this.minClientVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv11)) {
            ciphers.addAll(Arrays.asList(49162, 49172, 57, 49161, 49171, 51));
        }
        Iterator<Integer> it = ciphers.iterator();
        while (it.hasNext()) {
            Integer cipher = it.next();
            if (TlsUtils.isValidCipherSuiteForVersion(cipher, this.clientVersion)) continue;
            it.remove();
        }
        int[] result = new int[ciphers.size()];
        for (int i = 0; i < ciphers.size(); ++i) {
            result[i] = ciphers.get(i);
        }
        return result;
    }

    @Override
    protected Vector getSupportedSignatureAlgorithms() {
        boolean weakCrypto = Boolean.valueOf(OpenecardProperties.getProperty("legacy.weak_crypto"));
        TlsCrypto crypto = this.context.getCrypto();
        short[] hashAlgorithms = !weakCrypto ? new short[]{6, 5, 4, 3} : new short[]{6, 5, 4, 3, 2};
        short[] signatureAlgorithms = new short[]{1, 3};
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>();
        for (int i = 0; i < signatureAlgorithms.length; ++i) {
            for (int j = 0; j < hashAlgorithms.length; ++j) {
                SignatureAndHashAlgorithm alg = new SignatureAndHashAlgorithm(hashAlgorithms[j], signatureAlgorithms[i]);
                if (!crypto.hasSignatureAndHashAlgorithm(alg)) continue;
                result.addElement(alg);
            }
        }
        return result;
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = super.getClientExtensions();
        clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(clientExtensions);
        Vector<Integer> supportedGroups = new Vector<Integer>();
        if (TlsECCUtils.containsECCipherSuites(this.getCipherSuites())) {
            supportedGroups.add(28);
            supportedGroups.add(27);
            supportedGroups.add(24);
            supportedGroups.add(26);
            supportedGroups.add(23);
            supportedGroups.add(21);
            this.clientECPointFormats = new short[]{1, 0};
            TlsECCUtils.addSupportedPointFormatsExtension(clientExtensions, this.clientECPointFormats);
        }
        if (TlsDHUtils.containsDHECipherSuites(this.getCipherSuites())) {
            supportedGroups.addElement(256);
            supportedGroups.addElement(257);
            supportedGroups.addElement(258);
            supportedGroups.addElement(259);
            supportedGroups.addElement(260);
        }
        if (!supportedGroups.isEmpty()) {
            this.supportedGroups = supportedGroups;
            TlsExtensionsUtils.addSupportedGroupsExtension(clientExtensions, supportedGroups);
        }
        return clientExtensions;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        TlsError error = new TlsError(alertLevel, alertDescription, message, cause);
        if (alertLevel == 1 && LOG.isInfoEnabled()) {
            LOG.info("TLS warning sent.");
            if (LOG.isDebugEnabled()) {
                LOG.info(error.toString(), cause);
            } else {
                LOG.info(error.toString());
            }
        } else if (alertLevel == 2) {
            LOG.error("TLS error sent.");
            LOG.error(error.toString(), cause);
        }
        super.notifyAlertRaised(alertLevel, alertDescription, message, cause);
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        TlsError error = new TlsError(alertLevel, alertDescription);
        if (alertLevel == 1 && LOG.isInfoEnabled()) {
            LOG.info("TLS warning received.");
            LOG.info(error.toString());
        } else if (alertLevel == 2) {
            LOG.error("TLS error received.");
            LOG.error(error.toString());
        }
        super.notifyAlertReceived(alertLevel, alertDescription);
    }

    @Override
    public TlsSession getSessionToResume() {
        if (this.firstSession != null) {
            return this.firstSession;
        }
        return super.getSessionToResume();
    }

    @Override
    public void notifySessionID(byte[] sessionID) {
        if (this.enforceSameSession) {
            TlsSession s = this.getSessionToResume();
            if (s != null && ByteUtils.compare(s.getSessionID(), sessionID)) {
                LOG.info("Trying to resume previous TLS session.");
                return;
            }
            String msg = "TLS Session resumption not successful.";
            LOG.error(msg);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        TlsSession tlsSession = this.lastSession = this.context != null ? this.context.getResumableSession() : null;
        if (this.lastSession != null) {
            this.lastSession = TlsUtils.importSession(this.lastSession.getSessionID(), this.lastSession.exportSessionParameters());
        }
        super.notifyHandshakeComplete();
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
    }
}

