/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal.did;

import iso.std.iso_iec._24727.tech.schema.CardApplicationList;
import iso.std.iso_iec._24727.tech.schema.CardApplicationListResponse;
import iso.std.iso_iec._24727.tech.schema.CardApplicationSelect;
import iso.std.iso_iec._24727.tech.schema.CardApplicationSelectResponse;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.DIDList;
import iso.std.iso_iec._24727.tech.schema.DIDListResponse;
import iso.std.iso_iec._24727.tech.schema.DIDQualifierType;
import iso.std.iso_iec._24727.tech.schema.DataSetList;
import iso.std.iso_iec._24727.tech.schema.DataSetListResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetNameListType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openecard.common.WSHelper;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.ByteComparator;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.HandlerUtils;
import org.openecard.crypto.common.sal.did.DataSetInfo;
import org.openecard.crypto.common.sal.did.DidInfo;
import org.openecard.crypto.common.sal.did.NoSuchDataSet;
import org.openecard.crypto.common.sal.did.NoSuchDid;

public class DidInfos {
    private final Dispatcher dispatcher;
    @Nullable
    private char[] pin;
    private ConnectionHandleType handle;
    private List<byte[]> applications;
    private Map<byte[], List<String>> allDidNames;
    private Map<byte[], Map<String, DidInfo>> cachedDids;
    private Map<byte[], Map<String, DataSetInfo>> cachedDataSets;

    public DidInfos(@Nonnull Dispatcher dispatcher, @Nullable char[] pin, @Nonnull ConnectionHandleType handle) {
        this(dispatcher, pin, handle.getSlotHandle());
    }

    public DidInfos(@Nonnull Dispatcher dispatcher, @Nullable char[] pin, @Nonnull byte[] slotHandle) {
        this.dispatcher = dispatcher;
        if (pin != null) {
            Arrays.fill(this.pin, ' ');
            this.pin = (char[])pin.clone();
        } else {
            this.pin = null;
        }
        this.handle = new ConnectionHandleType();
        this.handle.setSlotHandle(ByteUtils.clone(slotHandle));
        this.cachedDids = new TreeMap<byte[], Map<String, DidInfo>>(new ByteComparator());
        this.cachedDataSets = new TreeMap<byte[], Map<String, DataSetInfo>>(new ByteComparator());
    }

    @Nonnull
    Map<String, DidInfo> getDidCache(@Nonnull byte[] application) {
        Map<String, DidInfo> applicationCache = this.cachedDids.get(application);
        if (applicationCache == null) {
            applicationCache = new HashMap<String, DidInfo>();
            this.cachedDids.put(application, applicationCache);
        }
        return applicationCache;
    }

    @Nonnull
    Map<String, DataSetInfo> getDataSetCache(@Nonnull byte[] application) {
        Map<String, DataSetInfo> applicationCache = this.cachedDataSets.get(application);
        if (applicationCache == null) {
            applicationCache = new HashMap<String, DataSetInfo>();
            this.cachedDataSets.put(application, applicationCache);
        }
        return applicationCache;
    }

    Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    ConnectionHandleType getHandle() {
        return HandlerUtils.copyHandle(this.handle);
    }

    ConnectionHandleType getHandle(@Nullable byte[] application) {
        ConnectionHandleType newHandle = HandlerUtils.copyHandle(this.handle);
        newHandle.setCardApplication(ByteUtils.clone(application));
        return newHandle;
    }

    synchronized List<byte[]> getApplicationsInt() throws WSHelper.WSException {
        if (this.applications == null) {
            CardApplicationList req = new CardApplicationList();
            req.setConnectionHandle(this.getHandle());
            CardApplicationListResponse res = (CardApplicationListResponse)this.dispatcher.safeDeliver(req);
            WSHelper.checkResult(res);
            CardApplicationListResponse.CardApplicationNameList nameList = res.getCardApplicationNameList();
            if (nameList != null) {
                this.applications = Collections.unmodifiableList(nameList.getCardApplicationName());
            }
        }
        return this.applications;
    }

    public void setPin(@Nullable char[] pin) {
        if (pin != null) {
            Arrays.fill(this.pin, ' ');
            this.pin = (char[])pin.clone();
        } else {
            this.pin = null;
        }
    }

    public List<byte[]> getApplications() throws WSHelper.WSException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (byte[] next : this.getApplicationsInt()) {
            result.add(ByteUtils.clone(next));
        }
        return Collections.unmodifiableList(result);
    }

    synchronized Map<byte[], List<String>> getDidNames() throws WSHelper.WSException {
        if (this.allDidNames == null) {
            this.allDidNames = new TreeMap<byte[], List<String>>(new ByteComparator());
            for (byte[] application : this.getApplicationsInt()) {
                try {
                    DIDList req = new DIDList();
                    req.setConnectionHandle(this.getHandle());
                    DIDQualifierType filter = new DIDQualifierType();
                    filter.setApplicationIdentifier(application);
                    req.setFilter(filter);
                    DIDListResponse res = (DIDListResponse)this.dispatcher.safeDeliver(req);
                    WSHelper.checkResult(res);
                    if (res.getDIDNameList() == null) continue;
                    this.allDidNames.put(application, Collections.unmodifiableList(res.getDIDNameList().getDIDName()));
                }
                catch (WSHelper.WSException wSException) {}
            }
            this.allDidNames = Collections.unmodifiableMap(this.allDidNames);
        }
        return this.allDidNames;
    }

    public List<String> getDidNames(byte[] application) throws WSHelper.WSException {
        List<String> result = this.getDidNames().get(application);
        return result != null ? result : Collections.emptyList();
    }

    public List<DidInfo> getDidInfos(byte[] application) throws WSHelper.WSException, NoSuchDid {
        ArrayList<DidInfo> result = new ArrayList<DidInfo>();
        for (String didName : this.getDidNames(application)) {
            result.add(this.getDidInfo(application, didName));
        }
        return Collections.unmodifiableList(result);
    }

    public List<DidInfo> getDidInfos() throws WSHelper.WSException, NoSuchDid {
        ArrayList<DidInfo> result = new ArrayList<DidInfo>();
        HashSet<String> didNames = new HashSet<String>();
        for (Map.Entry<byte[], List<String>> entry : this.getDidNames().entrySet()) {
            for (String didName : entry.getValue()) {
                if (didNames.contains(didName)) continue;
                DidInfo didInfo = this.getDidInfo(entry.getKey(), didName);
                didNames.add(didName);
                result.add(didInfo);
            }
        }
        return result;
    }

    public List<DidInfo> getCryptoDidInfos() throws WSHelper.WSException, NoSuchDid {
        ArrayList<DidInfo> result = new ArrayList<DidInfo>();
        for (DidInfo next : this.getDidInfos()) {
            if (!next.isCryptoDid()) continue;
            result.add(next);
        }
        return result;
    }

    public DidInfo getDidInfo(String name) throws NoSuchDid, WSHelper.WSException {
        for (byte[] application : this.getApplications()) {
            try {
                return this.getDidInfo(application, name);
            }
            catch (NoSuchDid noSuchDid) {
            }
        }
        throw new NoSuchDid("The DID " + name + " does not exist.");
    }

    public DidInfo getDidInfo(byte[] application, String name) throws NoSuchDid, WSHelper.WSException {
        Map<String, DidInfo> appCache = this.getDidCache(application);
        DidInfo result = appCache.get(name);
        if (result == null) {
            List<String> names = this.getDidNames(application);
            for (String next : names) {
                if (!next.equals(name)) continue;
                result = new DidInfo(this, application, name, this.pin);
                appCache.put(name, result);
                return result;
            }
            throw new NoSuchDid("The DID " + name + " does not exist.");
        }
        result.setPin(this.pin);
        return result;
    }

    List<String> getDataSetNames(byte[] application) throws WSHelper.WSException {
        DataSetList req = new DataSetList();
        req.setConnectionHandle(this.getHandle(application));
        DataSetListResponse res = (DataSetListResponse)this.dispatcher.safeDeliver(req);
        WSHelper.checkResult(res);
        DataSetNameListType listWrapper = res.getDataSetNameList();
        List<String> datasetNames = listWrapper != null && listWrapper.getDataSetName() != null ? Collections.unmodifiableList(listWrapper.getDataSetName()) : Collections.emptyList();
        return datasetNames;
    }

    public DataSetInfo getDataSetInfo(byte[] application, String name) throws NoSuchDataSet, WSHelper.WSException {
        Map<String, DataSetInfo> appCache = this.getDataSetCache(application);
        DataSetInfo result = appCache.get(name);
        if (result == null) {
            List<String> names = this.getDataSetNames(application);
            for (String next : names) {
                if (!next.equals(name)) continue;
                result = new DataSetInfo(this, application, name);
                appCache.put(name, result);
                return result;
            }
            throw new NoSuchDataSet("The DataSet " + name + " does not exist.");
        }
        return result;
    }

    public void connectApplication(byte[] application) throws WSHelper.WSException {
        CardApplicationSelect req = new CardApplicationSelect();
        req.setCardApplication(application);
        req.setSlotHandle(this.handle.getSlotHandle());
        CardApplicationSelectResponse res = (CardApplicationSelectResponse)this.dispatcher.safeDeliver(req);
        WSHelper.checkResult(res);
    }

    public void clearPin(byte[] slotHandle) {
        this.setPin(null);
        for (Map.Entry<byte[], Map<String, DidInfo>> e1 : this.cachedDids.entrySet()) {
            if (!ByteUtils.compare(slotHandle, e1.getKey())) continue;
            for (Map.Entry<String, DidInfo> e2 : e1.getValue().entrySet()) {
                e2.getValue().setPin(null);
            }
        }
    }
}

