/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.sal.did;

import iso.std.iso_iec._24727.tech.schema.ACLList;
import iso.std.iso_iec._24727.tech.schema.ACLListResponse;
import iso.std.iso_iec._24727.tech.schema.AccessControlListType;
import iso.std.iso_iec._24727.tech.schema.DIDScopeType;
import iso.std.iso_iec._24727.tech.schema.DIDStructureType;
import iso.std.iso_iec._24727.tech.schema.DSIRead;
import iso.std.iso_iec._24727.tech.schema.DSIReadResponse;
import iso.std.iso_iec._24727.tech.schema.DataSetSelect;
import iso.std.iso_iec._24727.tech.schema.DataSetSelectResponse;
import iso.std.iso_iec._24727.tech.schema.TargetNameType;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.SecurityConditionUnsatisfiable;
import org.openecard.common.WSHelper;
import org.openecard.common.util.ByteUtils;
import org.openecard.crypto.common.sal.did.ACLResolver;
import org.openecard.crypto.common.sal.did.DidInfo;
import org.openecard.crypto.common.sal.did.DidInfos;
import org.openecard.crypto.common.sal.did.NoSuchDid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSetInfo {
    private static final Logger LOG = LoggerFactory.getLogger(DataSetInfo.class);
    private final DidInfos didInfos;
    private final byte[] application;
    private final TargetNameType datasetNameTarget;
    private byte[] cachedData;

    DataSetInfo(DidInfos didInfos, byte[] application, String datasetName) {
        this.didInfos = didInfos;
        this.application = ByteUtils.clone(application);
        this.datasetNameTarget = new TargetNameType();
        this.datasetNameTarget.setDataSetName(datasetName);
    }

    public AccessControlListType getACL() throws WSHelper.WSException {
        ACLList req = new ACLList();
        req.setConnectionHandle(this.didInfos.getHandle(this.application));
        req.setTargetName(this.datasetNameTarget);
        ACLListResponse res = (ACLListResponse)this.didInfos.getDispatcher().safeDeliver(req);
        WSHelper.checkResult(res);
        return res.getTargetACL();
    }

    public List<DidInfo> getMissingDidInfos() throws WSHelper.WSException, SecurityConditionUnsatisfiable, NoSuchDid {
        ArrayList<DidInfo> result = new ArrayList<DidInfo>();
        for (DIDStructureType didStruct : this.getMissingDids()) {
            result.add(this.didInfos.getDidInfo(didStruct.getDIDName()));
        }
        return result;
    }

    public List<DIDStructureType> getMissingDids() throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        ACLResolver resolver = new ACLResolver(this.didInfos.getDispatcher(), this.didInfos.getHandle(this.application));
        List<DIDStructureType> missingDids = resolver.getUnsatisfiedDIDs(this.datasetNameTarget, this.getACL().getAccessRule());
        return missingDids;
    }

    public boolean isPinSufficient() throws WSHelper.WSException {
        try {
            List<DIDStructureType> missingDids = this.getMissingDids();
            for (DIDStructureType missingDid : missingDids) {
                DidInfo infoObj = missingDid.getDIDScope() == DIDScopeType.GLOBAL ? this.didInfos.getDidInfo(missingDid.getDIDName()) : this.didInfos.getDidInfo(this.application, missingDid.getDIDName());
                if (infoObj.isPinDid()) continue;
                return false;
            }
            return true;
        }
        catch (SecurityConditionUnsatisfiable ex) {
            return false;
        }
        catch (NoSuchDid ex) {
            String msg = "DID referenced in CIF could not be resolved.";
            LOG.error(msg, ex);
            throw WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
        }
    }

    public boolean needsPin() throws WSHelper.WSException, SecurityConditionUnsatisfiable {
        try {
            List<DIDStructureType> missingDids = this.getMissingDids();
            for (DIDStructureType missingDid : missingDids) {
                DidInfo infoObj = missingDid.getDIDScope() == DIDScopeType.GLOBAL ? this.didInfos.getDidInfo(missingDid.getDIDName()) : this.didInfos.getDidInfo(this.application, missingDid.getDIDName());
                if (!infoObj.isPinDid()) continue;
                return true;
            }
            return false;
        }
        catch (NoSuchDid ex) {
            String msg = "DID referenced in CIF could not be resolved.";
            LOG.error(msg, ex);
            throw WSHelper.createException(WSHelper.makeResultError("http://www.bsi.bund.de/ecard/api/1.1/resultminor/al/common#internalError", msg));
        }
    }

    public void connectApplication() throws WSHelper.WSException {
        this.didInfos.connectApplication(this.application);
    }

    public void authenticate() throws WSHelper.WSException, SecurityConditionUnsatisfiable, NoSuchDid {
        for (DidInfo nextDid : this.getMissingDidInfos()) {
            if (nextDid.isPinDid()) {
                nextDid.enterPin();
                continue;
            }
            throw new SecurityConditionUnsatisfiable("Only PIN DIDs are supported at the moment.");
        }
    }

    public byte[] read() throws WSHelper.WSException {
        if (this.cachedData == null) {
            this.select();
            DSIRead req = new DSIRead();
            req.setConnectionHandle(this.didInfos.getHandle(this.application));
            req.setDSIName(this.datasetNameTarget.getDataSetName());
            DSIReadResponse res = (DSIReadResponse)this.didInfos.getDispatcher().safeDeliver(req);
            WSHelper.checkResult(res);
            this.cachedData = res.getDSIContent();
        }
        return ByteUtils.clone(this.cachedData);
    }

    private void select() throws WSHelper.WSException {
        DataSetSelect req = new DataSetSelect();
        req.setConnectionHandle(this.didInfos.getHandle(this.application));
        req.setDataSetName(this.datasetNameTarget.getDataSetName());
        DataSetSelectResponse res = (DataSetSelectResponse)this.didInfos.getDispatcher().safeDeliver(req);
        WSHelper.checkResult(res);
    }
}

