/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.keystore;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import org.openecard.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.openecard.bouncycastle.crypto.params.DHKeyParameters;
import org.openecard.bouncycastle.crypto.params.DSAKeyParameters;
import org.openecard.bouncycastle.crypto.params.ECKeyParameters;
import org.openecard.bouncycastle.crypto.params.ElGamalKeyParameters;
import org.openecard.bouncycastle.crypto.params.RSAKeyParameters;
import org.openecard.bouncycastle.tls.Certificate;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;
import org.openecard.crypto.common.keystore.KeyLengthException;

public class KeyTools {
    public static int getKeySize(Key key) {
        byte[] data;
        SecretKey sKey;
        if (key instanceof RSAKey) {
            RSAKey rsaPk = (RSAKey)((Object)key);
            BigInteger mod = rsaPk.getModulus();
            return mod.bitLength();
        }
        if (key instanceof DSAKey) {
            DSAKey dsaPk = (DSAKey)((Object)key);
            BigInteger p = dsaPk.getParams().getP();
            return p.bitLength();
        }
        if (key instanceof ECKey) {
            ECKey ecPk = (ECKey)((Object)key);
            BigInteger order = ecPk.getParams().getOrder();
            return order.bitLength();
        }
        if (key instanceof DHKey) {
            DHKey dhKey = (DHKey)((Object)key);
            BigInteger p = dhKey.getParams().getP();
            return p.bitLength();
        }
        if (key instanceof SecretKey && "RAW".equals((sKey = (SecretKey)key).getFormat()) && (data = sKey.getEncoded()) != null) {
            return data.length * 8;
        }
        return -1;
    }

    public static int getKeySize(AsymmetricKeyParameter key) {
        if (key instanceof RSAKeyParameters) {
            RSAKeyParameters rsaKey = (RSAKeyParameters)key;
            BigInteger mod = rsaKey.getModulus();
            return mod.bitLength();
        }
        if (key instanceof DSAKeyParameters) {
            DSAKeyParameters dsaKey = (DSAKeyParameters)key;
            BigInteger p = dsaKey.getParameters().getP();
            return p.bitLength();
        }
        if (key instanceof ECKeyParameters) {
            ECKeyParameters ecKey = (ECKeyParameters)key;
            BigInteger order = ecKey.getParameters().getCurve().getOrder();
            return order.bitLength();
        }
        if (key instanceof DHKeyParameters) {
            DHKeyParameters dhKey = (DHKeyParameters)key;
            BigInteger p = dhKey.getParameters().getP();
            return p.bitLength();
        }
        if (key instanceof ElGamalKeyParameters) {
            ElGamalKeyParameters egKey = (ElGamalKeyParameters)key;
            BigInteger p = egKey.getParameters().getP();
            return p.bitLength();
        }
        return -1;
    }

    public static int getReferenceKeySize(AsymmetricKeyParameter key) {
        int reference = -1;
        if (key instanceof RSAKeyParameters) {
            reference = 2048;
        } else if (key instanceof DSAKeyParameters) {
            reference = 2048;
        } else if (key instanceof DHKeyParameters) {
            reference = 2048;
        } else if (key instanceof ElGamalKeyParameters) {
            reference = 2048;
        } else if (key instanceof ECKeyParameters) {
            reference = 224;
        }
        return reference;
    }

    public static void assertKeyLength(@Nonnull AsymmetricKeyParameter key) throws KeyLengthException {
        int reference = KeyTools.getReferenceKeySize(key);
        int numbits = KeyTools.getKeySize(key);
        if (reference == -1) {
            throw new UnsupportedOperationException("The key type " + key.getClass().getName() + " is unsupported.");
        }
        if (numbits < reference) {
            String msg = "The key size does not meet the requirements ";
            msg = msg + String.format("(%d < %d).", numbits, reference);
            throw new KeyLengthException(msg);
        }
    }

    public static CertPath convertCertificates(Certificate chain) throws CertificateException, IOException {
        return KeyTools.convertCertificates(chain.getCertificateList());
    }

    public static CertPath convertCertificates(TlsCertificate ... chain) throws CertificateException, IOException {
        int numCerts = chain.length;
        ArrayList<java.security.cert.Certificate> result = new ArrayList<java.security.cert.Certificate>(numCerts);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        for (TlsCertificate next : chain) {
            byte[] nextData = next.getEncoded();
            ByteArrayInputStream nextDataStream = new ByteArrayInputStream(nextData);
            java.security.cert.Certificate nextConverted = cf.generateCertificate(nextDataStream);
            result.add(nextConverted);
        }
        return cf.generateCertPath(result);
    }
}

