/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.eac;

import org.openecard.bouncycastle.asn1.ASN1OctetString;
import org.openecard.bouncycastle.asn1.ASN1Sequence;

public final class FileID {
    private byte[] fid;
    private byte[] sfid;

    public FileID(ASN1Sequence seq) {
        if (seq.size() == 1) {
            this.fid = ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets();
        } else if (seq.size() == 2) {
            this.fid = ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets();
            this.sfid = ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets();
        } else {
            throw new IllegalArgumentException("Sequence wrong size for FileID");
        }
    }

    public static FileID getInstance(Object obj) {
        if (obj == null || obj instanceof FileID) {
            return (FileID)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new FileID((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Unknown object in factory: " + obj.getClass().getName());
    }

    public byte[] getFID() {
        return this.fid;
    }

    public byte[] getSFID() {
        return this.sfid;
    }
}

